/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.permission;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.Syncable;
import au.com.ordermate.util.JSONUtil;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.xmlintegration.ccpos.CCPosPermissionAccess;
import au.com.ordermate.xmlintegration.ccpos.CCPosPermissionGroup;
import au.com.ordermate.xmlintegration.ccpos.CCPosPermissionGroupLink;
import au.com.ordermate.xmlintegration.ccpos.CCPosTOS;
import au.com.ordermate.xmlintegration.ccpos.CCPosUser;
import au.com.ordermate.xmlintegration.ccpos.CCSyncMessage;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.datatype.XMLGregorianCalendar;
import ordermate.OrderMate;
import ordermate.database.misc.ConfigTermsOfService;
import ordermate.database.misc.ConfigTermsOfServiceUserLink;
import ordermate.database.misc.CustomParameter;
import ordermate.database.misc.StoreSync;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.users.Permission;
import ordermate.database.users.PermissionGroup;
import ordermate.database.users.PermissionGroupLink;
import ordermate.database.users.User;
import ordermate.integration.controlcenter.ControlCenterRequest;
import ordermate.integration.controlcenter.ControlCentreRequestFactory;
import ordermate.jaxb.exporter.XMLHelper;

public class StoreSyncManager {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock syncLock = this.readWriteLock.writeLock();
    private final Lock updateLock = this.readWriteLock.readLock();
    private static StoreSyncManager instance = new StoreSyncManager();
    private List<PermissionGroupLink> updateLinks = new CopyOnWriteArrayList<PermissionGroupLink>();
    private List<PermissionGroup> updatePermissionGroups = new CopyOnWriteArrayList<PermissionGroup>();
    private List<User> updateUsers = new CopyOnWriteArrayList<User>();
    private ControlCenterRequest controlCenterRequest = ControlCentreRequestFactory.getControlCentreRequest();
    private CopyOnWriteArrayList<CCSyncMessage> pendingCCSyncMessageList = new CopyOnWriteArrayList();
    private AtomicInteger failedRetryCount = new AtomicInteger(0);
    private final long storeId = SystemCurrentInfo.getInstance().getRedbackId();
    public static long updateCoolDownPeriod = 5000L;
    Timer timer;
    private SyncTask syncTask;
    private static final long ONE_MIN = 60000L;

    public static StoreSyncManager getInstance() {
        return instance;
    }

    private StoreSyncManager() {
    }

    private Date sendPendingMessages() throws Exception {
        ArrayList<CCSyncMessage> sendingMsgList = new ArrayList<CCSyncMessage>();
        for (CCSyncMessage posMessage : this.pendingCCSyncMessageList) {
            sendingMsgList.add(posMessage);
        }
        OrderMate.LOG.info("outging messages >: \n" + JSONUtil.toJson(sendingMsgList));
        this.controlCenterRequest.updateStore(sendingMsgList, this.storeId);
        CCSyncMessage lastMsg = (CCSyncMessage)sendingMsgList.get(sendingMsgList.size() - 1);
        Date lastSyncTime = new Date();
        if (lastMsg.getUpdatedTime() != null && lastMsg.getUpdatedTime().toGregorianCalendar().getTime().getTime() > 0L) {
            lastSyncTime = lastMsg.getUpdatedTime().toGregorianCalendar().getTime();
        }
        for (CCSyncMessage msg : sendingMsgList) {
            this.pendingCCSyncMessageList.remove(msg);
        }
        return lastSyncTime;
    }

    public void update(PersistentObject object) {
        if (!this.isStoreSyncEnabled()) {
            OrderMate.LOG.info("Will Not syncing user update to Redback. User/Permission Sync is disabled");
            return;
        }
        this.updateLock.lock();
        try {
            this.addToList(object);
            Syncable synable = (Syncable)((Object)object);
            this.updateLastUpdateTime(synable.getUpdateDate());
            if (this.syncTask == null) {
                this.syncTask = new SyncTask();
                this.scheduleTimerTask(this.syncTask, updateCoolDownPeriod);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Problem user/permission updating!", (Throwable)ex);
        }
        finally {
            this.updateLock.unlock();
        }
    }

    public List<User> getUserUpdates() {
        ArrayList<User> list = new ArrayList<User>();
        list.addAll(this.updateUsers);
        return list;
    }

    public List<PermissionGroup> getPermissionGroupUpdates() {
        ArrayList<PermissionGroup> list = new ArrayList<PermissionGroup>();
        list.addAll(this.updatePermissionGroups);
        return list;
    }

    public List<PermissionGroupLink> getLinksUpdates() {
        ArrayList<PermissionGroupLink> list = new ArrayList<PermissionGroupLink>();
        list.addAll(this.updateLinks);
        return list;
    }

    private void addToList(PersistentObject object) {
        if (object instanceof User) {
            this.updateUsers.add((User)object);
        } else if (object instanceof PermissionGroup) {
            this.updatePermissionGroups.add((PermissionGroup)object);
        } else if (object instanceof PermissionGroupLink) {
            this.updateLinks.add((PermissionGroupLink)object);
        }
    }

    private void scheduleTimerTask(TimerTask task, long delay) {
        try {
            if (this.timer == null) {
                OrderMate.LOG.info("Starting Sync User Updates Timer.");
                this.createTimer();
            }
            this.timer.schedule(task, delay);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("failed to schedule the timer task! Due to: " + ex.getMessage() + " A new Timer will be created.", (Throwable)ex);
            this.createTimer();
            this.timer.schedule(task, delay);
        }
    }

    private void createTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
        }
        this.timer = new Timer("Sync User Updates Timer");
        this.failedRetryCount.set(0);
        OrderMate.LOG.info("Sync User Updates Timer is started.");
    }

    private void sendUpdates() {
        block2: {
            try {
                Date lastSyncTime = this.sendPendingMessages();
                this.updateLastSyncTime(lastSyncTime);
                this.failedRetryCount.set(0);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Problem sync to redback.", (Throwable)ex);
                if (this.failedRetryCount.get() != 0) break block2;
                OrderMate.LOG.error("The faild message(s) will be resent immediately");
                this.scheduleTimerTask(new ResendTask(), 5000L);
                this.failedRetryCount.incrementAndGet();
            }
        }
    }

    public void performSync() {
        this.syncLock.lock();
        try {
            Date lastUpdateTime = this.getLastUpdateTime();
            if (this.updateLinks.isEmpty() && this.updatePermissionGroups.isEmpty() && this.updateUsers.isEmpty()) {
                return;
            }
            if (System.currentTimeMillis() - lastUpdateTime.getTime() < updateCoolDownPeriod) {
                return;
            }
            OrderMate.LOG.info("Sending user/permission updates to Redback.");
            CCSyncMessage cCSyncMessage = this.createCCSyncMessage(this.toXMLGregorianCalendar(lastUpdateTime), this.updateUsers, this.updatePermissionGroups, this.updateLinks);
            this.pendingCCSyncMessageList.add(cCSyncMessage);
        }
        finally {
            this.syncTask = null;
            this.syncLock.unlock();
        }
        this.sendUpdates();
    }

    public void clearUpdateLists() {
        this.updateLinks.clear();
        this.updatePermissionGroups.clear();
        this.updateUsers.clear();
    }

    public void clearPendingMessageList() {
        this.pendingCCSyncMessageList.clear();
    }

    public void scheduleSyncNow() {
        if (!this.isStoreSyncEnabled()) {
            OrderMate.LOG.info("Will Not Respond to the RedBack sync notification, User/Permission Sync is disabled");
            return;
        }
        OrderMate.LOG.info("Scheduling Store Sync in five seconds...");
        this.scheduleTimerTask(new SyncUpdatesAfterLastSyncTask(), 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CCSyncMessage getUserPermissions(StoreSync lastStoreSync) {
        this.syncLock.lock();
        try {
            CCSyncMessage cCSyncMessage;
            Date lastSyncTime = lastStoreSync.getLastUserSync();
            ArrayList<User> userList = new ArrayList();
            ArrayList<PermissionGroup> PermissionGroupList = new ArrayList();
            ArrayList<PermissionGroupLink> linksList = new ArrayList();
            if (lastSyncTime == null || lastSyncTime.getTime() == 0L) {
                userList = User.getAllUsersHasEmail();
                PermissionGroupList = PermissionGroup.getAllPermission();
                linksList = PermissionGroupLink.getAllPermissionGroupLink();
            } else {
                userList = User.getUsersUpdatedAfter(lastSyncTime);
                PermissionGroupList = PermissionGroup.getPermissionGroupUpdatedAfter(lastSyncTime);
                linksList = PermissionGroupLink.getPermissionGroupLinkUpdatedAfter(lastSyncTime);
            }
            CCSyncMessage cCSyncMessage2 = cCSyncMessage = this.createCCSyncMessage(this.toXMLGregorianCalendar(this.getUpdateDate(this.getLastUpdateTime())), userList, PermissionGroupList, linksList);
            return cCSyncMessage2;
        }
        finally {
            this.syncLock.unlock();
        }
    }

    public void updateUserPermissions(List<CCSyncMessage> incomingCCMessages) {
        Collections.sort(incomingCCMessages, new Comparator<CCSyncMessage>(){

            @Override
            public int compare(CCSyncMessage a, CCSyncMessage b) {
                if (a.getUpdatedTime() == null) {
                    a.setUpdatedTime(XMLHelper.getDateType(new Date(0L)));
                } else if (b.getUpdatedTime() == null) {
                    b.setUpdatedTime(XMLHelper.getDateType(new Date(0L)));
                }
                return a.getUpdatedTime().compare(b.getUpdatedTime());
            }
        });
        OrderMate.LOG.info("Incoming Updates Messages <: \n" + JSONUtil.toJson(incomingCCMessages));
        for (CCSyncMessage cCMessage : incomingCCMessages) {
            this.incomingUsers(cCMessage);
            this.incomingPermissionGroups(cCMessage);
            this.incomingTOS(cCMessage);
        }
    }

    public void incomingTOS(CCSyncMessage posMessage) {
        if (posMessage == null) {
            OrderMate.LOG.info("Cannot handle null CCSyncMessage");
            return;
        }
        ConfigTermsOfService currentTOS = ConfigTermsOfService.getLatestTOS();
        CCPosTOS incomingTOS = posMessage.getTos();
        if (currentTOS == null) {
            this.saveIncomingToS(incomingTOS);
        } else if (incomingTOS != null) {
            Date incomingCreatedAt = incomingTOS.getCreatedAt().toGregorianCalendar().getTime();
            if (currentTOS.getCreatedAt().before(incomingCreatedAt)) {
                this.saveIncomingToS(incomingTOS);
            }
        }
    }

    private void saveIncomingToS(CCPosTOS incomingTOS) {
        if (incomingTOS != null) {
            Date incomingCreatedAt = incomingTOS.getCreatedAt().toGregorianCalendar().getTime();
            ConfigTermsOfService localTOS = new ConfigTermsOfService();
            localTOS.setTOSVersion(incomingTOS.getVersion());
            localTOS.setCreatedAt(incomingCreatedAt);
            localTOS.setCreatedBy(incomingTOS.getCreatedBy());
            localTOS.setTermsOfService(incomingTOS.getTermsOfService());
            PersistenceManager.save(localTOS);
        }
    }

    private void incomingUsers(CCSyncMessage posMessage) {
        for (CCPosUser incomingUser : posMessage.getUsers()) {
            if (StringUtils.isEmpty(incomingUser.getEmail())) continue;
            User user = User.getUserByEmail(incomingUser.getEmail());
            if (user == null) {
                if (incomingUser.getEmail().length() < 5 || !incomingUser.getEmail().contains("@") || !incomingUser.getEmail().contains(".")) continue;
                user = new User();
                user.setUpdateDate(new Date(0L));
            }
            this.updateLocalUser(user, incomingUser);
            this.updateUserTosLink(user, incomingUser);
        }
    }

    private void updateUserTosLink(User user, CCPosUser incomingUser) {
        ConfigTermsOfServiceUserLink userlink = ConfigTermsOfServiceUserLink.getTOSLinkFromUser(user);
        if (userlink == null) {
            this.saveUserTosLink(user, incomingUser);
        } else if (incomingUser != null && incomingUser.getTosAgreedAt() != null) {
            Date incomingTosDate = incomingUser.getTosAgreedAt().toGregorianCalendar().getTime();
            if (userlink.getAgreedAt().before(incomingTosDate)) {
                this.saveUserTosLink(user, incomingUser);
            }
        }
    }

    private void saveUserTosLink(User user, CCPosUser ccPosUser) {
        if (ccPosUser != null && !StringUtils.isEmpty(ccPosUser.getTosVersion()) && ccPosUser.getTosAgreedAt() != null) {
            Date tosDate = ccPosUser.getTosAgreedAt().toGregorianCalendar().getTime();
            ConfigTermsOfServiceUserLink incomingUserLink = new ConfigTermsOfServiceUserLink(user, ccPosUser.getTosVersion());
            incomingUserLink.setAgreedAt(tosDate);
            PersistenceManager.save(incomingUserLink);
        }
    }

    private void updateLocalUser(User user, CCPosUser incomingUser) {
        if (user.getUpdateDate() == null) {
            user.setUpdateDate(new Date(0L));
        }
        if (incomingUser.getUpdatedTime() != null && incomingUser.getUpdatedTime().toGregorianCalendar().getTime().after(user.getUpdateDate())) {
            user.setActive(incomingUser.isActive() == null ? false : Boolean.TRUE.equals(incomingUser.isActive()));
            user.setDateOfBirth(incomingUser.getDateOfBirth() == null ? new Date(0L) : new Date(incomingUser.getDateOfBirth().getMillisecond()));
            user.setDriver(incomingUser.isDriver() == null ? false : Boolean.TRUE.equals(incomingUser.isDriver()));
            user.setEmail(incomingUser.getEmail());
            user.setFirstName(incomingUser.getFirstName() == null ? "" : incomingUser.getFirstName());
            user.setLastName(incomingUser.getLastName() == null ? "" : incomingUser.getLastName());
            user.setFloatAmount(incomingUser.getFloatAmount() == null ? 0.0 : incomingUser.getFloatAmount().doubleValue());
            user.setHidden(incomingUser.isHidden() == null ? false : Boolean.TRUE.equals(incomingUser.isHidden()));
            user.setMobile(incomingUser.getMobile() == null ? "" : incomingUser.getMobile());
            user.setPassword(incomingUser.getPassword() == null ? "" : incomingUser.getPassword());
            user.setPayrollID(incomingUser.getPayrollId() == null ? "" : incomingUser.getPayrollId());
            user.setPerDeliveryRate(incomingUser.getPerDeliveryRate() == null ? Price.ZERO_DOLLAR : new Price(incomingUser.getPerDeliveryRate().doubleValue()));
            PermissionGroup permissionGroup = null;
            if (incomingUser.getPermissionGroupLevel() != null) {
                permissionGroup = PermissionGroup.getPermissionGroupByLevel(incomingUser.getPermissionGroupLevel().intValue());
            }
            user.setPermissionGroup(permissionGroup);
            user.setPin(incomingUser.getPin() == null ? "" : incomingUser.getPin());
            user.setProximityBand(incomingUser.getProximityBand());
            user.setSystemState(incomingUser.getSystemState() == null ? "ACTIVE" : incomingUser.getSystemState());
            user.setUpdateDate(incomingUser.getUpdatedTime() != null ? incomingUser.getUpdatedTime().toGregorianCalendar().getTime() : new Date());
            user.setEmailVerified(incomingUser.isEmailVerified());
            PersistenceManager.save(user);
        }
    }

    void incomingPermissionGroups(CCSyncMessage redbackMessage) {
        for (CCPosPermissionGroup incomingGroup : redbackMessage.getPermissionGroups()) {
            PermissionGroup group = PermissionGroup.getPermissionGroupByLevel(incomingGroup.getLevel().intValue());
            if (group == null) {
                group = new PermissionGroup();
                group.setUpdateDate(new Date(0L));
            }
            this.updateLocalPermissionGroup(group, incomingGroup);
            for (CCPosPermissionGroupLink incomingLink : incomingGroup.getLinks()) {
                Permission permission = Permission.getPermissionByName(incomingLink.getLabel());
                if (permission == null) continue;
                PermissionGroupLink link = PermissionGroupLink.getPermissionGroupLink(group, permission);
                if (link == null) {
                    link = new PermissionGroupLink();
                    link.setUpdateDate(new Date(0L));
                }
                this.updateLocalPermissionGroupLink(link, incomingLink, permission, group);
            }
        }
    }

    private void updateLocalPermissionGroupLink(PermissionGroupLink link, CCPosPermissionGroupLink incomingLink, Permission permission, PermissionGroup group) {
        if (link.getUpdateDate() == null) {
            link.setUpdateDate(new Date(0L));
        }
        if (incomingLink.getUpdatedTime().toGregorianCalendar().getTime().after(link.getUpdateDate())) {
            link.setPermission(permission);
            link.setPermissionGroup(group);
            link.setAccessLevel(incomingLink.getAccess().name());
            link.setUpdateDate(incomingLink.getUpdatedTime() != null ? incomingLink.getUpdatedTime().toGregorianCalendar().getTime() : new Date());
            PersistenceManager.saveChild(link);
        }
    }

    private void updateLocalPermissionGroup(PermissionGroup permissionGroup, CCPosPermissionGroup incomingGroup) {
        if (permissionGroup.getUpdateDate() == null) {
            permissionGroup.setUpdateDate(new Date(0L));
        }
        if (incomingGroup.getUpdatedTime().toGregorianCalendar().getTime().after(permissionGroup.getUpdateDate())) {
            permissionGroup.setAliasLabel(incomingGroup.getAliasLabel());
            if (incomingGroup.getLabel() != null) {
                permissionGroup.setLabel(incomingGroup.getLabel());
            }
            permissionGroup.setLevel(incomingGroup.getLevel().intValue());
            permissionGroup.setUpdateDate(incomingGroup.getUpdatedTime() != null ? incomingGroup.getUpdatedTime().toGregorianCalendar().getTime() : new Date());
            PersistenceManager.save(permissionGroup);
        }
    }

    private XMLGregorianCalendar toXMLGregorianCalendar(Date date) {
        return XMLHelper.getDateType(date == null ? new Date(0L) : date);
    }

    public CCSyncMessage createCCSyncMessage(XMLGregorianCalendar lastUpdatedTime, List<User> userList, List<PermissionGroup> PermissionGroupList, List<PermissionGroupLink> linksList) {
        Date now = new Date();
        CCSyncMessage msg = new CCSyncMessage();
        msg.setMessageDate(this.toXMLGregorianCalendar(now));
        msg.setStoreId(this.storeId);
        msg.setUpdatedTime(lastUpdatedTime);
        msg.getUsers().addAll(this.getCCPosUser(userList));
        msg.getPermissionGroups().addAll(this.getPermissionGroups(PermissionGroupList, linksList));
        this.clearUpdateLists();
        return msg;
    }

    private List<CCPosUser> getCCPosUser(List<User> userList) {
        ArrayList<CCPosUser> cCPosUsersList = new ArrayList<CCPosUser>();
        for (User user : userList) {
            if (StringUtils.isEmpty(user.getEmail())) continue;
            CCPosUser cCPosUser = new CCPosUser();
            cCPosUser.setActive(Boolean.valueOf(user.isActive()));
            cCPosUser.setDateOfBirth(this.toXMLGregorianCalendar(user.getDateOfBirth()));
            cCPosUser.setDriver(Boolean.valueOf(user.isDriver()));
            cCPosUser.setEmail(user.getEmail());
            cCPosUser.setFirstName(user.getFirstName());
            cCPosUser.setLastName(user.getLastName());
            cCPosUser.setFloatAmount(user.getFloatAmount().toBigDecimal());
            cCPosUser.setHidden(Boolean.valueOf(user.isHidden()));
            cCPosUser.setMobile(user.getMobile());
            cCPosUser.setPassword(user.getPassword());
            cCPosUser.setPayrollId(user.getPayrollID());
            cCPosUser.setPerDeliveryRate(user.getPerDeliveryRate().toBigDecimal());
            if (user.getPermissionGroup() != null) {
                cCPosUser.setPermissionGroupLevel(BigInteger.valueOf(user.getPermissionGroup().getLevel()));
            }
            cCPosUser.setPin(user.getPin());
            cCPosUser.setProximityBand(user.getProximityBand());
            cCPosUser.setSystemState(user.getSystemState());
            cCPosUser.setUpdatedTime(this.toXMLGregorianCalendar(this.getUpdateDate(user.getUpdateDate())));
            ConfigTermsOfServiceUserLink tosLink = ConfigTermsOfServiceUserLink.getTOSLinkFromUser(user);
            if (tosLink != null) {
                cCPosUser.setTosAgreedAt(this.toXMLGregorianCalendar(tosLink.getAgreedAt()));
                cCPosUser.setTosVersion(tosLink.getTOSVersion());
            }
            cCPosUsersList.add(cCPosUser);
        }
        return cCPosUsersList;
    }

    private Map<Integer, List<PermissionGroupLink>> toLinkMap(List<PermissionGroupLink> linksList) {
        HashMap<Integer, List<PermissionGroupLink>> result = new HashMap<Integer, List<PermissionGroupLink>>();
        for (PermissionGroupLink link : linksList) {
            PermissionGroup pg = link.getPermissionGroup();
            if (pg == null) continue;
            Integer level = pg.getLevel();
            if (result.get(level) == null) {
                result.put(level, new ArrayList());
            }
            List PermissionGroupLinks = (List)result.get(level);
            PermissionGroupLinks.add(link);
        }
        return result;
    }

    private List<CCPosPermissionGroup> getPermissionGroups(List<PermissionGroup> PermissionGroupList, List<PermissionGroupLink> linksList) {
        ArrayList<CCPosPermissionGroup> cCPosPermissionGroupList = new ArrayList<CCPosPermissionGroup>();
        Map<Integer, List<PermissionGroupLink>> linkMap = this.toLinkMap(linksList);
        for (PermissionGroup permissionGroup : PermissionGroupList) {
            CCPosPermissionGroup cCPosPermissionGroup = new CCPosPermissionGroup();
            cCPosPermissionGroup.setAliasLabel(permissionGroup.getAliasLabel());
            cCPosPermissionGroup.setLabel(permissionGroup.getLabel());
            cCPosPermissionGroup.setLevel(BigInteger.valueOf(permissionGroup.getLevel()));
            cCPosPermissionGroup.setUpdatedTime(this.toXMLGregorianCalendar(this.getUpdateDate(permissionGroup.getUpdateDate())));
            cCPosPermissionGroupList.add(cCPosPermissionGroup);
        }
        HashMap<Integer, CCPosPermissionGroup> cCPosPermissionGroupMap = new HashMap<Integer, CCPosPermissionGroup>();
        for (CCPosPermissionGroup cCPosPermissionGroup : cCPosPermissionGroupList) {
            cCPosPermissionGroupMap.put(cCPosPermissionGroup.getLevel().intValue(), cCPosPermissionGroup);
        }
        for (Map.Entry entry : linkMap.entrySet()) {
            Integer level = (Integer)entry.getKey();
            List pgLinkList = (List)entry.getValue();
            if (cCPosPermissionGroupMap.get(level) == null) {
                PermissionGroup permissionGroup = PermissionGroup.getPermissionGroupByLevel(level);
                if (permissionGroup == null) continue;
                CCPosPermissionGroup cCPosPermissionGroup = new CCPosPermissionGroup();
                cCPosPermissionGroup.setAliasLabel(permissionGroup.getAliasLabel());
                cCPosPermissionGroup.setLabel(permissionGroup.getLabel());
                cCPosPermissionGroup.setLevel(BigInteger.valueOf(permissionGroup.getLevel()));
                cCPosPermissionGroup.setUpdatedTime(this.toXMLGregorianCalendar(this.getUpdateDate(permissionGroup.getUpdateDate())));
                cCPosPermissionGroupList.add(cCPosPermissionGroup);
                cCPosPermissionGroupMap.put(level, cCPosPermissionGroup);
            }
            CCPosPermissionGroup cCPosPermissionGroup = (CCPosPermissionGroup)cCPosPermissionGroupMap.get(level);
            List<CCPosPermissionGroupLink> CCPosPermissionGroupLinks = this.getCCPosPermissionGroupLinks(pgLinkList);
            cCPosPermissionGroup.getLinks().addAll(CCPosPermissionGroupLinks);
        }
        return cCPosPermissionGroupList;
    }

    private Date getUpdateDate(Date updateDate) {
        if (updateDate == null || updateDate.getTime() == 0L) {
            return new Date(1000L);
        }
        return updateDate;
    }

    private List<CCPosPermissionGroupLink> getCCPosPermissionGroupLinks(List<PermissionGroupLink> PermissionGroupLinks) {
        ArrayList<CCPosPermissionGroupLink> cCPosPermissionGroupLinkList = new ArrayList<CCPosPermissionGroupLink>();
        for (PermissionGroupLink pgLink : PermissionGroupLinks) {
            CCPosPermissionGroupLink cCPosPermissionGroupLink = new CCPosPermissionGroupLink();
            cCPosPermissionGroupLink.setLabel(pgLink.getPermission().getName());
            cCPosPermissionGroupLink.setAccess(CCPosPermissionAccess.fromValue((String)pgLink.getAccessLevel()));
            cCPosPermissionGroupLink.setUpdatedTime(this.toXMLGregorianCalendar(this.getUpdateDate(pgLink.getUpdateDate())));
            cCPosPermissionGroupLinkList.add(cCPosPermissionGroupLink);
        }
        return cCPosPermissionGroupLinkList;
    }

    private void updateLastSyncTime(Date syncTime) {
        StoreSync storeSync = StoreSync.getStoreSync();
        storeSync.setLastUserSync(syncTime);
        storeSync.save();
    }

    private void updateLastUpdateTime(Date updateDate) {
        StoreSync storeSync = StoreSync.getStoreSync();
        storeSync.setLastUserUpdate(updateDate);
        storeSync.save();
    }

    private Date getLastUpdateTime() {
        StoreSync storeSync = StoreSync.getStoreSync();
        return storeSync.getLastUserUpdate();
    }

    public boolean isStoreSyncEnabled() {
        CustomParameter param = CustomParameter.getCustomParameter("StoreSync", "Enabled");
        if (param == null) {
            return false;
        }
        return param.getBoolean(Boolean.FALSE);
    }

    class SyncUpdatesAfterLastSyncTask
    extends TimerTask {
        SyncUpdatesAfterLastSyncTask() {
        }

        @Override
        public void run() {
            StoreSyncManager.this.syncLock.lock();
            try {
                StoreSync lastStoreSync = StoreSync.getStoreSync();
                OrderMate.LOG.info("Start syncing all updates after last sync time(" + lastStoreSync.getLastUserSync() + ") to Redback.");
                CCSyncMessage cCSyncMessage = StoreSyncManager.this.getUserPermissions(lastStoreSync);
                StoreSyncManager.this.pendingCCSyncMessageList.add(cCSyncMessage);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Problem while syncing to Redback!", (Throwable)ex);
            }
            finally {
                StoreSyncManager.this.syncLock.unlock();
            }
            StoreSyncManager.this.sendUpdates();
        }
    }

    class ResendTask
    extends TimerTask {
        ResendTask() {
        }

        @Override
        public void run() {
            try {
                OrderMate.LOG.info("Resending updates. Retry Count(" + StoreSyncManager.this.failedRetryCount.get() + ")");
                if (!StoreSyncManager.this.pendingCCSyncMessageList.isEmpty()) {
                    Date lastSyncTime = StoreSyncManager.this.sendPendingMessages();
                    StoreSyncManager.this.updateLastSyncTime(lastSyncTime);
                    StoreSyncManager.this.failedRetryCount.set(0);
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Problem while resending failed UserPermissionUpdates", (Throwable)ex);
                if (StoreSyncManager.this.failedRetryCount.get() > 30 || StoreSyncManager.this.pendingCCSyncMessageList.size() > 1500) {
                    OrderMate.LOG.info("Retried for too many times or too many failed messages, clear the pending list and give up. RetryCount(" + StoreSyncManager.this.failedRetryCount.get() + ") Pending list size(" + StoreSyncManager.this.pendingCCSyncMessageList.size() + ")");
                    StoreSyncManager.this.pendingCCSyncMessageList.clear();
                    StoreSyncManager.this.failedRetryCount.set(0);
                    return;
                }
                long delayedMins = 1 << Math.min(StoreSyncManager.this.failedRetryCount.get(), 6);
                long scheduleDelay = delayedMins * 60000L;
                OrderMate.LOG.info("Failed massages will be resent in " + delayedMins + " mins. RetryCount(" + StoreSyncManager.this.failedRetryCount.get() + ") Pending list size(" + StoreSyncManager.this.pendingCCSyncMessageList.size() + ")");
                StoreSyncManager.this.scheduleTimerTask(new ResendTask(), scheduleDelay);
                StoreSyncManager.this.failedRetryCount.incrementAndGet();
            }
        }
    }

    class SyncTask
    extends TimerTask {
        SyncTask() {
        }

        @Override
        public void run() {
            try {
                StoreSyncManager.this.performSync();
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Problem while performSync()", (Throwable)ex);
            }
        }
    }
}

