/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.piggy;

import au.com.ordermate.piggy.PiggyRequestBuilder;
import au.com.ordermate.util.Pair;
import au.com.ordermate.xmlintegration.piggy.GuestItem;
import au.com.ordermate.xmlintegration.piggy.PiggyRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.Date;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.integration.piggy.PiggyConfig;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.misc.TradingDayQueries;
import ordermate.integration.piggy.PiggyDataHelper;
import ordermate.integration.piggy.PiggyWebResourceHelper;

public class NonRoomSalesExporter {
    private static final String PATH = "integrator/v1/pushNonRoomSales";
    private PiggyConfig piggyConfig = PiggyConfig.getConfig();

    public boolean canExport() {
        if (!this.piggyConfig.isEnabled()) {
            OrderMate.LOG.info("Cannot push Non Room Sales if Piggy is disabled");
            return false;
        }
        return true;
    }

    public PiggyConfig getPiggyConfig() {
        return this.piggyConfig;
    }

    public boolean performExport(Date date) {
        Date pushDate = date;
        if (pushDate == null) {
            pushDate = TradingDayQueries.getLastClosedTradingDay().getDate();
        }
        TradingDay tradingDay = TradingDayQueries.getTradingDay(pushDate);
        OrderMate.LOG.info("Performing Push Non Room Sales to Piggy for " + pushDate);
        if (tradingDay == null) {
            OrderMate.LOG.info("No trading day for date " + pushDate);
            this.piggyConfig.setLastPushDate(pushDate);
            this.piggyConfig.save();
            return true;
        }
        PiggyDataHelper piggyDataHelper = new PiggyDataHelper();
        List<GuestItem> nonRoomAccountSales = piggyDataHelper.getNonRoomAccountSales(tradingDay);
        boolean exported = this.exportData(nonRoomAccountSales);
        if (exported) {
            this.piggyConfig.setLastPushDate(pushDate);
            this.piggyConfig.save();
        }
        return exported;
    }

    public boolean exportData(List<GuestItem> dataList) {
        boolean fine = false;
        Long cashAccountId = SystemProperty.getInstance().getRmsCashAccountId();
        PiggyRequestBuilder piggyRequestBuilder = new PiggyRequestBuilder();
        piggyRequestBuilder.setStoreId(SystemCurrentInfo.getInstance().getRedbackId());
        piggyRequestBuilder.setAccountId(cashAccountId);
        piggyRequestBuilder.setNonRoomAccountSales(dataList);
        PiggyRequest piggyRequest = piggyRequestBuilder.buildPushNonRoomSales();
        PiggyWebResourceHelper webResourceHelper = new PiggyWebResourceHelper();
        try {
            WebResource.Builder resource = webResourceHelper.setupResource(PATH, new Pair[0]);
            ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)resource.entity((Object)piggyRequest)).post(ClientResponse.class);
            if (clientResponse.getStatus() / 100 == 2) {
                fine = true;
            } else {
                OrderMate.LOG.warn("Push Non Room Sales to Piggy failed: " + clientResponse.getStatus() + " " + (String)clientResponse.getEntity(String.class));
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot Push Non Room Sales to Piggy", (Throwable)ex);
        }
        return fine;
    }
}

