/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.piggy;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.JSONUtil;
import au.com.ordermate.xmlintegration.piggy.GuestItem;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.misc.DayPart;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.misc.TradingDayQueries;
import ordermate.database.queries.sales.AccountQueries;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountState;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;

public class PiggyDataHelper {
    public List<GuestItem> getNonRoomAccountSales(TradingDay tradingDay) {
        TradingDay tday = tradingDay;
        ArrayList<GuestItem> result = new ArrayList<GuestItem>();
        if (tday == null) {
            tday = TradingDayQueries.getLastClosedTradingDay();
        }
        ObjectQuery query = Query.select(SalesItemQuantity.class).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM, SalesItem.Properties.ID).equals(SalesItemQuantity.Properties.TRADING_DAY, tday).whereFunction("sales_item.type = 'SalesItem' ").orderBy(SalesItemQuantity.Properties.ID);
        List<SalesItemQuantity> qtys = PersistenceManager.getObjectList(SalesItemQuantity.class, query.toString());
        Date now = new Date();
        for (SalesItemQuantity qty : qtys) {
            SalesLineItem salesLineItem = qty.getSalesLineItem();
            Account account = salesLineItem.getAccount();
            if (account.getAccountState() != AccountState.CLOSED || account.getUniqueDebtorSale() != null) continue;
            DayPart dayPart = DayPart.getDayPart(qty.getCreationTime());
            SalesItem saleItem = salesLineItem.getSalesItems().get(0);
            SalesComponent salesComponent = saleItem.getComponentList().get(0);
            InventoryCategory category = salesComponent.getInventoryItem().getCategory();
            SalesLocation salesLocaltion = qty.getSalesLocation();
            GuestItem guestItem = new GuestItem();
            guestItem.setDayPart(dayPart.getLabel());
            guestItem.setCategory(category.getID().longValue());
            guestItem.setSalesLocation(salesLocaltion.getLabel());
            guestItem.setLabel(saleItem.getLabel());
            BigDecimal unitPrice = new BigDecimal(salesComponent.getSavedUnitPrice().doubleValue());
            BigDecimal price = unitPrice.multiply(qty.getQuantity().getValue()).setScale(5, 6);
            guestItem.setPrice(price);
            guestItem.setDate(Long.valueOf(now.getTime()));
            result.add(guestItem);
        }
        List<Account> closedAccs = AccountQueries.getClosedAccounts(tradingDay);
        for (Account account : closedAccs) {
            DebtorSale debtorSale = account.getUniqueDebtorSale();
            if (debtorSale == null || account.getTotal().compareTo(debtorSale.getTotal()) == 0) continue;
            BigDecimal total = new BigDecimal(account.getTotal().doubleValue());
            BigDecimal totalPaidToRoomAcc = new BigDecimal(debtorSale.getTotal().doubleValue());
            BigDecimal price = total.subtract(totalPaidToRoomAcc).setScale(5, 6);
            GuestItem guestItem = new GuestItem();
            guestItem.setDayPart(null);
            guestItem.setCategory(-1L);
            guestItem.setLabel("Partial Order Payment");
            guestItem.setPrice(price);
            guestItem.setDate(Long.valueOf(now.getTime()));
            result.add(guestItem);
        }
        OrderMate.LOG.info("Sending RMS Non-Room Sales for Trading Day " + tday + ".\n" + JSONUtil.toJson(result));
        return result;
    }
}

