/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.piggy;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.piggy.PiggyRequestBuilder;
import au.com.ordermate.util.JSONUtil;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.Price;
import au.com.ordermate.xmlintegration.piggy.GuestCharge;
import au.com.ordermate.xmlintegration.piggy.GuestInquiry;
import au.com.ordermate.xmlintegration.piggy.GuestItem;
import au.com.ordermate.xmlintegration.piggy.GuestSuggestion;
import au.com.ordermate.xmlintegration.piggy.PiggyRequest;
import au.com.ordermate.xmlintegration.piggy.PiggyResponse;
import au.com.ordermate.xmlintegration.piggy.SearchType;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.net.ConnectException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.ws.rs.core.MediaType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import ordermate.OrderMate;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.integration.piggy.PiggyConfig;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.misc.DayPart;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.integration.piggy.PiggyResult;
import ordermate.integration.piggy.PiggyService;
import ordermate.integration.webservice.PassthroughX509TrustManager;
import ordermate.integration.webservice.RestHelper;
import org.w3c.dom.Document;

public class PiggyServiceImpl
implements PiggyService {
    private static final Integer TIMEOUT_MILLISECS = 10000;
    private static final String SEARCH_PATH = "integrator/v1/inquiry";
    private static final String CHARGE_PATH = "integrator/v1/charge";
    private static final String RESERVATION_PATH = "integrator/v1/reservation";
    private static final String REFUNDSALES_PATH = "integrator/v1/refundSales";
    private static final String REFUNDPAYMENT_PATH = "integrator/v1/refundPayment";
    private static final String PIGGY_SERVICE_CALLING_SENDING_REQUEST_TO = "Cloud Property Integration Service calling sending request to ";
    private static final String HTTPS = "https";
    private static final String SEARCH_FAILED = "Search Failed : ";
    private static final String ROOM_CHARGING_SERVICE_IS_UNAVAILABLE_PLEASE_USE_OTHER_PAYMENT_METHODS = "Room Charging Service is unavailable.  Please use other payment methods.";
    private static final Long FOODSUNDRYID = 1335L;
    private static final Long CREDITNOTESUNDRYID = 1354L;
    private static final String TIPS = "Tips";
    private PiggyRequest searchRequest;
    private PiggyResponse successfulSearchResponse;
    private final Long terminalId;
    private final String terminalName;
    private final Long storeId;

    public PiggyServiceImpl(Long terminalId, String terminalName, Long storeId) {
        this.terminalId = terminalId;
        this.terminalName = terminalName;
        this.storeId = storeId;
    }

    private void ignoreAllSSLErrors() {
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
    }

    private WebResource.Builder setupResource(String path, Pair ... queryParams) {
        WebResource resource;
        RestHelper rest = new RestHelper();
        PiggyConfig piggyConfig = PiggyConfig.getConfig();
        String destination = piggyConfig.getWebConfig().getUrl() + path;
        OrderMate.LOG.info(PIGGY_SERVICE_CALLING_SENDING_REQUEST_TO + destination);
        if (destination.startsWith(HTTPS)) {
            this.ignoreAllSSLErrors();
            resource = rest.getSslResource(destination, new PiggyTrustManager(), TIMEOUT_MILLISECS, TIMEOUT_MILLISECS);
        } else {
            resource = rest.getResource(destination, TIMEOUT_MILLISECS, TIMEOUT_MILLISECS);
        }
        resource = rest.addBasicAuth(resource, piggyConfig.getWebConfig().getUsername(), piggyConfig.getWebConfig().getPassword());
        for (Pair pair : queryParams) {
            resource = rest.addParameter(resource, String.valueOf(pair.key), String.valueOf(pair.value));
        }
        return resource.getRequestBuilder();
    }

    private PiggyResult doSearchAndReturnResult(String searchCriteria, SearchType searchType) throws Exception {
        PiggyRequestBuilder piggyRequestBuilder = new PiggyRequestBuilder();
        Object piggyResponse = null;
        Object clientResponse = null;
        Object piggyResult = null;
        GuestInquiry guestInquiry = new GuestInquiry();
        guestInquiry.setGuestNamePrefix(searchCriteria);
        piggyRequestBuilder.setSearchType(searchType);
        piggyRequestBuilder.setGuestInquiry(guestInquiry);
        piggyRequestBuilder.setStoreId(SystemCurrentInfo.getInstance().getRedbackId());
        piggyRequestBuilder.setAccountId(Long.valueOf(1L));
        piggyRequestBuilder.setTerminalId(this.getTerminalId().longValue());
        piggyRequestBuilder.setRequestDate(new Date().getTime());
        piggyRequestBuilder.setWorkstationId(this.getTerminalName());
        this.searchRequest = piggyRequestBuilder.buildForGuestInquiry();
        return this.retrieveInfoFromPiggy(SEARCH_PATH);
    }

    @Override
    public PiggyResult retrieveReservationDetail(String reservationID) throws Exception {
        PiggyRequestBuilder piggyRequestBuilder = new PiggyRequestBuilder();
        GuestCharge guestCharge = new GuestCharge();
        guestCharge.setReservationId(reservationID);
        piggyRequestBuilder.setGuestCharge(guestCharge);
        piggyRequestBuilder.setStoreId(SystemCurrentInfo.getInstance().getRedbackId());
        piggyRequestBuilder.setAccountId(Long.valueOf(-1L));
        piggyRequestBuilder.setRequestDate(new Date().getTime());
        this.searchRequest = piggyRequestBuilder.buildForGuestCharge();
        return this.retrieveInfoFromPiggy(RESERVATION_PATH);
    }

    private PiggyResult retrieveInfoFromPiggy(String path) {
        PiggyResponse piggyResponse = null;
        ClientResponse clientResponse = null;
        PiggyResult piggyResult = null;
        try {
            WebResource.Builder resource = this.setupResource(path, new Pair[0]);
            clientResponse = (ClientResponse)((WebResource.Builder)((WebResource.Builder)resource.entity((Object)this.searchRequest)).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE})).post(ClientResponse.class);
            if (clientResponse.getStatus() == ClientResponse.Status.OK.getStatusCode()) {
                this.successfulSearchResponse = (PiggyResponse)clientResponse.getEntity(PiggyResponse.class);
                piggyResult = new PiggyResult(ClientResponse.Status.OK.getStatusCode(), ClientResponse.Status.OK.getReasonPhrase(), this.successfulSearchResponse, null);
            } else {
                try {
                    String errorMessage = (String)clientResponse.getEntity(String.class);
                    piggyResponse = new PiggyResponse();
                    piggyResponse.setResponseDate(new Date().getTime());
                    piggyResponse.setSuccess(false);
                    OrderMate.LOG.error(this.getErrorMessage(errorMessage));
                    OrderMate.LOG.error("Response Code : " + clientResponse.getStatus());
                    OrderMate.LOG.error("Error Message : " + errorMessage);
                    piggyResult = new PiggyResult(clientResponse.getStatus(), errorMessage, piggyResponse, null);
                }
                catch (Exception ex) {
                    this.logException(ex);
                    String errorMessage = (String)clientResponse.getEntity(String.class);
                    OrderMate.LOG.error(SEARCH_FAILED + errorMessage);
                    piggyResponse = new PiggyResponse();
                    piggyResponse.setResponseDate(new Date().getTime());
                    piggyResponse.setSuccess(false);
                    piggyResult = new PiggyResult(ClientResponse.Status.INTERNAL_SERVER_ERROR.getStatusCode(), errorMessage, piggyResponse, new Exception(errorMessage));
                }
            }
        }
        catch (Exception ex) {
            this.logException(ex);
            String errorMessage = this.getErrorMessage(ex);
            piggyResponse = new PiggyResponse();
            piggyResponse.setResponseDate(new Date().getTime());
            piggyResponse.setSuccess(false);
            piggyResult = new PiggyResult(ClientResponse.Status.INTERNAL_SERVER_ERROR.getStatusCode(), errorMessage, piggyResponse, ex);
        }
        return piggyResult;
    }

    private Long getTerminalId() {
        return this.terminalId;
    }

    private String getTerminalName() {
        return this.terminalName;
    }

    public Long getStoreId() {
        return this.storeId;
    }

    private String getErrorMessage(Exception ex) {
        if (ex instanceof ClientHandlerException) {
            if (ex.getMessage().contains("ConnectException")) {
                return "Please check if Piggy Service is available";
            }
        } else {
            if (ex.getCause() instanceof ConnectException) {
                return "Please check if Piggy Service is available";
            }
            if (ex.getMessage() == null) {
                return ROOM_CHARGING_SERVICE_IS_UNAVAILABLE_PLEASE_USE_OTHER_PAYMENT_METHODS;
            }
        }
        return ex.getMessage();
    }

    private String getErrorMessage(String xmlMessage) {
        String errorMessage = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlMessage.getBytes());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(bais);
            errorMessage = doc.getDocumentElement().getAttribute("description");
            OrderMate.LOG.info("getErrorMessage(xmlMessage) : " + errorMessage);
        }
        catch (Exception ex) {
            OrderMate.LOG.error(ex.getMessage(), (Throwable)ex);
            errorMessage = ROOM_CHARGING_SERVICE_IS_UNAVAILABLE_PLEASE_USE_OTHER_PAYMENT_METHODS;
        }
        return errorMessage;
    }

    private void logException(Exception ex) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] st = ex.getStackTrace();
        sb.append(ex.getClass().getName() + ": " + ex.getMessage() + "\n");
        for (StackTraceElement ste : st) {
            sb.append("\t at " + ste.getClassName() + "." + ste.getMethodName() + "(" + ste.getFileName() + ":" + ste.getLineNumber() + ")\n");
        }
        OrderMate.LOG.info(sb.toString());
    }

    @Override
    public PiggyResult searchGuest(String searchString, SearchType searchType) throws Exception {
        return this.doSearchAndReturnResult(searchString, searchType);
    }

    private int getMatchFromPostList(GuestSuggestion guestSuggestion) {
        if (this.successfulSearchResponse == null) {
            return -1;
        }
        List guestSuggestionList = this.successfulSearchResponse.getGuestSuggestions();
        for (int i = 0; i < guestSuggestionList.size(); ++i) {
            GuestSuggestion gs = (GuestSuggestion)guestSuggestionList.get(i);
            if (!Objects.deepEquals(gs, guestSuggestion)) continue;
            return i + 1;
        }
        return -1;
    }

    @Override
    public PiggyResult chargeGuest(Long accountId, GuestSuggestion guestSuggestion, BigDecimal totalAmount, List<SalesLineItem> salesItemList) {
        return this.salesOperationsInPiggy(accountId, guestSuggestion, totalAmount, null, salesItemList, CHARGE_PATH);
    }

    @Override
    public PiggyResult chargeGuest(Long accountId, GuestSuggestion guestSuggestion, BigDecimal totalAmount, BigDecimal tipAmount, List<SalesLineItem> salesItemList) {
        return this.salesOperationsInPiggy(accountId, guestSuggestion, totalAmount, tipAmount, salesItemList, CHARGE_PATH);
    }

    private List<GuestItem> getGuestItems(List<SalesLineItem> salesItemList, String path) {
        ArrayList<GuestItem> result = new ArrayList<GuestItem>();
        Date now = new Date();
        for (SalesLineItem itemL1 : salesItemList) {
            for (SalesItem itemL2 : itemL1.getSalesItems()) {
                for (SalesItemQuantity quantity : itemL2.getSalesItemQuantities()) {
                    Date quantityCreationTime = quantity.getCreationTime();
                    DayPart dayPart = DayPart.getDayPart(quantityCreationTime);
                    SalesLocation salesLocation = quantity.getSalesLocation();
                    GuestItem guestItem = new GuestItem();
                    guestItem.setDayPart(dayPart.getLabel());
                    SalesItem saleItem = quantity.getSalesLineItem().getSalesItems().get(0);
                    SalesComponent salesComponent = saleItem.getComponentList().get(0);
                    InventoryCategory category = salesComponent.getInventoryItem().getCategory();
                    guestItem.setCategory(category.getID().longValue());
                    guestItem.setSalesLocation(salesLocation.getLabel());
                    guestItem.setLabel(saleItem.getLabel());
                    BigDecimal unitPrice = new BigDecimal(salesComponent.getSavedUnitPrice().doubleValue());
                    BigDecimal qty = quantity.getQuantity().getValue();
                    if (path.equals(REFUNDSALES_PATH)) {
                        qty = qty.negate();
                    }
                    BigDecimal price = unitPrice.multiply(qty).setScale(5, 6);
                    guestItem.setPrice(price);
                    guestItem.setDate(Long.valueOf(now.getTime()));
                    guestItem.setCreationTime(Long.valueOf(quantityCreationTime.getTime()));
                    result.add(guestItem);
                }
            }
        }
        return result;
    }

    private GuestItem getGuestItemForPartialPay(Account account) {
        Date now = new Date();
        GuestItem guestItem = new GuestItem();
        guestItem.setDayPart(null);
        guestItem.setCategory(-1L);
        guestItem.setLabel("Partial Order Payment");
        BigDecimal price = new BigDecimal(account.getDue().doubleValue()).setScale(5, 6);
        guestItem.setPrice(price);
        guestItem.setDate(Long.valueOf(now.getTime()));
        guestItem.setCreationTime(Long.valueOf(account.getCreationDateTime().getTime()));
        return guestItem;
    }

    private GuestItem getGuestItemForTips(BigDecimal tipsAmount) {
        Date now = new Date();
        GuestItem guestItem = new GuestItem();
        guestItem.setDayPart(TIPS);
        guestItem.setCategory(-1L);
        guestItem.setLabel(TIPS);
        guestItem.setPrice(tipsAmount);
        guestItem.setDate(Long.valueOf(now.getTime()));
        guestItem.setCreationTime(Long.valueOf(now.getTime()));
        return guestItem;
    }

    private PiggyResult salesOperationsInPiggy(Long accountId, GuestSuggestion guestSuggestion, BigDecimal totalAmount, BigDecimal tipAmount, List<SalesLineItem> salesItemList, String path) {
        PiggyRequestBuilder piggyRequestBuilder = new PiggyRequestBuilder();
        PiggyResponse piggyResponse = null;
        PiggyResult piggyResult = null;
        ClientResponse clientResponse = null;
        GuestCharge guestCharge = new GuestCharge();
        guestCharge.setGuestName(guestSuggestion.getGuestName());
        guestCharge.setGuestNumber(guestSuggestion.getGuestNumber());
        guestCharge.setTotalBillAmount(totalAmount);
        if (path.equals(CHARGE_PATH)) {
            guestCharge.setMatchFromPostList(String.valueOf(this.getMatchFromPostList(guestSuggestion)));
        }
        if (path.equals(REFUNDPAYMENT_PATH)) {
            guestCharge.setReceiptType(guestSuggestion.getReceiptType());
        }
        guestCharge.setReservationId(guestSuggestion.getReservationId());
        guestCharge.setHotelId(guestSuggestion.getHotelId());
        guestCharge.setCheckNumber(accountId.toString());
        if (path.equals(CHARGE_PATH)) {
            GuestItem guestItem;
            Account account = PersistenceManager.getByID(accountId, Account.class);
            if (Price.ZERO_DOLLAR.compareTo(account.getDue()) != 0 && Price.ZERO_DOLLAR.compareTo(account.getPaid()) != 0) {
                guestItem = this.getGuestItemForPartialPay(account);
                guestCharge.getItems().add(guestItem);
            } else {
                List<GuestItem> guestItems = this.getGuestItems(salesItemList, path);
                guestCharge.getItems().addAll(guestItems);
            }
            if (tipAmount != null && BigDecimal.ZERO.compareTo(tipAmount) != 0) {
                guestItem = this.getGuestItemForTips(tipAmount);
                guestCharge.getItems().add(guestItem);
            }
        } else {
            List<GuestItem> guestItems = this.getGuestItems(salesItemList, path);
            guestCharge.getItems().addAll(guestItems);
        }
        if (path.equals(CHARGE_PATH)) {
            piggyRequestBuilder.setGuestInquiry(this.searchRequest.getGuestInquiry());
            piggyRequestBuilder.setSearchType(this.searchRequest.getSearchType());
        }
        piggyRequestBuilder.setStoreId(this.getStoreId().longValue());
        piggyRequestBuilder.setTerminalId(this.getTerminalId().longValue());
        piggyRequestBuilder.setAccountId(Long.valueOf(guestSuggestion.getRoomAccountId().intValue()));
        piggyRequestBuilder.setGuestCharge(guestCharge);
        piggyRequestBuilder.setRequestDate(new Date().getTime());
        piggyRequestBuilder.setRoomNumber(guestSuggestion.getRoomNumber());
        piggyRequestBuilder.setWorkstationId(this.getTerminalName());
        PiggyRequest piggyRequest = piggyRequestBuilder.buildForGuestCharge();
        OrderMate.LOG.info("Sending GuestCharge to Piggy Back:\n " + JSONUtil.toJson(piggyRequest));
        try {
            WebResource.Builder resource = this.setupResource(path, new Pair[0]);
            clientResponse = (ClientResponse)((WebResource.Builder)resource.entity((Object)piggyRequest)).post(ClientResponse.class);
            if (clientResponse.getStatus() == ClientResponse.Status.OK.getStatusCode()) {
                piggyResponse = (PiggyResponse)clientResponse.getEntity(PiggyResponse.class);
                piggyResult = piggyResponse.isSuccess() ? new PiggyResult(ClientResponse.Status.OK.getStatusCode(), ClientResponse.Status.OK.getReasonPhrase(), piggyResponse, null) : new PiggyResult(ClientResponse.Status.INTERNAL_SERVER_ERROR.getStatusCode(), piggyResponse.getDescription(), piggyResponse, new Exception(piggyResponse.getDescription()));
            } else {
                String stringResponse = (String)clientResponse.getEntity(String.class);
                piggyResponse = new PiggyResponse();
                piggyResponse.setDescription(this.getErrorMessage(stringResponse));
                piggyResponse.setResponseDate(new Date().getTime());
                piggyResponse.setSuccess(false);
                OrderMate.LOG.error(this.getErrorMessage(stringResponse));
                OrderMate.LOG.error("Response Code : " + clientResponse.getStatus());
                OrderMate.LOG.error("Error Message : " + stringResponse);
                piggyResult = new PiggyResult(ClientResponse.Status.INTERNAL_SERVER_ERROR.getStatusCode(), piggyResponse.getDescription(), piggyResponse, new Exception(piggyResponse.getDescription()));
            }
        }
        catch (Exception ex) {
            this.logException(ex);
            piggyResponse = new PiggyResponse();
            piggyResponse.setResponseDate(new Date().getTime());
            piggyResponse.setDescription(this.getErrorMessage(ex));
            piggyResponse.setSuccess(false);
            piggyResult = new PiggyResult(ClientResponse.Status.INTERNAL_SERVER_ERROR.getStatusCode(), ex.getMessage(), piggyResponse, ex);
        }
        return piggyResult;
    }

    @Override
    public PiggyResult refundSale(Long accountId, GuestSuggestion guestSuggestion, List<SalesLineItem> salesItemList) {
        return this.salesOperationsInPiggy(accountId, guestSuggestion, null, null, salesItemList, REFUNDSALES_PATH);
    }

    @Override
    public PiggyResult refundPayment(Long accountId, GuestSuggestion guestSuggestion, BigDecimal totalAmount) {
        return this.salesOperationsInPiggy(accountId, guestSuggestion, totalAmount, null, null, REFUNDPAYMENT_PATH);
    }

    private class PiggyTrustManager
    extends PassthroughX509TrustManager {
        private PiggyTrustManager() {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

