/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.piggy;

import au.com.ordermate.util.Pair;
import com.sun.jersey.api.client.WebResource;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import ordermate.OrderMate;
import ordermate.database.integration.piggy.PiggyConfig;
import ordermate.integration.webservice.PassthroughX509TrustManager;
import ordermate.integration.webservice.RestHelper;

public class PiggyWebResourceHelper {
    private static final String PIGGY_SERVICE_CALLING_SENDING_REQUEST_TO = "Cloud Property Integration Service calling sending request to ";
    private static final String HTTPS = "https";
    private static final int TIMEOUT_MILLISECS = 30000;

    private void ignoreAllSSLErrors() {
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
    }

    public WebResource.Builder setupResource(String path, Pair ... queryParams) {
        WebResource resource;
        RestHelper rest = new RestHelper();
        PiggyConfig piggyConfig = PiggyConfig.getConfig();
        String destination = piggyConfig.getWebConfig().getUrl() + path;
        OrderMate.LOG.info(PIGGY_SERVICE_CALLING_SENDING_REQUEST_TO + destination);
        if (destination.startsWith(HTTPS)) {
            this.ignoreAllSSLErrors();
            resource = rest.getSSLWebResource(destination, new PassthroughX509TrustManager(){

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            }, 30000, 30000, "TLSv1.2");
        } else {
            resource = rest.getResource(destination, 30000, 30000);
        }
        resource = rest.addBasicAuth(resource, piggyConfig.getWebConfig().getUsername(), piggyConfig.getWebConfig().getPassword());
        for (Pair pair : queryParams) {
            resource = rest.addParameter(resource, String.valueOf(pair.key), String.valueOf(pair.value));
        }
        return resource.getRequestBuilder();
    }
}

