/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.property;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.sales.Account;
import ordermate.integration.PropertyIntegrator;

abstract class AbstractPropertyCsvIntegrator
extends UnicastRemoteObject
implements PropertyIntegrator {
    protected abstract CSVWriter getCSVWriter(FileWriter var1);

    @Override
    public synchronized void synchronize() throws RemoteException {
        this.startSync();
        Date today = new Date();
        Date yesterday = new Date(today.getTime() - 86400000L);
        this.doSynchronize(yesterday);
        this.doSynchronize(today);
        this.stopSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSynchronize(Date date) {
        File inputFile = this.getInputFile(date);
        OrderMate.LOG.info("Synchronizing property data from file \"" + inputFile.getAbsolutePath() + "\"");
        CSVReader reader = null;
        try {
            FileReader fr = new FileReader(inputFile);
            reader = new CSVReader((Reader)fr);
            String[] line = reader.readNext();
            while (line != null) {
                this.syncRoomAccount(line);
                line = reader.readNext();
            }
            reader.close();
        }
        catch (IOException e) {
            String s = "Unable to read from " + inputFile;
            OrderMate.LOG.error(s, (Throwable)e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                OrderMate.LOG.warn("Error closing CSVReader", (Throwable)ex);
            }
        }
    }

    protected void startSync() {
    }

    protected void stopSync() {
    }

    @Override
    public synchronized void transactionsCreated(DebtorSale sale) throws RemoteException {
        File outputFile = this.getOutputFile();
        OrderMate.LOG.info("Writing property transaction data to \"" + outputFile.getAbsolutePath() + "\"");
        try {
            FileWriter fw = new FileWriter(outputFile, this.appendOutputFile());
            CSVWriter writer = this.getCSVWriter(fw);
            List lines = this.getDataStrings(sale);
            writer.writeAll(lines);
            writer.close();
            fw.close();
        }
        catch (IOException e) {
            String s = "Error writing to " + outputFile;
            throw new RemoteException(s, e);
        }
    }

    @Override
    public void writeZReads() throws RemoteException {
    }

    public abstract File getOutputFile();

    protected abstract boolean appendOutputFile();

    public abstract File getInputFile(Date var1);

    protected abstract void syncRoomAccount(String[] var1);

    protected abstract List getDataStrings(DebtorSale var1);

    protected final boolean ensureFileExists(File file) {
        if (!file.exists()) {
            try {
                File parent = file.getParentFile();
                if (!parent.exists()) {
                    parent.mkdir();
                }
                file.createNewFile();
                return true;
            }
            catch (IOException e) {
                String s = "Error creating file " + file + " for read/write: " + e.getMessage();
                throw new IllegalStateException(s);
            }
        }
        return false;
    }

    @Override
    public void accountCreated(Account account) throws RemoteException {
    }

    @Override
    public void itemsMoved(Account sourceAccount, Account targetAccount, Collection items) throws RemoteException {
    }

    @Override
    public void receiptPrinted(Account printed) throws RemoteException {
    }

    @Override
    public void accountClosed(Account closed) throws RemoteException {
    }
}

