/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.property;

import au.com.ordermate.xmlintegration.piggy.GuestSuggestion;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.finance.debtors.implementation.RoomAccount;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.enums.PropertyIntegrationType;
import ordermate.database.queries.finance.debtors.DebtorQueries;
import ordermate.database.sales.Account;
import ordermate.database.tables.LogicalTableState;
import ordermate.integration.PropertyIntegrator;
import ordermate.integration.piggy.PiggyResult;
import ordermate.integration.piggy.PiggyService;
import ordermate.integration.piggy.PiggyServiceBuilder;
import ordermate.integration.piggy.PiggyServiceProvider;

public class PiggyIntegrator
extends UnicastRemoteObject
implements PropertyIntegrator {
    private PiggyService piggyService;
    private static final List<String> activeStatus = new ArrayList<String>(Arrays.asList("arrived"));
    public static final PropertyIntegrationType TYPE = PropertyIntegrationType.PIGGY;

    private void initPiggyService() {
        PiggyServiceBuilder piggyServiceBuilder = new PiggyServiceBuilder().setStoreId(SystemCurrentInfo.getInstance().getRedbackId());
        PiggyServiceProvider.setPiggyServiceBuilder(piggyServiceBuilder);
        this.piggyService = PiggyServiceProvider.getPiggyService();
    }

    public PiggyIntegrator() throws RemoteException {
        this.initPiggyService();
    }

    @Override
    public void synchronize() throws RemoteException {
    }

    @Override
    public void writeZReads() throws RemoteException {
        List<RoomAccount> roomAccountList = DebtorQueries.getAllRoomAccounts();
        this.closeAccountByStatusOfReservation(roomAccountList);
    }

    @Override
    public void accountCreated(Account account) throws RemoteException {
    }

    @Override
    public void itemsMoved(Account sourceAccount, Account targetAccount, Collection items) throws RemoteException {
    }

    @Override
    public void receiptPrinted(Account printed) throws RemoteException {
    }

    @Override
    public void transactionsCreated(DebtorSale sale) throws RemoteException {
    }

    @Override
    public void accountClosed(Account closed) throws RemoteException {
    }

    @Override
    public void tableStateUpdated(Account updated, LogicalTableState state) throws RemoteException {
    }

    @Override
    public boolean isOffThread() throws RemoteException {
        return false;
    }

    public void closeAccountByStatusOfReservation(List<RoomAccount> roomAccountList) {
        for (RoomAccount roomAccount : roomAccountList) {
            if (roomAccount.getExtID() == null || roomAccount.getExtID().equals("")) continue;
            String status = null;
            try {
                PiggyResult piggyResult = this.piggyService.retrieveReservationDetail(roomAccount.getExtID());
                List guestSuggestionList = piggyResult.getPiggyResponse().getGuestSuggestions();
                if (guestSuggestionList != null && guestSuggestionList.size() > 0) {
                    GuestSuggestion guestSuggestion = (GuestSuggestion)guestSuggestionList.get(0);
                    status = guestSuggestion.getReservationStatus().toLowerCase();
                }
            }
            catch (Exception e) {
                String error = "Fetch reservation status failed duo to" + e;
                OrderMate.LOG.info(error);
            }
            if (status == null || status.equals("") || activeStatus.contains(status)) continue;
            OrderMate.LOG.info("Deactivated room account had data: \nRoom = " + roomAccount.getRoomNumber() + "\nFolio = " + roomAccount.getFolio() + "\nName = " + roomAccount.getLabel());
            roomAccount.delete();
        }
    }
}

