/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.property;

import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.integration.property.RMSReportObject;

class RMSAggregator {
    private List<SalesItem> items;
    private List<RMSReportObject> aggregatedList;
    private String aggregationMethod;

    public RMSAggregator(List<SalesItem> salesItems) {
        this.setSalesItems(salesItems);
    }

    public RMSAggregator() {
        this(null);
    }

    public void setSalesItems(List<SalesItem> newItems) {
        this.items = newItems != null ? newItems : new ArrayList<SalesItem>();
    }

    public void aggregateBy(String value) {
        this.aggregationMethod = value;
        if (!(value.equals("CATEGORY") || value.equals("GROUP") || value.equals("ITEM"))) {
            throw new IllegalArgumentException("Cannot aggregate by value:" + this.aggregationMethod);
        }
        this.aggregatedList = new ArrayList<RMSReportObject>();
        HashMap<Object, Price> map = new HashMap<Object, Price>();
        if (this.items == null) {
            throw new NullPointerException("Cannot perform aggregation on a null list");
        }
        for (TaxCode nextTaxCode : TaxCode.getInventoryTaxCodes()) {
            map.clear();
            for (SalesLineItem salesLineItem : this.items) {
                for (SalesItem nextSaleItem : salesLineItem.getSalesItems()) {
                    SalesComponent firstComp = nextSaleItem.getComponentList().get(0);
                    if (!nextTaxCode.equals(firstComp.getTaxes().get(0).getTaxCode())) continue;
                    Object key = this.getGroupingKey(nextSaleItem, firstComp);
                    if (map.containsKey(key)) {
                        map.put(key, nextSaleItem.getPrice().add((Price)map.get(key)));
                        continue;
                    }
                    map.put(key, nextSaleItem.getPrice());
                }
            }
            for (Displayable displayable : map.keySet()) {
                this.aggregatedList.add(new RMSReportObject(displayable.getLabel(), nextTaxCode.getLabel(), (Price)map.get(displayable), this.getExternalID(displayable), false));
            }
        }
        Collections.sort(this.aggregatedList);
    }

    private Object getGroupingKey(SalesItem item, SalesComponent firstComp) {
        PersistentObject toReturn = this.aggregationMethod.equals("CATEGORY") ? firstComp.getInventoryItem().getCategory() : (this.aggregationMethod.equals("GROUP") ? firstComp.getInventoryItem().getMenuGroup() : firstComp.getUnit());
        return toReturn;
    }

    private String getExternalID(Displayable key) {
        String toReturn = this.aggregationMethod.equals("CATEGORY") ? ((InventoryCategory)key).getExternalID() : (this.aggregationMethod.equals("GROUP") ? ((InventoryGroup)key).getExternalID() : String.valueOf(((InventoryItemUnit)key).getExternalID()));
        return toReturn;
    }

    public List<String[]> toCollectionOfStringArrays() {
        ArrayList<String[]> toReturn = new ArrayList<String[]>();
        for (RMSReportObject nextReport : this.aggregatedList) {
            toReturn.add(nextReport.toStringArray());
        }
        return toReturn;
    }
}

