/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.property;

import au.com.bytecode.opencsv.CSVWriter;
import au.com.ordermate.util.Price;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import ordermate.OrderMate;
import ordermate.database.finance.debtors.implementation.RoomAccount;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.integration.RMSConfiguration;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.PropertyIntegrationType;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.tables.LogicalTableState;
import ordermate.integration.property.AbstractPropertyCsvIntegrator;
import ordermate.integration.property.RMSAggregator;
import org.apache.commons.lang.ArrayUtils;

public class RMSIntegrator
extends AbstractPropertyCsvIntegrator
implements Remote {
    static final int OUTPUT_NUM_COLUMNS = 8;
    static final int OUTPUT_TAX_COL = 7;
    static final int OUTPUT_TIME_COL = 6;
    static final int OUTPUT_DATE_COL = 5;
    static final int OUTPUT_ITEM_PRICE_COL = 4;
    static final int OUTPUT_ITEM_COL = 3;
    static final int OUTPUT_EXT_ID_COL = 2;
    static final int OUTPUT_FOLIO_COL = 1;
    static final int OUTPUT_ROOM_COL = 0;
    private static final int INPUT_NUM_COLUMNS = 5;
    private static final int INPUT_STATUS_COL = 4;
    private static final int INPUT_GIVEN_NAME_COL = 3;
    private static final int INPUT_SURNAME_COL = 2;
    private static final int INPUT_FOLIO_COL = 1;
    private static final int INPUT_ROOM_COL = 0;
    private File defaultOutput;
    private final transient SimpleDateFormat RMS_DATE_FILENAME_FORMAT = new SimpleDateFormat("ddMMyy");
    public static final PropertyIntegrationType TYPE = PropertyIntegrationType.RMS;
    private static final String ACTIVATE = "0";
    private static final String DEACTIVATE = "1";
    private static final String TAX = "0";
    private static final String NO_TAX = "1";

    @Override
    protected CSVWriter getCSVWriter(FileWriter fileWriter) {
        return new CSVWriter((Writer)fileWriter, ',', '\u0000', "\r\n");
    }

    @Override
    public File getOutputFile() {
        if (this.defaultOutput == null) {
            String path = RMSConfiguration.getInstance().getFilePath() + "SYSNET" + this.getFileDate(new Date()) + ".csv";
            File outputFile = new File(path);
            this.ensureFileExists(outputFile);
            return outputFile;
        }
        return this.defaultOutput;
    }

    public void setOutputFile(File newFile) {
        this.defaultOutput = newFile;
        if (this.defaultOutput != null) {
            this.ensureFileExists(this.defaultOutput);
        }
    }

    @Override
    protected boolean appendOutputFile() {
        return true;
    }

    @Override
    public File getInputFile(Date date) {
        String path = RMSConfiguration.getInstance().getFilePath() + "RMS" + this.getFileDate(date) + ".csv";
        File inputFile = new File(path);
        if (this.ensureFileExists(inputFile)) {
            OrderMate.LOG.warn("RMS Input file did not exist, Ordermate created RMS input file.");
        }
        return inputFile;
    }

    private String getFileDate(Date theDate) {
        String date = this.RMS_DATE_FILENAME_FORMAT.format(theDate);
        return date;
    }

    @Override
    protected void syncRoomAccount(String[] data) {
        if (data.length != 5) {
            String s = "Expected 5, however found " + data.length + " in \"" + ArrayUtils.toString((Object)data) + "\"";
            throw new IllegalArgumentException(s);
        }
        String room = data[0];
        String rmsAccountNum = data[1];
        int folio = Integer.parseInt(rmsAccountNum);
        String surname = data[2];
        String givenName = data[3];
        String status = data[4];
        if (status.equalsIgnoreCase("0")) {
            if (RoomAccount.getAccountByFolio(folio) == null) {
                OrderMate.LOG.info("Checking RMS room account by room number:\"" + room + "\"");
                this.deactiveRoomAccountByRoomNumber(room);
                OrderMate.LOG.info("Creating RMS room account from data \"" + ArrayUtils.toString((Object)data) + "\"");
                RoomAccount.createRoomAccount(rmsAccountNum, givenName + " " + surname, room, folio, SystemProperty.getInstance().getRoomCreditLimit(), new Price(0.0));
            }
        } else if (status.equalsIgnoreCase("1")) {
            OrderMate.LOG.info("Deactivating RMS room account from data \"" + ArrayUtils.toString((Object)data) + "\"");
            this.deactiveRoomAccountByRoomNumber(room);
        } else {
            String s = "Invalid status given " + status + ", expected " + "0" + " or " + "1";
            throw new IllegalArgumentException(s);
        }
    }

    private void deactiveRoomAccountByRoomNumber(String roomNumber) {
        List accounts = RoomAccount.getAccountsByRoom(roomNumber);
        if (accounts.isEmpty()) {
            OrderMate.LOG.info("Couldn't find RMS room accounts to deactivate for room : " + roomNumber);
        }
        for (RoomAccount account : accounts) {
            OrderMate.LOG.info("Deactivated room account had data: \nRoom = " + account.getRoomNumber() + "\nFolio = " + account.getFolio() + "\nName = " + account.getLabel());
            account.delete();
        }
    }

    @Override
    protected List getDataStrings(DebtorSale sale) {
        RoomAccount roomAccount = (RoomAccount)sale.getDebtor();
        if (roomAccount == null) {
            String s = "transaction must payoff to a RoomAccount!";
            throw new IllegalArgumentException(s);
        }
        List<? extends SalesLineItem> items = sale.getSaleAccount().getItemHelper().getUnpaidItems();
        RMSAggregator aggy = new RMSAggregator(items);
        aggy.aggregateBy(RMSConfiguration.getInstance().getOutputType());
        List<String[]> strings = aggy.toCollectionOfStringArrays();
        Iterator<String[]> stringIt = strings.iterator();
        String roomNum = roomAccount.getRoomNumber();
        String roomFolio = Integer.toString(roomAccount.getFolio());
        String saleDate = this.getDate(sale.getSaleDate());
        String saleTime = this.getTime(sale.getSaleDate());
        while (stringIt.hasNext()) {
            String[] nextLine = stringIt.next();
            nextLine[0] = roomNum;
            nextLine[1] = roomFolio;
            nextLine[5] = saleDate;
            nextLine[6] = saleTime;
            if (nextLine[7].equals(TaxCode.getFreeCode().getLabel())) {
                nextLine[7] = "1";
                continue;
            }
            nextLine[7] = "0";
        }
        return strings;
    }

    private String getDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy");
        sdf.setTimeZone(TimeZone.getDefault());
        return sdf.format(date);
    }

    private String getTime(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        sdf.setTimeZone(TimeZone.getDefault());
        return sdf.format(date);
    }

    @Override
    public void tableStateUpdated(Account updated, LogicalTableState state) throws RemoteException {
    }

    @Override
    public boolean isOffThread() throws RemoteException {
        return false;
    }
}

