/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.property;

import au.com.bytecode.opencsv.CSVWriter;
import au.com.ordermate.util.Price;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.RoundingMode;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import ordermate.database.finance.debtors.implementation.RoomAccount;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.reports.CashDrawerTakingsSummary;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.integration.StarfleetConfiguration;
import ordermate.database.misc.enums.PropertyIntegrationType;
import ordermate.database.queries.finance.debtors.DebtorQueries;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.tables.LogicalTableState;
import ordermate.integration.property.AbstractPropertyCsvIntegrator;
import org.apache.commons.lang.ArrayUtils;

public class StarfleetIntegrator
extends AbstractPropertyCsvIntegrator
implements Remote {
    private static final int ZREADS_NUM_COLUMNS = 5;
    private static final int ZREADS_MARKER_COL = 4;
    private static final int ZREADS_TIMESTAMP_COL = 3;
    private static final int ZREADS_TERMINAL_COL = 2;
    private static final int ZREADS_TOTAL_COL = 1;
    private static final int ZREADS_LABEL_COL = 0;
    private static final int OUPUT_NUM_COLUMNS = 7;
    private static final int OUTPUT_MENU_GROUP_COL = 6;
    private static final int OUTPUT_TIME_COL = 5;
    private static final int OUTPUT_TERMINAL_COL = 4;
    private static final int OUTPUT_ITEM_PRICE_COL = 3;
    private static final int OUTPUT_ITEM_QUANTITY = 2;
    private static final int OUTPUT_ITEM_COL = 1;
    private static final int OUTPUT_ROOM_COL = 0;
    private static final int INPUT_NUM_COLUMNS = 4;
    private static final int INPUT_BALANCE_COL = 3;
    private static final int INPUT_PRICE_LIMIT_COL = 2;
    private static final int INPUT_CUSTOMER_COL = 1;
    private static final int INPUT_EXT_ID_COL = 0;
    public static final PropertyIntegrationType TYPE = PropertyIntegrationType.STARFLEET;
    private File outputFile;
    private File inputFile;
    private List accounts;

    public StarfleetIntegrator() throws RemoteException {
        StarfleetConfiguration sc = StarfleetConfiguration.getInstance();
        String outputPath = sc.getFilePath() + sc.getOutputFileName();
        String inputPath = sc.getFilePath() + sc.getInputFileName();
        this.outputFile = new File(outputPath);
        this.inputFile = new File(inputPath);
    }

    @Override
    protected CSVWriter getCSVWriter(FileWriter fileWriter) {
        return new CSVWriter((Writer)fileWriter, ',', '\"', "\n");
    }

    @Override
    public File getOutputFile() {
        this.ensureFileExists(this.outputFile);
        return this.outputFile;
    }

    @Override
    protected boolean appendOutputFile() {
        return true;
    }

    @Override
    public File getInputFile(Date date) {
        this.ensureFileExists(this.inputFile);
        return this.inputFile;
    }

    @Override
    protected void syncRoomAccount(String[] data) {
        if (data.length != 4) {
            String s = "Expected 4, however found " + data.length + " in \"" + ArrayUtils.toString((Object)data) + "\"";
            throw new IllegalArgumentException(s);
        }
        String extID = data[0];
        String customer = data[1];
        String folioAndRoom = extID;
        int folio = Integer.parseInt(folioAndRoom.substring(0, 1));
        String room = folioAndRoom.substring(1, folioAndRoom.length());
        String limitStr = data[2];
        Price limit = new Price(Double.parseDouble(limitStr));
        String balanceStr = data[3];
        Price balance = balanceStr.length() > 0 ? new Price(Double.parseDouble(balanceStr)) : new Price(0.0);
        RoomAccount roomAccount = null;
        Iterator<RoomAccount> iterator = DebtorQueries.getAllRoomAccounts().iterator();
        while (iterator.hasNext() && roomAccount == null) {
            RoomAccount account = iterator.next();
            if (!account.getRoomNumber().trim().equalsIgnoreCase(room) || account.getFolio() != folio) continue;
            roomAccount = account;
        }
        if (roomAccount == null) {
            RoomAccount.createRoomAccount(extID, customer, room, folio, limit, balance);
        } else if (roomAccount.getExtID().equalsIgnoreCase(extID)) {
            this.accounts.remove(roomAccount);
            Price currentLimit = roomAccount.getCreditLimit();
            Price newLimit = new Price(limit.doubleValue() - balance.doubleValue());
            if (currentLimit.doubleValue() != newLimit.doubleValue()) {
                roomAccount.setCreditLimit(newLimit);
            }
        }
    }

    @Override
    protected void startSync() {
        this.accounts = DebtorQueries.getAllRoomAccounts();
    }

    @Override
    protected void stopSync() {
        for (RoomAccount account : this.accounts) {
            account.delete();
        }
    }

    @Override
    protected List getDataStrings(DebtorSale sale) {
        ArrayList<String[]> strings = new ArrayList<String[]>();
        RoomAccount roomAccount = (RoomAccount)sale.getDebtor();
        if (roomAccount == null) {
            String s = "transaction must payoff to a RoomAccount!";
            throw new IllegalArgumentException(s);
        }
        String terminalName = this.getTerminalName(sale.getTerminal());
        List<? extends SalesLineItem> items = sale.getSaleAccount().getItemHelper().getUnpaidItems();
        for (SalesLineItem salesLineItem : items) {
            for (SalesItem item : salesLineItem.getSalesItems()) {
                String[] data = new String[]{roomAccount.getFolio() + roomAccount.getRoomNumber(), item.getLabel(), "" + item.getQuantity().getValue().setScale(0, RoundingMode.HALF_EVEN).toBigIntegerExact().intValue(), item.getPrice().toString(false), terminalName, this.getTimestamp(sale.getSaleDate()), this.getMenuGroup(item)};
                strings.add(data);
            }
        }
        return strings;
    }

    @Override
    public void writeZReads() throws RemoteException {
        for (Terminal terminal : Terminal.getAllWaiterMateTerminals()) {
            LinkedHashMap totals = new LinkedHashMap();
            for (CashDrawer cashdrawer : terminal.getConnectedCashDrawers()) {
                StarfleetIntegrator.putMappedTotals(totals, CashDrawerTakingsSummary.getSummary(cashdrawer, Terminal.getLocalHost().getShift()));
            }
            try {
                this.writeReads(totals, terminal);
            }
            catch (IOException e) {
                String s = "Error writing Z Reads to file";
                throw new RemoteException(s, e);
            }
        }
    }

    private String getTimestamp(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        sdf.setTimeZone(TimeZone.getDefault());
        return sdf.format(date);
    }

    private String getMenuGroup(SalesItem item) {
        List<SalesComponent> components = item.getComponentList();
        if (components.isEmpty()) {
            return "";
        }
        SalesComponent comp = components.get(0);
        return comp.getInventoryItem().getMenuGroup().getLabel();
    }

    private String getTerminalName(Terminal terminal) {
        String name = terminal.getName();
        if (name.length() > 4) {
            name = name.substring(0, 4);
        }
        return name;
    }

    private static void putMappedTotals(Map totals, CashDrawerTakingsSummary summary) {
        for (FinanceUnit currentSubtype : FinanceUnit.getAllUnits()) {
            Price total = summary.getUnitTakings(currentSubtype, false);
            if (totals.containsKey(currentSubtype)) {
                Price current = (Price)totals.get(currentSubtype);
                Price updated = new Price(current.doubleValue() + total.doubleValue());
                totals.put(currentSubtype, updated);
                continue;
            }
            totals.put(currentSubtype, total);
        }
    }

    private void writeReads(Map subtypeTotals, Terminal terminal) throws IOException {
        Date now = new Date();
        String terminalName = this.getTerminalName(terminal);
        FileWriter fw = new FileWriter(this.getOutputFile(), this.appendOutputFile());
        CSVWriter writer = this.getCSVWriter(fw);
        for (FinanceUnit subtype : subtypeTotals.keySet()) {
            Price total = (Price)subtypeTotals.get(subtype);
            if (!(total.doubleValue() > 0.0)) continue;
            String[] line = new String[]{subtype.getLabel(), total.toString(false), terminalName, this.getTimestamp(now), "Z-READ"};
            writer.writeNext(line);
        }
        writer.close();
    }

    @Override
    public void tableStateUpdated(Account updated, LogicalTableState state) throws RemoteException {
    }

    @Override
    public boolean isOffThread() throws RemoteException {
        return true;
    }
}

