/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.reservations;

import au.com.ordermate.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.PhysicalTable;
import ordermate.database.tables.TableGroupHelper;

public class ArrangeTables {
    private LogicalTable mainTable;
    private final List<PhysicalTable> toJoin;
    private final List<PhysicalTable> splitTables;
    private TableGroupHelper helper;
    private boolean arrangeOnChange;

    public ArrangeTables(LogicalTable table, List<PhysicalTable> tables, boolean arrangeOnChange) {
        this.mainTable = table;
        this.toJoin = new ArrayList<PhysicalTable>(tables);
        this.toJoin.remove(table.getPrimaryPhysicalTable());
        this.splitTables = new ArrayList<PhysicalTable>();
        this.arrangeOnChange = arrangeOnChange;
    }

    public void arrangeTables() {
        if (this.toJoin.size() == 0 && this.mainTable.getPhysicalTables().size() == 1) {
            return;
        }
        this.helper = this.mainTable.getTableGroup().getHelper();
        this.splitTables();
        this.joinTables();
        this.adjustTables();
    }

    private void splitTables() {
        ArrayList<PhysicalTable> tables = new ArrayList<PhysicalTable>(this.mainTable.getPhysicalTables());
        PhysicalTable primaryTable = this.mainTable.getPrimaryPhysicalTable();
        tables.remove(primaryTable);
        this.splitTables.addAll(tables);
        for (PhysicalTable nextTable : tables) {
            if (!this.mainTable.getPhysicalTables().contains(nextTable)) continue;
            this.helper.splitTable(this.mainTable, nextTable, this.arrangeOnChange);
        }
        for (PhysicalTable nextJoin : this.toJoin) {
            LogicalTable nextLogTable = nextJoin.getLogicalTable();
            ArrayList<PhysicalTable> attachedTables = new ArrayList<PhysicalTable>(nextLogTable.getPhysicalTables());
            for (PhysicalTable nextTable : attachedTables) {
                if (this.toJoin.contains(nextTable)) continue;
                if (!nextLogTable.getPrimaryPhysicalTable().equals(nextTable)) {
                    this.helper.splitTable(nextLogTable, nextTable, this.arrangeOnChange);
                    continue;
                }
                for (PhysicalTable nextChildTable : attachedTables) {
                    if (!this.toJoin.contains(nextChildTable)) continue;
                    this.helper.splitTable(nextLogTable, nextChildTable, this.arrangeOnChange);
                    this.splitTables.add(nextLogTable.getPrimaryPhysicalTable());
                    this.toJoin.set(this.toJoin.indexOf(nextChildTable), (PhysicalTable)PersistenceManager.reacquire(nextChildTable));
                }
            }
        }
    }

    private void joinTables() {
        for (PhysicalTable table : this.toJoin) {
            if (this.mainTable.equals(table.getLogicalTable())) continue;
            this.mainTable = this.helper.joinTables(this.mainTable, table.getLogicalTable(), this.arrangeOnChange);
        }
        this.mainTable.saveChild();
        this.splitTables.removeAll(this.mainTable.getPhysicalTables());
    }

    private void adjustTables() {
        for (PhysicalTable table : this.splitTables) {
            this.helper.returnToPermanentPosition(table);
        }
        this.mainTable.getTableGroup().save();
    }
}

