/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.reservations;

import au.com.diamondback.xmlintegration.booking.DiamondBooking;
import au.com.diamondback.xmlintegration.booking.DiamondBookingState;
import au.com.diamondback.xmlintegration.booking.DiamondCustomer;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.StringUtils;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.math.BigInteger;
import java.util.Calendar;
import ordermate.OrderMate;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.integration.cloudback.CloudServerType;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.PhysicalTable;
import ordermate.integration.cloudback.CloudBackClient;
import ordermate.jaxb.exporter.XMLHelper;

public class DiamondBackBookingsClient
extends CloudBackClient {
    private static final String BOOKINGS = "bookings/v1/general/";
    private static final String UPDATE = "/update";

    public DiamondBackBookingsClient() {
        this(CloudBackConfig.getCloudBackConfig(CloudServerType.DiamondBack));
    }

    protected DiamondBackBookingsClient(CloudBackConfig config) {
        super(config);
    }

    @Override
    protected String getSSLProtocol() {
        return "TLSv1.2";
    }

    @Override
    protected String getBaseURL() {
        String url = super.getBaseURL();
        return url + BOOKINGS;
    }

    public boolean reservationUpdated(Reservation res) {
        if (res == null) {
            return true;
        }
        DiamondBooking dBooking = this.translateBooking(res);
        OrderMate.LOG.info("Updating DiamondBack booking: " + dBooking.getAccountId() + " as " + dBooking.getState());
        WebResource.Builder builder = super.setupResource(SystemCurrentInfo.getInstance().getRedbackId() + UPDATE, new Pair[0]);
        ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)builder.accept(new String[]{"application/xml"})).type("application/xml")).post(ClientResponse.class, (Object)dBooking);
        if (response.getStatus() / 100 == 2) {
            String entity = (String)response.getEntity(String.class);
            OrderMate.LOG.info("Upload Booking to Diamondback successful:" + entity);
            return true;
        }
        OrderMate.LOG.error("Cannot upload Booking information to Diamondback.");
        try {
            OrderMate.LOG.error("Response:" + (String)response.getEntity(String.class));
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Unable to parse the response.");
        }
        return false;
    }

    private DiamondBooking translateBooking(Reservation res) {
        DiamondBooking dBooking = new DiamondBooking();
        Calendar cal = Calendar.getInstance();
        Calendar time = Calendar.getInstance();
        time.setTime(res.getTime());
        cal.setTime(res.getDate());
        cal.set(11, time.get(11));
        cal.set(12, time.get(12));
        cal.set(13, time.get(13));
        dBooking.setPosId(String.valueOf(res.getID()));
        dBooking.setProvId(res.getExternalId() == null ? null : String.valueOf(res.getExternalId()));
        dBooking.setBookingDatetime(XMLHelper.getDateType(cal.getTime()));
        dBooking.setNotes(res.getComments());
        if ("DELETED".equals(res.getSystemState())) {
            dBooking.setState(DiamondBookingState.CANCELLED);
        } else {
            boolean open = true;
            boolean billPrinted = false;
            if (res.getTableAccount() != null) {
                open = res.getTableAccount().isOpen();
                billPrinted = Account.ReceiptPrintState.RECEIPT_PRINTED.equals(res.getTableAccount().getReceiptState());
                dBooking.setAccountId(String.valueOf(res.getTableAccount().getID()));
                if (((TableAccount)res.getTableAccount()).getTable() != null) {
                    LogicalTable theTable = ((TableAccount)res.getTableAccount()).getTable();
                    dBooking.setTableSection(theTable.getTableGroup().getName());
                    for (PhysicalTable nextPTable : theTable.getPhysicalTables()) {
                        dBooking.getTables().add(nextPTable.getName());
                    }
                }
            } else {
                for (String nextTable : StringUtils.splitToList(res.getTables(), ",")) {
                    dBooking.getTables().add(nextTable);
                }
            }
            if (!open) {
                dBooking.setState(DiamondBookingState.CLOSED);
            } else {
                String state = res.getReservationState();
                if (billPrinted) {
                    dBooking.setState(DiamondBookingState.CLOSING);
                } else if ("ARRIVED".equals(state)) {
                    dBooking.setState(DiamondBookingState.ARRIVED);
                } else if ("BOOKED".equals(state)) {
                    dBooking.setState(DiamondBookingState.BOOKED);
                } else if ("CONFIRMED".equals(state)) {
                    dBooking.setState(DiamondBookingState.CONFIRMED);
                }
            }
        }
        if (res.getNumPatrons() != null) {
            dBooking.setNumPatrons(BigInteger.valueOf(res.getNumPatrons().intValue()));
        } else {
            dBooking.setNumPatrons(null);
        }
        dBooking.setLeaveDatetime(res.getLeaveTime() != null ? XMLHelper.getDateType(res.getLeaveTime()) : null);
        if (res.getCustomer() != null) {
            Customer cust = res.getCustomer();
            DiamondCustomer dCust = new DiamondCustomer();
            dCust.setEmail(cust.getEmail());
            dCust.setFirstName(cust.getFirstName());
            dCust.setLastName(cust.getLastName());
            dCust.setPhone(cust.getPrimaryPhoneNumber());
            dBooking.setCustomer(dCust);
        }
        return dBooking;
    }
}

