/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.reservations;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.ToStringifier;
import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.finance.transactions.WebTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.queries.tables.PhysicalTableQueries;
import ordermate.database.sales.Account;
import ordermate.database.sales.CustomerUpdateManager;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.sales.reservation.ReservationDeposit;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.PhysicalTable;
import ordermate.database.tables.TableGroup;
import ordermate.database.users.User;
import ordermate.gui.reservation.ReservationUtils;
import ordermate.integration.reservations.ArrangeTables;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public abstract class ReservationArriver {
    public final Signal done = Signals.createSignal();
    protected final Reservation reservation;
    protected List<PhysicalTable> physicalTables;
    protected List<PhysicalTable> oldPhysicalTables;
    protected LogicalTable table;
    private final GuiHandler handler;
    protected final ReservationUtils utils;
    private boolean unallocatedAllowed = false;
    private final String SEVENROOMS = "SevenRooms";
    private final String NOWBOOKIT = "NowBookIt";

    protected ReservationArriver(GuiHandler handler, Reservation reservation) {
        this.handler = handler;
        this.reservation = reservation;
        this.utils = new ReservationUtils(handler);
    }

    public LogicalTable arriveParty() {
        this.getRequestedTable();
        if (this.table == null) {
            this.findTable();
            if (this.table == null && this.unallocatedAllowed) {
                this.doActualArrival();
            }
        } else {
            return this.gotTable(this.table);
        }
        return null;
    }

    protected abstract void findTable();

    protected abstract EventContext getEventContext();

    protected abstract void cleanup();

    protected void getRequestedTable() {
        String tables = this.reservation.getTables();
        TableGroup section = this.reservation.getSection();
        if (section == null || StringUtils.isEmpty(tables)) {
            return;
        }
        this.physicalTables = PhysicalTableQueries.getPhysicalTables(tables, this.reservation.getSection());
        if (!this.physicalTables.isEmpty()) {
            this.table = this.findFirstFreeTable(this.physicalTables);
        } else {
            this.logMessage("Reservations - Cannot find table! " + this.getReservationInfo());
            this.utils.displayTableDoesntExist(tables, section);
        }
    }

    protected LogicalTable findFirstFreeTable(List<PhysicalTable> phTables) {
        String reason = null;
        ArrayList<PhysicalTable> cannotUse = new ArrayList<PhysicalTable>();
        LogicalTable primary = null;
        for (PhysicalTable phTable : phTables) {
            LogicalTable logTable = phTable.getLogicalTable();
            if (logTable == null || logTable.hasAccount() || !logTable.canOrderTo() || logTable.getTableGroup().isOnline()) {
                cannotUse.add(phTable);
                continue;
            }
            if (primary == null) {
                if (logTable.getPrimaryPhysicalTable().equals(phTable)) {
                    if (logTable.hasAccount()) {
                        reason = "The table is already occupied";
                        cannotUse.add(phTable);
                        continue;
                    }
                    if (logTable.isLocked()) {
                        reason = "The table is locked";
                        cannotUse.add(phTable);
                        continue;
                    }
                    if (!logTable.canOrderTo()) {
                        reason = "The table cannot be ordered to";
                        cannotUse.add(phTable);
                        continue;
                    }
                    primary = logTable;
                    reason = null;
                    continue;
                }
                if (logTable.hasAccount() || logTable.isLocked()) continue;
                logTable = logTable.getTableGroup().getHelper().splitTable(logTable, phTable, Terminal.getLocalHost().getGtl().isArrangeOnJoin());
                if (primary != null) continue;
                primary = logTable;
                continue;
            }
            if (primary == null || primary.getTableGroup().equals(phTable.getLogicalTable().getTableGroup())) continue;
            cannotUse.add(phTable);
        }
        phTables.removeAll(cannotUse);
        if (reason != null) {
            this.logMessage("Arriver - Cannot select table! The reason:" + reason + ", " + this.getReservationInfo());
            OrderMate.LOG.warn("Arriver - Cannot select table! The reason:" + reason + ", " + this.getReservationInfo());
            this.handler.displayOkDialog(reason, "Cannot select table");
        }
        return primary;
    }

    protected String getReservationInfo() {
        return "Booking ID: " + this.reservation.getExternalId() + ", Customer: " + this.reservation.getCustomerName() + ", Tables: " + this.reservation.getTables() + ", Section: " + this.reservation.getSectionLabel();
    }

    public void gotCancel() {
        this.done.emit();
    }

    public LogicalTable gotTable(LogicalTable yourTable) {
        this.table = yourTable;
        if (this.table != null) {
            if (!this.table.hasAccount() && !this.table.isLocked()) {
                this.arrangeTables();
                return yourTable;
            }
            if (this.table.hasAccount()) {
                this.utils.displayCurrentlyInUse(this.table);
            } else {
                this.utils.displayCurrentlyLocked(this.table);
            }
        }
        this.findTable();
        return this.table;
    }

    private void arrangeTables() {
        if (this.table == null) {
            return;
        }
        this.oldPhysicalTables = new ArrayList<PhysicalTable>(this.table.getPhysicalTables());
        if (this.physicalTables != null) {
            this.physicalTables.remove(this.table.getPrimaryPhysicalTable());
            for (PhysicalTable nextTable : new ArrayList<PhysicalTable>(this.physicalTables)) {
                if ("ACTIVE".equals(nextTable.getSystemState()) && "ACTIVE".equals(nextTable.getLogicalTable().getSystemState()) && nextTable.isCanOrderTo() && nextTable.getLogicalTable().getAccount() == null) continue;
                this.physicalTables.remove(nextTable);
            }
            if (!this.physicalTables.isEmpty() || this.table.getPhysicalTables().size() > 1) {
                ArrangeTables arranger = new ArrangeTables(this.table, this.physicalTables, Terminal.getLocalHost().getGtl().isArrangeOnJoin());
                arranger.arrangeTables();
            }
        }
        this.doActualArrival();
    }

    protected void doActualArrival() {
        User user;
        EventContext context = this.getEventContext();
        User user2 = user = context.getUser() == null ? User.getSystemUser() : context.getUser();
        if (this.table != null) {
            this.table.relock(user);
        }
        TableAccount account = new TableAccount(user, this.table, this.reservation.getNumPatrons(), context.getTerminal());
        account.setSeats(this.reservation.getNumPatrons());
        account.lock(user);
        account.setCustomer(this.reservation.getCustomer(), context);
        this.modifyArrivedAccount(account);
        account.save();
        account.unlock();
        CustomerUpdateManager.getInstance().addCustomerToUpdate(account.getCustomer());
        this.cleanup();
        this.reservation.setTableAccount(account);
        this.reservation.setReservationState("ARRIVED");
        if (this.table != null && StringUtils.isEmpty(this.reservation.getTables())) {
            this.reservation.setTables(this.table.getLabel());
        }
        this.reservation.save();
        TerminalEventLog.logReservationArrived(this.reservation, context);
        this.notifyForLinkedReservation(account);
        String summary = this.createSummaryString();
        this.handler.displayOkDialog("Reservation has auto-arrived", summary);
        this.done.emit();
    }

    protected void modifyArrivedAccount(TableAccount toModify) {
        Terminal servermate = Terminal.getServerMateTerminal();
        for (ReservationDeposit deposit : this.reservation.getDeposits()) {
            boolean found = false;
            for (FinanceTransaction txn : toModify.getFinanceTransactions()) {
                if (!(txn instanceof WebTransaction) || !deposit.getTxnRef().equals(((WebTransaction)txn).getTransactionReference())) continue;
                found = true;
                break;
            }
            if (!found) {
                FinanceUnit onlineUnit = FinanceUnit.getUnitForName(deposit.getIssuer());
                if (onlineUnit == null) {
                    onlineUnit = deposit.getIssuer().equals("SevenRooms") || deposit.getIssuer().equals("NowBookIt") ? FinanceUnit.createUnit(FinanceUnit.WEB_TYPE, deposit.getIssuer(), false, true) : FinanceUnit.createUnit(FinanceUnit.WEB_TYPE, deposit.getIssuer(), false, false);
                }
                WebTransaction newTxn = new WebTransaction(User.getSystemUser(), servermate, new Price(deposit.getAmountPaid(), 0.01), Price.ZERO_DOLLAR, CashDrawer.getOnlineCashDrawer(servermate, User.getSystemUser()), onlineUnit, servermate.getShift());
                newTxn.setTransactionReference(deposit.getTxnRef());
                toModify.addFinanceTransaction(newTxn);
                continue;
            }
            OrderMate.LOG.warn("Will not apply transaction, already exists " + deposit.getTxnRef() + " for " + toModify);
        }
    }

    private String createSummaryString() {
        StringBuilder SB = new StringBuilder("Reservation: ");
        SB.append(HtmlUtils.highlight(this.reservation.getCustomerName(), "green", true, false)).append(" has arrived to table ");
        if (this.table != null) {
            SB.append(HtmlUtils.highlight(this.table.getLabel(), "green", true, false)).append(HtmlUtils.newline(1));
        } else {
            SB.append("UNALLOCATED");
        }
        if (this.physicalTables != null && this.table != null) {
            this.physicalTables.add(0, this.table.getPrimaryPhysicalTable());
            this.oldPhysicalTables.removeAll(this.physicalTables);
        }
        boolean latch = false;
        if (this.oldPhysicalTables != null && !this.oldPhysicalTables.isEmpty()) {
            latch = true;
            SB.append(this.oldPhysicalTables.size() > 1 ? "Tables " : "Table ");
            SB.append(StringUtils.mergeToStringWithSeparator(this.oldPhysicalTables, ",", new ToStringifier()));
            SB.append(this.oldPhysicalTables.size() > 1 ? " have" : " has").append(" been split");
            SB.append(HtmlUtils.newline(1));
        }
        if (this.physicalTables != null && this.physicalTables.size() > 1) {
            latch = true;
            SB.append("Tables ").append(StringUtils.mergeToStringWithSeparator(this.physicalTables, ",", new ToStringifier()));
            SB.append(" have been automatically joined");
            SB.append(HtmlUtils.newline(1));
        }
        if (latch) {
            SB.append("You may need to rearrange tables for this section manually.");
        }
        if (this.physicalTables != null && !this.physicalTables.isEmpty()) {
            this.physicalTables.remove(0);
        }
        return HtmlUtils.html(SB.toString());
    }

    public void destroy() {
        this.physicalTables = null;
        this.table = null;
    }

    protected abstract void logMessage(String var1);

    public boolean unarriveParty() {
        Account account = this.reservation.getTableAccount();
        if (account != null && "ARRIVED".equals(this.reservation.getReservationState())) {
            if (account.hasItems()) {
                return false;
            }
            EventContext context = this.getEventContext();
            if (!account.lock(context.getUser())) {
                this.logMessage("Arriver - Cannot unseat table, reservation account is locked by " + account.getUser() + " " + this.getReservationInfo());
                return false;
            }
            account.close(context);
            account.disableNotifyClosed();
            account.save();
            account.unlock();
            TerminalEventLog.logReservationUnseated(this.reservation, context);
            this.reservation.setTableAccount(null);
            this.reservation.setReservationState("BOOKED");
            this.reservation.save();
            this.notifyForUnlinkedReservation();
            return true;
        }
        return false;
    }

    public void setArriveUnallocatedAllowed(boolean value) {
        this.unallocatedAllowed = value;
    }

    protected abstract void notifyForUnlinkedReservation();

    protected abstract void notifyForLinkedReservation(Account var1);
}

