/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.reservations;

import java.util.List;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.ReservationIntegrationType;
import ordermate.database.queries.sales.reservation.ReservationAccountQueries;
import ordermate.database.sales.Account;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.PhysicalTable;
import ordermate.database.tables.TableGroupHelper;
import ordermate.integration.ReservationIntegrationUtils;

public class ReservationNotifier {
    public static void notifyForLinkedAccount(LogicalTable table, Account account) {
        if (!ReservationNotifier.isNotifiable(table, account)) {
            return;
        }
        if (table.getBarTabs().size() == 1) {
            ReservationIntegrationUtils.reservationAccountCreated(account);
        } else if (table.getBarTabs().size() > 1) {
            Reservation reservation = ReservationAccountQueries.getReservation(table.getBarTabs().get(0));
            reservation.linkAccount(account);
            reservation.save();
        }
    }

    public static void notifyForDelinkedAccount(LogicalTable table, Account account, DelinkReason reason) {
        List<PhysicalTable> phTables;
        ExperimentalFeature revertTables;
        if (!ReservationNotifier.isNotifiable(table, account)) {
            return;
        }
        Reservation reservation = ReservationAccountQueries.getReservation(account);
        if (reservation != null) {
            switch (reason) {
                case CLOSE: {
                    reservation.delinkAccountByClosing(account);
                    break;
                }
                case TRANSFER: {
                    reservation.delinkAccountByMoving(account);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The reason of delinking account from reservation should be valid!");
                }
            }
        }
        if (table.getBarTabs().size() == 0 && (ReservationIntegrationType.RESTAURANTDIARY.equals((Object)SystemProperty.getInstance().getReservationIntegration()) || DelinkReason.CLOSE.equals((Object)reason))) {
            ReservationIntegrationUtils.reservationTableClosed(reservation);
        }
        if (ReservationIntegrationType.DIAMONDBACK.equals((Object)SystemProperty.getInstance().getReservationIntegration()) && (revertTables = ExperimentalFeature.find("DiamondBack Revert Tables")) != null && revertTables.getBooleanValue(Boolean.TRUE).booleanValue() && (phTables = table.getPhysicalTables()).size() > 1) {
            TableGroupHelper helper = table.getTableGroup().getHelper();
            for (PhysicalTable phTable : phTables) {
                helper.returnToPermanentPosition(phTable);
            }
            table.saveChild();
            for (PhysicalTable phTable : phTables) {
                helper.returnToPermanentPosition(phTable);
                phTable.saveChild();
            }
        }
    }

    private static boolean isNotifiable(LogicalTable table, Account account) {
        return ReservationIntegrationUtils.isCloudReservationsConfigured() && table != null && account != null;
    }

    public static enum DelinkReason {
        CLOSE,
        TRANSFER;

    }
}

