/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.respak;

import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import ordermate.OrderMate;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.integration.RespakConfiguration;
import ordermate.database.misc.enums.PropertyIntegrationType;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.TableAccount;
import ordermate.database.tables.LogicalTableState;
import ordermate.integration.PropertyIntegrator;
import ordermate.internationalization.Internationalization;

public class RespakIntegrator
extends UnicastRemoteObject
implements PropertyIntegrator {
    public static final String END_OF_TRANSMISSION = Character.toString('\u0004');
    public static final String END_OF_TEXT = Character.toString('\u0003');
    public static final String START_OF_TEXT = Character.toString('\u0002');
    public static final String START_OF_HEADER = Character.toString('\u0001');
    private static final int RESPONSE_WAIT_TIME = 250;
    public static final PropertyIntegrationType TYPE = PropertyIntegrationType.RESPAK;
    private int currentMessageID = 0;
    private String server;
    private int port;

    public RespakIntegrator() throws RemoteException {
        RespakConfiguration config = RespakConfiguration.getInstance();
        this.server = config.getServer();
        this.port = config.getPort();
    }

    public RespakIntegrator(String newServer, int newPort) throws RemoteException {
        this.server = newServer;
        this.port = newPort;
    }

    @Override
    public void accountCreated(Account account) throws RemoteException {
        if (account instanceof TableAccount) {
            TableAccount tableAccount = (TableAccount)account;
            int numGuests = MathsUtils.shortenID(tableAccount.getNumPatrons(), 3);
            String message = "C" + this.getAccountIdentifier(tableAccount) + "G=" + numGuests + ";";
            this.sendMessage(message);
        }
    }

    @Override
    public void receiptPrinted(Account printed) throws RemoteException {
        if (printed instanceof TableAccount) {
            TableAccount tableAccount = (TableAccount)printed;
            String message = "#" + this.getAccountIdentifier(tableAccount);
            this.sendMessage(message);
        }
    }

    @Override
    public void accountClosed(Account closed) throws RemoteException {
        if (closed instanceof TableAccount) {
            TableAccount tableAccount = (TableAccount)closed;
            double total = closed.getTotal().doubleValue();
            Price discountAmount = Price.ZERO_DOLLAR;
            if (closed.isDiscounted()) {
                for (SalesPriceAdjustment currentDiscount : closed.getPriceAdjHelper().getDiscounts()) {
                    discountAmount = discountAmount.add(currentDiscount.getValue());
                }
            }
            Price surchargeAmount = Price.ZERO_DOLLAR;
            if (closed.getPriceAdjHelper().isSurcharged()) {
                for (SalesPriceAdjustment currentSurcharge : closed.getPriceAdjHelper().getSurcharges()) {
                    surchargeAmount = surchargeAmount.add(currentSurcharge.getValue().multiply(-1));
                }
            }
            DecimalFormat format = new DecimalFormat("#0.0#");
            String checkTotalsMessage = Internationalization.getLiteralFor("DOLLAR_SIGN") + this.getAccountIdentifier(tableAccount) + "SC=" + format.format((Object)surchargeAmount.doubleValue()) + ";DSC=" + format.format((Object)discountAmount.doubleValue()) + ";D=" + total + ';';
            this.sendMessage(checkTotalsMessage);
            Iterator<SalesLineItem> lineItemIt = closed.getItems().iterator();
            int numInMessage = 0;
            String itemDetailsLines = "";
            while (lineItemIt.hasNext()) {
                SalesLineItem lineItem = lineItemIt.next();
                Iterator<SalesItem> itemIt = lineItem.getSalesItems().iterator();
                while (itemIt.hasNext()) {
                    ++numInMessage;
                    SalesItem item = itemIt.next();
                    SalesComponent firstComponent = item.getComponentList().get(0);
                    int itemNum = MathsUtils.shortenID(firstComponent.getInventoryItem().intID(), 6);
                    String name = StringUtils.shorten(item.getLabel(), 40);
                    SalesQuantity itemCount = item.getQuantity();
                    int groupID = MathsUtils.shortenID(firstComponent.getInventoryItem().getMenuGroup().intID(), 3);
                    double itemTotal = item.getPrice().doubleValue();
                    itemDetailsLines = itemDetailsLines + itemNum + ";" + name + ";" + itemCount + ";" + groupID + ";" + format.format((Object)itemTotal) + ";";
                    if (numInMessage != 10 && (itemIt.hasNext() || lineItemIt.hasNext())) continue;
                    String itemDetailsMessage = "D" + this.getAccountIdentifier(tableAccount) + "DTL=" + numInMessage + ';' + itemDetailsLines;
                    this.sendMessage(itemDetailsMessage);
                    numInMessage = 0;
                    itemDetailsLines = "";
                }
            }
        }
    }

    private synchronized void sendMessage(String message) {
        ++this.currentMessageID;
        String messageID = StringUtils.leftPad(Integer.toString(this.currentMessageID), 5, '0');
        String finalMessage = START_OF_HEADER + messageID + START_OF_TEXT + message + END_OF_TEXT + END_OF_TRANSMISSION;
        try {
            Socket connection = new Socket(this.server, this.port);
            BufferedOutputStream out = new BufferedOutputStream(connection.getOutputStream());
            out.write(finalMessage.getBytes());
            out.flush();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                OrderMate.LOG.info("Thread interupted while waiting", (Throwable)e);
            }
            BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
            String input = StringUtils.readFromStream(in, END_OF_TRANSMISSION.charAt(0));
            out.close();
            in.close();
            connection.close();
            StringTokenizer tokens = new StringTokenizer(input.toString(), START_OF_HEADER + START_OF_TEXT + END_OF_TEXT + END_OF_TRANSMISSION, false);
            String actualMessageID = tokens.nextToken().trim();
            if (actualMessageID.equals(messageID)) {
                String messageText = tokens.nextToken();
                char result = messageText.charAt(messageText.indexOf(59) - 1);
                if (result == '1') {
                    String errorMessage = messageText.substring(messageText.indexOf(59));
                    if (errorMessage.length() == 0) {
                        throw new IOException("ResPAK reported an error result, however no error message was received");
                    }
                    throw new IOException("Error in ResPAK: " + errorMessage);
                }
            } else {
                throw new IOException("Cannot parse ResPAK response.  Expected " + messageID + " but got " + actualMessageID);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            OrderMate.LOG.warn("Error occurred while communicating with ResPAK", (Throwable)e);
        }
    }

    private String getAccountIdentifier(TableAccount account) {
        String sectionID = account.getTable().getTableGroup().getExtId();
        if (StringUtils.isEmpty(sectionID)) {
            sectionID = account.getTable().getTableGroup().getLabel();
        }
        sectionID = StringUtils.shorten(sectionID, 5);
        int mealPeriod = 0;
        String tableID = StringUtils.shorten(account.getTable().getLabel(), 6);
        int accountID = MathsUtils.shortenID(account.intID(), 6);
        String message = "A=" + sectionID + ";M=" + mealPeriod + ";T=" + tableID + ";C=" + accountID + ";";
        return message;
    }

    @Override
    public void itemsMoved(Account sourceAccount, Account targetAccount, Collection items) throws RemoteException {
    }

    @Override
    public void synchronize() throws RemoteException {
    }

    @Override
    public void writeZReads() throws RemoteException {
    }

    @Override
    public void transactionsCreated(DebtorSale sale) throws RemoteException {
    }

    @Override
    public void tableStateUpdated(Account updated, LogicalTableState state) throws RemoteException {
    }

    @Override
    public boolean isOffThread() throws RemoteException {
        return true;
    }
}

