/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.restaurantdiary;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.StringUtils;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ordermate.OrderMate;
import ordermate.integration.jaxb.restaurantdiary.RDBooking;
import ordermate.integration.jaxb.restaurantdiary.RDBookingExtra;
import ordermate.integration.jaxb.restaurantdiary.RDCustomer;
import ordermate.integration.jaxb.restaurantdiary.RDPayment;
import ordermate.integration.jaxb.restaurantdiary.RDPromotion;
import ordermate.integration.restaurantdiary.RDContext;
import ordermate.integration.restaurantdiary.RDContextGrabber;

public class RDBookingSummary {
    private final RDBooking rdBooking;
    private final RDCustomer rdCustomer;
    private final RDContext context;
    private final NumberFormat amountFormatter = new DecimalFormat("#,###,##0.00");

    public RDBookingSummary(Long bookingId) {
        if (bookingId == null) {
            throw new IllegalArgumentException("ResDiary - RDBooking ID cannot be null");
        }
        this.context = PersistenceManager.getServerConnection().runSync(new RDContextGrabber());
        if (this.context == null) {
            OrderMate.LOG.error("ResDiary - There is no RestaurantDiaryContext in Servermate");
        }
        RDBooking rDBooking = this.rdBooking = this.context != null ? this.context.getBooking(bookingId) : null;
        if (this.rdBooking == null) {
            OrderMate.LOG.error("ResDiary - There is no booking data for the id: " + bookingId);
            this.rdCustomer = null;
        } else {
            this.rdCustomer = this.rdBooking.getCustomer();
        }
    }

    public boolean isValid() {
        return this.rdBooking != null;
    }

    public String getBookingRef() {
        return this.rdBooking.getBookingReference();
    }

    public String getEmail() {
        return this.rdCustomer != null ? this.rdCustomer.getEmail() : "";
    }

    public String getPhone() {
        StringBuilder sb = new StringBuilder();
        if (this.rdCustomer != null) {
            if (this.rdCustomer.getMobileNumber() != null && !this.rdCustomer.getMobileNumber().isEmpty()) {
                sb.append(this.rdCustomer.getMobileNumber()).append(" / ");
            }
            if (this.rdCustomer.getPhoneNumber() != null && !this.rdCustomer.getPhoneNumber().isEmpty()) {
                sb.append(this.rdCustomer.getPhoneNumber()).append(" / ");
            }
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 3, sb.length());
        }
        return sb.toString();
    }

    public String getArrivalTime() {
        Date visitDate = DateTimeUtils.parseDateStringIntoLocalDate(this.rdBooking.getVisitDateTime());
        return DateTimeUtils.convertToTwelveHourTime(visitDate);
    }

    public String getLeaveTime() {
        Date visitDate = DateTimeUtils.parseDateStringIntoLocalDate(this.rdBooking.getVisitDateTime());
        return DateTimeUtils.convertToTwelveHourTime(DateTimeUtils.addTime(visitDate, 12, this.rdBooking.getDuration()));
    }

    public String getChannel() {
        return this.rdBooking.getChannelName();
    }

    public String getPromotions() {
        StringBuilder promotions = new StringBuilder();
        for (RDPromotion promotion : this.rdBooking.getPromotions()) {
            if (promotion == null) continue;
            promotions.append(promotion.getName()).append(" x ").append(promotion.getQuantity()).append(", ");
        }
        if (promotions.length() > 0) {
            promotions.delete(promotions.length() - 2, promotions.length());
        }
        return promotions.toString().trim();
    }

    public String getBookingExtras() {
        StringBuilder extras = new StringBuilder();
        for (RDBookingExtra extra : this.rdBooking.getExtras()) {
            if (extra == null) continue;
            extras.append(extra.getName()).append(" x ").append(extra.getQuantity()).append(", ");
        }
        if (extras.length() > 0) {
            extras.delete(extras.length() - 2, extras.length());
        }
        return extras.toString().trim();
    }

    public String getMenu() {
        return StringUtils.nullToEmpty(this.rdBooking.getMenuName());
    }

    public String getSpecialRequests() {
        StringBuilder sb = new StringBuilder();
        for (Long specialRequestId : this.rdBooking.getSpecialRequests()) {
            sb.append(this.context.getSpecialRequestName(specialRequestId)).append(", ");
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString();
    }

    public String getPayments() {
        List<String> payments = this.getPaymentList();
        if (!payments.isEmpty()) {
            String displayablePayments = payments.toString();
            return displayablePayments.substring(1, displayablePayments.length() - 1);
        }
        return "";
    }

    public List<String> getPaymentList() {
        ArrayList<String> payments = new ArrayList<String>();
        for (RDPayment payment : this.rdBooking.getPayments()) {
            if (payment == null) continue;
            payments.add(this.getPaymentLine(payment));
        }
        return payments;
    }

    private String getPaymentLine(RDPayment payment) {
        String paymentProcess = payment.isIsProcessed() != false ? "processed" : "unprocessed";
        String paymentMethod = payment.isIsProcessed() != false ? " (" + payment.getPaymentMethod() + ")" : " (Outstanding)";
        return "$" + this.amountFormatter.format(payment.getAmount()) + " " + paymentProcess + paymentMethod;
    }

    public String getCustomerComments() {
        return this.rdCustomer != null ? this.rdCustomer.getComments() : "";
    }

    public String getBookingComments() {
        return this.rdBooking.getComments();
    }

    public String getTables() {
        return this.context != null ? this.context.getTableNames(this.rdBooking.getTables()) : "";
    }
}

