/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.restaurantdiary;

import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.comparator.NaturalOrderComparator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ordermate.OrderMate;
import ordermate.database.config.customer.CustomerInterest;
import ordermate.database.queries.config.customer.CustomerInterestQueries;
import ordermate.integration.jaxb.restaurantdiary.RDArea;
import ordermate.integration.jaxb.restaurantdiary.RDBooking;
import ordermate.integration.jaxb.restaurantdiary.RDInterest;
import ordermate.integration.jaxb.restaurantdiary.RDRestaurant;
import ordermate.integration.jaxb.restaurantdiary.RDSegment;
import ordermate.integration.jaxb.restaurantdiary.RDService;
import ordermate.integration.jaxb.restaurantdiary.RDSpecialRequest;
import ordermate.integration.jaxb.restaurantdiary.RDTable;
import ordermate.integration.jaxb.restaurantdiary.RDTimeScope;

public class RDContext
implements Serializable {
    private Map<Long, RDArea> areas = new ConcurrentHashMap<Long, RDArea>(8, 0.9f, 1);
    private Map<Long, RDTable> tables = new ConcurrentHashMap<Long, RDTable>(32, 0.9f, 1);
    private Map<Long, RDBooking> bookings = new ConcurrentHashMap<Long, RDBooking>(32, 0.9f, 4);
    private Map<Long, RDService> services = new ConcurrentHashMap<Long, RDService>(8, 0.9f, 1);
    private Map<Long, RDSpecialRequest> specialRequests = new ConcurrentHashMap<Long, RDSpecialRequest>(8, 0.9f, 1);
    private Date lastSync;
    private final int DEFAULT_TIMESLOT = 15;

    public void updateRestaurant(RDRestaurant restaurant) {
        ArrayList<RDArea> restAreas = new ArrayList<RDArea>();
        ArrayList<RDTable> restTables = new ArrayList<RDTable>();
        ArrayList<RDService> restServices = new ArrayList<RDService>();
        for (RDSegment segment : restaurant.getSegments()) {
            if (!this.shouldGetSegmentData(segment)) continue;
            restAreas.addAll(segment.getAreas());
            restTables.addAll(segment.getTables());
            restServices.addAll(segment.getServices());
        }
        this.updateAreas(restAreas);
        this.updateTables(restTables);
        this.updateServices(restServices);
        this.updateSpecialRequests(restaurant.getSpecialRequests());
        OrderMate.LOG.debug("RestaurantDiary Restaurant Data updated");
        this.addCustomerInterests(restaurant.getInterests());
        this.buildExcessiveLogs(restAreas, restTables);
    }

    private boolean shouldGetSegmentData(RDSegment segment) {
        if (segment == null) {
            return false;
        }
        Date today = new Date();
        List<RDTimeScope> timeScopes = segment.getTimeScopes();
        for (RDTimeScope timeScope : timeScopes) {
            Date fromDate = DateTimeUtils.parseDateStringIntoLocalDate(timeScope.getFromDate());
            Date toDate = DateTimeUtils.parseDateStringIntoLocalDate(timeScope.getToDate());
            if (fromDate == null || toDate == null || DateTimeUtils.compareDates(fromDate, today, false) > 0 || DateTimeUtils.compareDates(toDate, today, false) <= 0) continue;
            return true;
        }
        return false;
    }

    public Date getLastSyncDate() {
        return this.lastSync;
    }

    public void setLastSyncDate(Date date) {
        this.lastSync = date;
    }

    private void buildExcessiveLogs(List<RDArea> restAreas, List<RDTable> restTables) {
        OrderMate.LOG.debug("RDRestaurant RDAreas: " + this.getAreaLog(restAreas).toString());
        OrderMate.LOG.debug("RDRestaurant RDTables: " + this.getTableLog(restTables).toString());
    }

    private StringBuilder getTableLog(List<RDTable> tableList) {
        StringBuilder SB = new StringBuilder();
        SB.append("[");
        for (RDTable table : tableList) {
            SB.append(" id=").append(table.getAreaId()).append(" number=").append(table.getNumber()).append(",");
        }
        SB.deleteCharAt(SB.length() - 1);
        SB.append("]");
        return SB;
    }

    private StringBuilder getAreaLog(List<RDArea> areaList) {
        StringBuilder SB = new StringBuilder();
        SB.append("[");
        for (RDArea area : areaList) {
            SB.append(" id=").append(area.getAreaId()).append(" name=").append(area.getName()).append(",");
        }
        SB.deleteCharAt(SB.length() - 1);
        SB.append("]");
        return SB;
    }

    public void updateAreas(List<RDArea> areaList) {
        HashMap<Long, RDArea> localMap = new HashMap<Long, RDArea>();
        for (RDArea area : areaList) {
            localMap.put(area.getAreaId(), area);
        }
        this.areas.clear();
        this.areas.putAll(localMap);
    }

    void updateTables(List<RDTable> tableList) {
        HashMap<Long, RDTable> localMap = new HashMap<Long, RDTable>();
        for (RDTable table : tableList) {
            localMap.put(table.getTableId(), table);
        }
        this.tables.clear();
        this.tables.putAll(localMap);
    }

    void updateServices(List<RDService> serviceList) {
        HashMap<Long, RDService> localMap = new HashMap<Long, RDService>();
        for (RDService service : serviceList) {
            localMap.put(service.getServiceId(), service);
        }
        this.services.clear();
        this.services.putAll(localMap);
    }

    void updateSpecialRequests(List<RDSpecialRequest> specialRequestList) {
        HashMap<Long, RDSpecialRequest> localMap = new HashMap<Long, RDSpecialRequest>();
        for (RDSpecialRequest specialRequest : specialRequestList) {
            localMap.put(specialRequest.getSpecialRequestId(), specialRequest);
        }
        this.specialRequests.clear();
        this.specialRequests.putAll(localMap);
    }

    public void addBookingData(RDBooking newBooking) {
        this.bookings.put(newBooking.getBookingId(), newBooking);
    }

    void updateBookings(List<RDBooking> bookingList) {
        HashMap<Long, RDBooking> localMap = new HashMap<Long, RDBooking>();
        for (RDBooking booking : bookingList) {
            localMap.put(booking.getBookingId(), booking);
        }
        this.bookings.clear();
        this.bookings.putAll(localMap);
    }

    public RDArea getArea(Long areaID) {
        if (areaID != null) {
            return this.areas.get(areaID);
        }
        return null;
    }

    public RDTable getTable(Long tableID) {
        if (tableID != null) {
            return this.tables.get(tableID);
        }
        return null;
    }

    public List<RDTable> getTables(List<Long> tableIDs) {
        ArrayList<RDTable> rdTables = new ArrayList<RDTable>();
        for (Long tableID : tableIDs) {
            RDTable table = this.getTable(tableID);
            if (table == null) continue;
            rdTables.add(table);
        }
        return rdTables;
    }

    public List<Long> getTableIDs(String tableNames, Long rdAreaID) {
        ArrayList<Long> tableIDs = new ArrayList<Long>();
        for (String tableName : StringUtils.splitToList(tableNames, ",")) {
            Long tableID = this.getTableID(tableName, rdAreaID);
            if (tableID == null) continue;
            tableIDs.add(tableID);
        }
        return tableIDs;
    }

    public Long getAreaID(String areaName) {
        for (RDArea area : this.getAreas()) {
            if (!area.getName().equals(areaName)) continue;
            return area.getAreaId();
        }
        OrderMate.LOG.warn("There is no ResDiary area for the given name: " + areaName);
        return null;
    }

    public Long getTableID(String tableName, Long rdAreaID) {
        for (RDTable table : this.getTables()) {
            if (table.getAreaId() != rdAreaID.longValue() || !table.getNumber().equals(tableName)) continue;
            return table.getTableId();
        }
        OrderMate.LOG.warn("There is no ResDiary table for the given name: " + tableName + " and ResDiary area id: " + rdAreaID);
        return null;
    }

    List<RDBooking> getBookings() {
        return new ArrayList<RDBooking>(this.bookings.values());
    }

    List<RDArea> getAreas() {
        return new ArrayList<RDArea>(this.areas.values());
    }

    List<RDTable> getTables() {
        return new ArrayList<RDTable>(this.tables.values());
    }

    public RDBooking getBooking(Long bookingID) {
        if (bookingID != null) {
            return this.bookings.get(bookingID);
        }
        return null;
    }

    public int getTimeSlotInterval(Date time) {
        for (RDService service : this.services.values()) {
            Date startTime = DateTimeUtils.parseDateStringIntoLocalDate(service.getStartTime());
            Date endTime = DateTimeUtils.parseDateStringIntoLocalDate(service.getEndTime());
            if (!DateTimeUtils.timeIsAfter(time, startTime) || !DateTimeUtils.timeIsBefore(time, endTime)) continue;
            return service.getTimeSlotInterval();
        }
        return 15;
    }

    public String getSpecialRequestName(Long specialRequestId) {
        if (specialRequestId != null) {
            RDSpecialRequest specialRequest = this.specialRequests.get(specialRequestId);
            return specialRequest != null ? specialRequest.getTitle() : "";
        }
        return "";
    }

    private void addCustomerInterests(List<RDInterest> interests) {
        for (RDInterest rdInterest : interests) {
            CustomerInterest customerInterest = CustomerInterestQueries.getCustomerInterest(rdInterest.getName());
            if (customerInterest != null) continue;
            this.addCustomerInterest(rdInterest);
        }
    }

    private void addCustomerInterest(RDInterest rdInterest) {
        CustomerInterest newInterest = new CustomerInterest(rdInterest.getName());
        newInterest.setExternalId(rdInterest.getInterestId());
        newInterest.save();
    }

    public void clearBookings() {
        this.bookings.clear();
    }

    public String getTableNames(List<Long> tableIDs) {
        if (tableIDs == null || tableIDs.isEmpty()) {
            OrderMate.LOG.debug("ResDiary - tableIDs is null or empty!");
            return "";
        }
        ArrayList<String> tableNameList = new ArrayList<String>();
        for (Long tableID : tableIDs) {
            RDTable table = this.getTable(tableID);
            if (table == null) continue;
            tableNameList.add(table.getNumber());
        }
        Collections.sort(tableNameList, NaturalOrderComparator.getInstance());
        return StringUtils.mergeWithSeparator(tableNameList, ",");
    }
}

