/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.restaurantdiary;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.StringUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import ordermate.database.integration.RDConfiguration;
import ordermate.database.sales.Account;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.sales.reservation.ReservationsHelper;
import ordermate.database.tables.LogicalTable;
import ordermate.database.users.User;
import ordermate.integration.jaxb.restaurantdiary.Item;
import ordermate.integration.jaxb.restaurantdiary.Items;
import ordermate.integration.jaxb.restaurantdiary.RDBooking;
import ordermate.integration.jaxb.restaurantdiary.RDDiaryBooking;
import ordermate.integration.jaxb.restaurantdiary.Receipt;
import ordermate.integration.restaurantdiary.RDContext;
import ordermate.integration.restaurantdiary.RDMarshaller;
import ordermate.integration.restaurantdiary.RDTableMapper;
import ordermate.integration.restaurantdiary.enums.RDArrivalStatus;
import ordermate.integration.restaurantdiary.enums.RDBookingStatus;
import ordermate.integration.restaurantdiary.enums.RDMealStatus;

public enum RDConverter {
    INSTANCE;

    final int DEFAULT_PATRONS_NUMBER = 2;
    final String MSG_INVALID_ACCOUNT_TYPE = "Account must be Table Account or Bar Tab Account!";

    public RDBooking getRDBookingFromAccount(RDContext context, Account account) {
        if (!(account instanceof TableAccount) && !(account instanceof BarTabAccount)) {
            throw new IllegalArgumentException("Account must be Table Account or Bar Tab Account!");
        }
        RDBooking rdBooking = new RDBooking();
        String bookingDateStr = DateTimeUtils.buildDateString(account.getCreationDateTime());
        rdBooking.setBookingDateTime(bookingDateStr);
        rdBooking.setVisitDateTime(bookingDateStr);
        rdBooking.setArrivalStatus(RDArrivalStatus.FULLY_SEATED.getCode());
        rdBooking.setMealStatus(Integer.valueOf(RDMealStatus.NO_STATUS.getStatus()));
        rdBooking.setCovers(this.getCovers(account));
        rdBooking.setDuration(this.getDuration(context, account));
        rdBooking.setRestaurantId((long)RDConfiguration.getInstance().getRestaurantId());
        this.setTableAreaData(account, rdBooking, context);
        this.setBookingComment(rdBooking, account);
        rdBooking.setType(0);
        rdBooking.setStatus(RDBookingStatus.BOOKED.getCode());
        rdBooking.setCustomer(null);
        rdBooking.setCustomerSpend(0.0);
        rdBooking.setServiceId(0L);
        rdBooking.setBookingId(0L);
        rdBooking.setChannelId(0L);
        rdBooking.setChannelName("Internal");
        rdBooking.setMenuId(0L);
        rdBooking.setConfirmedByPhone(Boolean.FALSE);
        rdBooking.setIsLeaveTimeConfirmed(Boolean.FALSE);
        rdBooking.setTurnTime(0L);
        return rdBooking;
    }

    private int getDuration(RDContext context, Account account) {
        return account.getDuration() > 0 ? account.getDuration() : context.getTimeSlotInterval(account.getCreationDateTime());
    }

    private void setTableAreaData(Account account, RDBooking rdBooking, RDContext context) {
        BarTabAccount barTabAccount;
        LogicalTable barTabAcctTable;
        if (account instanceof TableAccount) {
            TableAccount tableAcc = (TableAccount)account;
            rdBooking.setAreaId(context.getAreaID(tableAcc.getTable().getTableGroup().getName()));
            rdBooking.getTables().addAll(RDTableMapper.INSTANCE.getRDTableIdList(context, tableAcc.getTable()));
        } else if (account instanceof BarTabAccount && (barTabAcctTable = (barTabAccount = (BarTabAccount)account).getLogicalTable()) != null) {
            rdBooking.setAreaId(context.getAreaID(barTabAcctTable.getTableGroup().getName()));
            rdBooking.getTables().addAll(RDTableMapper.INSTANCE.getRDTableIdList(context, barTabAcctTable));
        }
    }

    private void setBookingComment(RDBooking rdBooking, Account account) {
        if (account instanceof BarTabAccount) {
            rdBooking.setComments(this.getBarTabBookingComment((BarTabAccount)account));
        } else if (account instanceof TableAccount && account.getUser() != null) {
            rdBooking.setComments("created by OrderMate user " + account.getUser());
        }
    }

    private String getBarTabBookingComment(BarTabAccount barTab) {
        return "created by Bar Tab " + barTab.getLabel();
    }

    private int getCovers(Account account) {
        if (account instanceof TableAccount) {
            return this.getTableAccCovers(account);
        }
        return 2;
    }

    private int getTableAccCovers(Account account) {
        TableAccount tableAcc = (TableAccount)account;
        if (tableAcc.getNumPatrons() > 0) {
            return tableAcc.getNumPatrons();
        }
        return 2;
    }

    public RDBooking getRDBookingForTransfer(RDContext context, Account source, Account target) {
        Reservation sourceReservation = ReservationsHelper.getReservation((TableAccount)source, null);
        if (sourceReservation != null) {
            sourceReservation.setLeaveTime(new Date());
            sourceReservation.save();
            RDBooking targetBooking = INSTANCE.getRDBookingFromAccount(context, target);
            RDBooking sourceBooking = context.getBooking(sourceReservation.getExternalId() == null ? null : Long.valueOf(sourceReservation.getExternalId()));
            targetBooking.setComments(this.getTransferredTableComment(sourceReservation, targetBooking, source.getUser()));
            targetBooking.setCustomer(sourceBooking.getCustomer());
            return targetBooking;
        }
        OrderMateLog.LOG.warn("RDIntegrator#accountTransferred - Reservation is NOT found in the context, id: " + source);
        return null;
    }

    public String getTransferredTableComment(Reservation sourceReservation, RDBooking targetBooking, User user) {
        if (targetBooking == null || sourceReservation == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(StringUtils.nullToEmpty(targetBooking.getComments()));
        sb.append(" Booking id: " + sourceReservation.getExternalId() + " (Table:" + sourceReservation.getTables() + ") is transferred");
        if (user != null) {
            sb.append(" by " + user);
        }
        return sb.toString();
    }

    public RDBooking getRDBookingForClosing(RDContext context, Reservation reservation, Account account) {
        RDBooking rdBooking = context.getBooking(reservation.getExternalId() == null ? null : Long.valueOf(reservation.getExternalId()));
        if (rdBooking == null) {
            throw new IllegalStateException("ResDiary - There is NO booking object in cached context! Not possible to close!");
        }
        this.setPaymentDetailsForClosing(rdBooking, reservation, account);
        return rdBooking;
    }

    private void setPaymentDetailsForClosing(RDBooking booking, Reservation reservation, Account account) {
        if (account instanceof TableAccount) {
            booking.setCustomerSpend(account.getTotal().doubleValue());
            String receipt = this.createReceiptXmlFromAccount(account);
            if (receipt != null) {
                booking.setReceiptXml(receipt);
            }
        } else if (account instanceof BarTabAccount) {
            List<Account> accounts = reservation.getLinkedAccounts();
            double totalSpend = 0.0;
            for (Account acc : accounts) {
                totalSpend += acc.getTotal().doubleValue();
            }
            booking.setCustomerSpend(totalSpend);
            String receipt = this.createReceiptXmlFromAccounts(accounts);
            if (receipt != null) {
                booking.setReceiptXml(receipt);
            }
        }
    }

    public String createReceiptXmlFromAccount(Account account) {
        Receipt receipt = this.getReceipt(account);
        return new RDMarshaller().marshalToXML(receipt);
    }

    private String createReceiptXmlFromAccounts(List<Account> accounts) {
        Receipt receipt = new Receipt();
        Items items = new Items();
        for (Account account : accounts) {
            if (account == null) continue;
            this.addAccountItems(account, items);
        }
        receipt.setItems(items);
        return new RDMarshaller().marshalToXML(receipt);
    }

    protected Receipt getReceipt(Account account) {
        Receipt receipt = new Receipt();
        receipt.setItems(this.getAllItems(account));
        return receipt;
    }

    protected Items getAllItems(Account acc) {
        Items items = new Items();
        this.addAccountItems(acc, items);
        return items;
    }

    private void addAccountItems(Account acc, Items items) {
        for (SalesLineItem salesLineItem : acc.getItems()) {
            Item item = new Item();
            item.setPrice(salesLineItem.getPricePerItem().doubleValue());
            item.setQuantity(salesLineItem.getQuantity().getValue().intValue());
            item.setDescription(salesLineItem.getLabel());
            items.getItem().add(item);
        }
    }

    public void sortDiaryBookingsById(List<RDDiaryBooking> bookings, final boolean isDescending) {
        Collections.sort(bookings, new Comparator<RDDiaryBooking>(){

            @Override
            public int compare(RDDiaryBooking b1, RDDiaryBooking b2) {
                if (isDescending) {
                    return b2.getBookingId().compareTo(b1.getBookingId());
                }
                return b1.getBookingId().compareTo(b2.getBookingId());
            }
        });
    }
}

