/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.restaurantdiary;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.util.DateTimeUtils;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import ordermate.OrderMate;
import ordermate.database.integration.RDConfiguration;
import ordermate.database.misc.enums.ReservationIntegrationType;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.sales.reservation.ReservationsHelper;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.LogicalTableState;
import ordermate.integration.jaxb.restaurantdiary.RDBooking;
import ordermate.integration.reservations.ReservationIntegrator;
import ordermate.integration.restaurantdiary.RDContext;
import ordermate.integration.restaurantdiary.RDConverter;
import ordermate.integration.restaurantdiary.enums.RDArrivalStatus;
import ordermate.integration.restaurantdiary.enums.RDMealStatus;
import ordermate.integration.restaurantdiary.gateway.RDTaskMaster;
import ordermate.integration.restaurantdiary.tasks.RDGenericTask;
import ordermate.integration.restaurantdiary.tasks.RDTaskInputImpl;
import ordermate.integration.restaurantdiary.tasks.RDTaskType;
import ordermate.integration.restaurantdiary.tasks.RDTransferTaskInput;

public class RDIntegrator
extends UnicastRemoteObject
implements ReservationIntegrator {
    private RDContext context;
    private RDTaskMaster taskMaster;
    public static final ReservationIntegrationType TYPE = ReservationIntegrationType.RESTAURANTDIARY;
    private int syncBookingsFrequency = RDConfiguration.DEFAULT_SYNC_FREQUENCY;
    private Timer timerOfSyncBookings = new Timer();
    private TimerTask timerTaskOfSyncBookings;
    private static volatile RDIntegrator instance = null;

    protected RDTaskMaster createTaskMaster() {
        return new RDTaskMaster(this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RDIntegrator getInstance() throws RemoteException {
        if (instance != null) return instance;
        Class<RDIntegrator> clazz = RDIntegrator.class;
        synchronized (RDIntegrator.class) {
            if (instance != null) return instance;
            instance = new RDIntegrator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected RDIntegrator() throws RemoteException {
        this.context = new RDContext();
        this.taskMaster = this.createTaskMaster();
        this.setupTasks();
    }

    void setupTasks() {
        this.startTimerForRestaurantData();
        this.syncBookingsFrequency = this.getSyncFrequency();
        this.startTimerForBookings();
        this.taskMaster.addTask(new RDGenericTask(RDTaskType.GET_ALL_DIARY_BOOKINGS, new RDTaskInputImpl(null, new GregorianCalendar().getTime()), this.taskMaster));
    }

    private void startTimerForRestaurantData() {
        new Timer().scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                OrderMate.LOG.info("ResDiary - restaurant data pull timer task started!");
                try {
                    RDIntegrator.this.updateRestaurantData();
                }
                catch (Exception ex) {
                    OrderMate.LOG.error("ResDiary - Error in pulling restaurant data from ResDiary! ", (Throwable)ex);
                }
            }
        }, 0L, 86400000L);
    }

    private void startTimerForBookings() {
        this.timerTaskOfSyncBookings = new TimerTask(){

            @Override
            public void run() {
                try {
                    RDIntegrator.this.synchronizeReservations();
                }
                catch (Exception ex) {
                    OrderMate.LOG.error("ResDiary - Error in synchronising reservations!", (Throwable)ex);
                }
            }
        };
        this.timerOfSyncBookings.schedule(this.timerTaskOfSyncBookings, this.getFirstTimeOfSyncBookings(), this.getPeriodOfSyncBookings());
    }

    private Date getFirstTimeOfSyncBookings() {
        return DateTimeUtils.addTime(new Date(), 12, 1);
    }

    private long getPeriodOfSyncBookings() {
        return (long)this.syncBookingsFrequency * 60000L;
    }

    public void rescheduleBookingSync() {
        int newSyncFrequency = this.getSyncFrequency();
        if (newSyncFrequency != this.syncBookingsFrequency) {
            this.timerTaskOfSyncBookings.cancel();
            this.syncBookingsFrequency = newSyncFrequency;
            this.startTimerForBookings();
        }
    }

    private int getSyncFrequency() {
        return RDConfiguration.getInstance().getSyncFrequency();
    }

    @Override
    public void receiptPrinted(Account printed) throws RemoteException {
        if (printed != null && AccountType.tableType.equals(printed.getAccountType())) {
            TableAccount tableAcc = (TableAccount)printed;
            Reservation reservation = ReservationsHelper.getReservation(tableAcc, "ARRIVED");
            if (reservation != null) {
                this.addMealStatusTask(Long.valueOf(reservation.getExternalId()), RDMealStatus.BILL);
            } else {
                OrderMate.LOG.debug("There is no reservation for receipt printed table account " + tableAcc);
            }
        }
    }

    private void addMealStatusTask(Long bookingId, RDMealStatus mealStatus) {
        this.taskMaster.addTask(new RDGenericTask(RDTaskType.SEND_MEAL_STATUS, new RDTaskInputImpl(bookingId, mealStatus.getStatus()), null));
    }

    @Override
    public void synchronize() throws RemoteException {
        this.synchronizeReservations();
    }

    @Override
    public void synchronizeReservations() {
        this.addDiaryBookingDataTask(new Date());
    }

    void getDiaryBookingDataForDateRange(Date dateFrom, Date dateTo) {
        Calendar earlyDate = Calendar.getInstance();
        earlyDate.setTime(dateFrom);
        Calendar laterDate = Calendar.getInstance();
        laterDate.setTime(dateTo);
        if (earlyDate.compareTo(laterDate) > 0) {
            earlyDate.setTime(dateTo);
            laterDate.setTime(dateFrom);
        }
        DateTimeUtils.clearTimePart(earlyDate);
        DateTimeUtils.clearTimePart(laterDate);
        while (earlyDate.compareTo(laterDate) < 0) {
            this.addDiaryBookingDataTask(laterDate.getTime());
            laterDate.add(6, -1);
        }
        this.addDiaryBookingDataTask(laterDate.getTime());
    }

    void addDiaryBookingDataTask(Date date) {
        this.taskMaster.addTask(new RDGenericTask(RDTaskType.GET_DIARY_BOOKINGS, new RDTaskInputImpl(null, date), this.taskMaster));
    }

    @Override
    public void accountClosed(Account closed) throws RemoteException {
        if (closed != null && AccountType.tableType.equals(closed.getAccountType())) {
            TableAccount tableAcc = (TableAccount)closed;
            Reservation reservation = ReservationsHelper.getReservation(tableAcc, "ARRIVED");
            if (reservation == null) {
                OrderMate.LOG.warn("There is NO reservation for closed table account " + tableAcc);
                return;
            }
            this.closeReservation(reservation);
        }
    }

    private void closeReservation(Reservation reservation) {
        this.setLeaveTime(reservation);
        this.addClosingTasks(reservation);
    }

    private void setLeaveTime(Reservation reservation) {
        reservation.setLeaveTime(new Date());
        reservation.save();
    }

    @Override
    public void reservationTableClosed(Reservation reservation) throws RemoteException {
        if (reservation != null) {
            this.closeReservation(reservation);
        }
    }

    private void addClosingTasks(Reservation reservation) {
        if (reservation.getExternalId() == null) {
            throw new IllegalArgumentException("Reservation must have external reservation system id! ");
        }
        RDBooking rdBooking = RDConverter.INSTANCE.getRDBookingForClosing(this.context, reservation, reservation.getTableAccount());
        this.taskMaster.addTask(new RDGenericTask(RDTaskType.CLOSE_BOOKING, new RDTaskInputImpl(rdBooking.getBookingId(), rdBooking), null));
    }

    @Override
    public void tableStateUpdated(Account updated, LogicalTableState state) throws RemoteException {
        TableAccount tableAcc;
        Reservation reservation;
        if (updated != null && AccountType.tableType.equals(updated.getAccountType()) && (reservation = ReservationsHelper.getReservation(tableAcc = (TableAccount)updated, "ARRIVED")) != null) {
            try {
                this.addMealStatusTask(Long.valueOf(reservation.getExternalId()), RDMealStatus.getEnum(state.getExternalLabel()));
            }
            catch (Exception e) {
                OrderMate.LOG.warn("Invalid table state external label: " + state.getExternalLabel());
            }
        }
    }

    @Override
    public void accountLinkedToReservation(Account account, Reservation xparentRes) throws RemoteException {
        if (account != null && AccountType.tableType.equals(account.getAccountType())) {
            TableAccount tableAcc = (TableAccount)account;
            Reservation reservation = ReservationsHelper.getReservation(tableAcc, null);
            if (reservation == null) {
                OrderMate.LOG.debug("There is no reservation for the table account: " + tableAcc);
                return;
            }
            if (reservation.getExternalId() != null) {
                this.taskMaster.addTask(new RDGenericTask(RDTaskType.SEND_ARRIVAL_STATUS, new RDTaskInputImpl(Long.valueOf(reservation.getExternalId()), String.valueOf(RDArrivalStatus.FULLY_SEATED.getCode())), null));
            }
        }
    }

    public void updateRestaurantData() {
        this.taskMaster.addTask(new RDGenericTask(RDTaskType.GET_RESTAURANT, null, null));
    }

    public RDContext getContext() {
        return this.context;
    }

    @Override
    public void reservationUpdated(Reservation reservation) throws RemoteException {
        if (reservation.getExternalId() == null) {
            return;
        }
        Long bookingId = Long.valueOf(reservation.getExternalId());
        RDBooking rdBooking = this.context.getBooking(bookingId);
        if (rdBooking != null && !RDMealStatus.CLOSED.getStatus().equals(rdBooking.getMealStatus().toString())) {
            boolean isChanged = this.updateCovers(reservation, rdBooking);
            isChanged |= this.updateDate(reservation, rdBooking);
            isChanged |= this.updateTables(reservation, rdBooking);
            if (isChanged |= this.updateComments(reservation, rdBooking)) {
                this.taskMaster.addTask(new RDGenericTask(RDTaskType.UPDATE_BOOKING, new RDTaskInputImpl(bookingId, rdBooking), null));
            }
        }
    }

    private boolean updateCovers(Reservation reservation, RDBooking rdBooking) {
        boolean isChanged = false;
        if (!reservation.getNumPatrons().equals(rdBooking.getCovers())) {
            rdBooking.setCovers(reservation.getNumPatrons());
            isChanged = true;
        }
        return isChanged;
    }

    private boolean updateDate(Reservation reservation, RDBooking rdBooking) {
        boolean isChanged = false;
        Date newDate = DateTimeUtils.mergeDateAndTime(reservation.getDate(), reservation.getTime());
        Date currentDate = DateTimeUtils.parseDateStringIntoLocalDate(rdBooking.getVisitDateTime());
        if (!currentDate.equals(newDate)) {
            rdBooking.setVisitDateTime(DateTimeUtils.buildDateString(newDate));
            isChanged = true;
        }
        return isChanged;
    }

    private boolean updateComments(Reservation reservation, RDBooking rdBooking) {
        boolean isChanged = false;
        if (!rdBooking.getComments().equals(reservation.getComments())) {
            rdBooking.setComments(reservation.getComments());
            isChanged = true;
        }
        return isChanged;
    }

    private boolean updateTables(Reservation reservation, RDBooking rdBooking) {
        Long rdAreaID = this.context.getAreaID(reservation.getSection().getName());
        List<Long> tableIDs = this.context.getTableIDs(reservation.getTables(), rdAreaID);
        if (tableIDs == null || rdAreaID == null || tableIDs.isEmpty()) {
            OrderMate.LOG.warn("ResDiary - SYNCHRONISE SECTIONS AND TABLES between OrderMate and ResDiary!");
            return false;
        }
        rdBooking.setAreaId(rdAreaID);
        rdBooking.getTables().clear();
        rdBooking.getTables().addAll(this.context.getTableIDs(reservation.getTables(), rdAreaID));
        return true;
    }

    void setTaskMaster(RDTaskMaster taskMaster) {
        this.taskMaster = taskMaster;
    }

    @Override
    public void reservationAccountCreated(Account account, int duration) throws RemoteException {
        BarTabAccount barTabAccount;
        LogicalTable barTabTable;
        if (account == null) {
            throw new IllegalArgumentException("Reservation account cannot be null!");
        }
        account.setDuration(duration);
        if (AccountType.tableType.equals(account.getAccountType())) {
            TableAccount tableAcc = (TableAccount)account;
            if (tableAcc.getTable() != null) {
                this.taskMaster.addTask(new RDGenericTask(RDTaskType.CREATE_BOOKING, new RDTaskInputImpl(null, account), null));
            }
        } else if (AccountType.barTabType.equals(account.getAccountType()) && (barTabTable = (barTabAccount = (BarTabAccount)account).getLogicalTable()) != null && barTabTable.getBarTabs().size() == 1) {
            this.taskMaster.addTask(new RDGenericTask(RDTaskType.CREATE_BOOKING, new RDTaskInputImpl(null, account), null));
        }
    }

    @Override
    public void reservationAccountTransferred(Account source, Account target, int duration) throws RemoteException {
        if (source != null && target != null && AccountType.tableType.equals(target.getAccountType())) {
            target.setDuration(duration);
            TableAccount targetAcc = (TableAccount)target;
            Reservation targetReservation = ReservationsHelper.getReservation(targetAcc, "ARRIVED");
            if (targetReservation == null) {
                this.taskMaster.addTask(new RDGenericTask(RDTaskType.TRANSFER_BOOKING, new RDTransferTaskInput(null, target, source), null));
            } else if (targetReservation.getExternalId() != null) {
                RDBooking targetBooking = this.context.getBooking(Long.valueOf(targetReservation.getExternalId()));
                if (targetBooking != null) {
                    this.updateTargetBooking(source, targetBooking);
                } else {
                    OrderMateLog.LOG.warn("RDIntegrator#accountTransferred - RDBooking is NOT found in the context, id: " + targetReservation.getExternalId());
                }
            } else {
                OrderMateLog.LOG.warn("RDIntegrator#accountTransferred - No booking id");
            }
        }
    }

    private void updateTargetBooking(Account source, RDBooking targetBooking) {
        if (source instanceof TableAccount) {
            Reservation sourceReservation = ReservationsHelper.getReservation((TableAccount)source, null);
            if (sourceReservation != null) {
                targetBooking.setComments(RDConverter.INSTANCE.getTransferredTableComment(sourceReservation, targetBooking, source.getUser()));
                this.taskMaster.addTask(new RDGenericTask(RDTaskType.UPDATE_BOOKING, new RDTaskInputImpl(targetBooking.getBookingId(), targetBooking), null));
            } else {
                OrderMateLog.LOG.warn("RDIntegrator#accountTransferred - Reservation is NOT found in the context, id: " + source);
            }
        }
    }

    @Override
    public void clearReservations() throws RemoteException {
        this.context.clearBookings();
    }

    protected int getSyncBookingsFrequency() {
        return this.syncBookingsFrequency;
    }

    @Override
    public boolean isOffThread() throws RemoteException {
        return true;
    }

    @Override
    public ReservationIntegrator.ReservationTwoWay getTwoWayIntegration() throws RemoteException {
        return ReservationIntegrator.ReservationTwoWay.Explicit;
    }
}

