/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.restaurantdiary;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import ordermate.OrderMate;
import ordermate.misc.ObjectMarshaller;

public class RDMarshaller
extends ObjectMarshaller {
    @Override
    protected void initMapper() {
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
            JacksonAnnotationIntrospector introspector = new JacksonAnnotationIntrospector();
            this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            this.mapper.setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategy.PascalCaseStrategy());
            this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
            this.mapper.getDeserializationConfig().with((AnnotationIntrospector)introspector);
            this.mapper.getSerializationConfig().with((AnnotationIntrospector)introspector);
        }
    }

    public String marshalToXML(Object toMarshal) {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)toMarshal.getClass().getPackage().getName());
            Marshaller marsh = jc.createMarshaller();
            StringWriter writer = new StringWriter();
            marsh.marshal(toMarshal, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            OrderMate.LOG.error("Unable to marshal to XML!", (Throwable)e);
            return null;
        }
    }
}

