/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.restaurantdiary;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.DateTimeUtils;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.config.customer.CustomerInterest;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.queries.config.customer.CustomerInterestQueries;
import ordermate.database.queries.sales.CustomerCategoryQueries;
import ordermate.database.sales.Account;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.sales.reservation.ReservationsHelper;
import ordermate.database.users.User;
import ordermate.integration.jaxb.restaurantdiary.RDBooking;
import ordermate.integration.jaxb.restaurantdiary.RDCustomer;
import ordermate.integration.reservations.HeadlessReservationArriver;
import ordermate.integration.reservations.ReservationMaker;
import ordermate.integration.restaurantdiary.RDContext;
import ordermate.integration.restaurantdiary.RDIntegrator;
import ordermate.integration.restaurantdiary.RDTableMapper;
import ordermate.integration.restaurantdiary.enums.RDArrivalStatus;
import ordermate.integration.restaurantdiary.enums.RDBookingStatus;
import ordermate.integration.restaurantdiary.enums.RDMealStatus;

public class RDReservationMaker
implements ReservationMaker<RDBooking> {
    private static volatile RDReservationMaker instance = null;
    public static final String VIP_COMMENT = "[VIP] ";
    final int MINIMUM_TIME_TO_UNSEAT_RESERVATION = 3;

    private RDReservationMaker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RDReservationMaker getInstance() {
        if (instance != null) return instance;
        Class<RDReservationMaker> clazz = RDReservationMaker.class;
        synchronized (RDReservationMaker.class) {
            if (instance != null) return instance;
            instance = new RDReservationMaker();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private Reservation updateReservation(RDBooking rdBooking) {
        Reservation reservation = ReservationsHelper.getReservationByExternalID(rdBooking.getBookingId());
        if (reservation == null) {
            OrderMate.LOG.warn("ResDiary - A reservation expected to be in the database suddenly is not!");
            return null;
        }
        if ("DELETED".equals(reservation.getSystemState())) {
            return reservation;
        }
        if (this.isReservationCancelled(rdBooking)) {
            return this.cancelReservation(reservation);
        }
        if (!"ARRIVED".equals(reservation.getReservationState()) && this.isPartyArrived(rdBooking)) {
            this.arriveParty(reservation);
        } else if ("ARRIVED".equals(reservation.getReservationState()) && this.isPartyUnarrived(rdBooking) && !this.isReservationRecentArrived(reservation)) {
            this.unarriveParty(reservation);
        }
        this.saveReservation(rdBooking, reservation, null);
        return reservation;
    }

    boolean isReservationRecentArrived(Reservation reservation) {
        Date accountCreationTime;
        Date minDatetimeToUnseat;
        Account account = reservation.getTableAccount();
        if (account != null && DateTimeUtils.compareDates(new Date(), minDatetimeToUnseat = DateTimeUtils.addTime(accountCreationTime = account.getCreationDateTime(), 12, 3), true) > 0) {
            return false;
        }
        OrderMate.LOG.warn("ResDiary - The " + reservation + " is recently arrived so it cannot be unseated!");
        return true;
    }

    private Reservation saveReservation(RDBooking rdBooking, Reservation reservation, Account account) {
        Customer customer = this.createOrUpdateCustomer(rdBooking.getCustomer());
        Date visitDate = DateTimeUtils.parseDateStringIntoLocalDate(rdBooking.getVisitDateTime());
        reservation.setCustomer(customer);
        reservation.setDate(visitDate);
        reservation.setTime(visitDate);
        reservation.setNumPatrons(rdBooking.getCovers());
        reservation.setComments(this.buildRDComment(rdBooking));
        reservation.setExternalId(rdBooking.getBookingId() == null ? null : String.valueOf(rdBooking.getBookingId()));
        this.setSectionAndTables(rdBooking, reservation);
        reservation.setLeaveTime(DateTimeUtils.addTime(visitDate, 12, rdBooking.getDuration() != null ? rdBooking.getDuration() : 0));
        if (account != null) {
            reservation.setTableAccount(account);
            reservation.setReservationState("ARRIVED");
        }
        reservation.save();
        return reservation;
    }

    private void setSectionAndTables(RDBooking rdBooking, Reservation reservation) {
        RDContext context = this.getRDContext();
        if (context != null) {
            reservation.setSection(RDTableMapper.INSTANCE.getTableGroup(rdBooking, context));
            reservation.setTables(context.getTableNames(rdBooking.getTables()));
        }
    }

    private RDContext getRDContext() {
        try {
            return RDIntegrator.getInstance().getContext();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private boolean isReservationCancelled(RDBooking booking) {
        return booking.getStatus().intValue() == RDBookingStatus.CANCELLED.getCode();
    }

    private Reservation cancelReservation(Reservation reservation) {
        reservation.deleteReservation();
        reservation.save();
        TerminalEventLog.logReservationDeleted(reservation, new EventContext(Terminal.getServerMateTerminal(), User.getSystemUser()));
        return reservation;
    }

    private Customer createOrUpdateCustomer(RDCustomer rdCustomer) {
        Customer customer = null;
        if (rdCustomer != null) {
            customer = this.checkForExistingCustomer(rdCustomer);
            if (customer == null) {
                customer = this.createCustomer(rdCustomer);
            } else {
                this.saveCustomer(customer, rdCustomer);
            }
        }
        return customer;
    }

    protected String buildRDComment(RDBooking rdBooking) {
        StringBuilder SB = new StringBuilder();
        RDCustomer cust = rdBooking.getCustomer();
        if (this.isVipCustomer(cust)) {
            SB.append(VIP_COMMENT);
        }
        SB.append(rdBooking.getComments());
        return SB.toString();
    }

    private boolean isReservationMakeable(RDBooking bookingToAdd) {
        return bookingToAdd != null && bookingToAdd.getMealStatus().compareTo(Integer.valueOf(RDMealStatus.PAID.getStatus())) < 0 && bookingToAdd.getStatus().intValue() != RDBookingStatus.PENDING.getCode();
    }

    @Override
    public Reservation makeReservation(RDBooking rdBooking, Account account) {
        Reservation reservation;
        if (!this.isReservationMakeable(rdBooking)) {
            return null;
        }
        if (!ReservationsHelper.isReservationExists(rdBooking.getBookingId())) {
            reservation = this.createReservation(rdBooking, account);
            this.createAccountLink(reservation, account);
        } else {
            reservation = this.updateReservation(rdBooking);
        }
        return reservation;
    }

    @Override
    public Reservation makeReservation(RDBooking booking) {
        return this.makeReservation(booking, (Account)null);
    }

    private void createAccountLink(Reservation res, Account account) {
        if (account instanceof BarTabAccount) {
            res.linkAccount(account);
            res.save();
        }
    }

    protected Reservation createReservation(RDBooking bookingToAdd, Account account) {
        Reservation reservation = new Reservation();
        this.saveReservation(bookingToAdd, reservation, account);
        if (account == null && this.isPartyArrived(bookingToAdd)) {
            this.arriveParty(reservation);
        }
        TerminalEventLog.logReservationBooked(reservation, new EventContext(Terminal.getServerMateTerminal(), User.getSystemUser()));
        return reservation;
    }

    private void arriveParty(Reservation reservation) {
        HeadlessReservationArriver arriver = new HeadlessReservationArriver(reservation);
        if (arriver.arriveParty() == null) {
            reservation.setReservationState("BOOKED");
            reservation.save();
        }
    }

    private void unarriveParty(Reservation reservation) {
        HeadlessReservationArriver arriver = new HeadlessReservationArriver(reservation);
        arriver.unarriveParty();
    }

    private boolean isPartyArrived(RDBooking booking) {
        return RDArrivalStatus.FULLY_SEATED.getCode().equals(booking.getArrivalStatus()) || RDArrivalStatus.PARTIALLY_SEATED.getCode().equals(booking.getArrivalStatus());
    }

    private boolean isPartyUnarrived(RDBooking booking) {
        return RDArrivalStatus.NOT_ARRIVED.getCode().equals(booking.getArrivalStatus());
    }

    protected Customer createCustomer(RDCustomer rdCustomer) {
        Customer ordermateCust = new Customer();
        return this.saveCustomer(ordermateCust, rdCustomer);
    }

    protected Customer saveCustomer(Customer customer, RDCustomer rdCustomer) {
        customer.setTitle(rdCustomer.getTitle());
        customer.setFirstName(rdCustomer.getFirstName());
        customer.setLastName(rdCustomer.getSurname());
        customer.setEmail(rdCustomer.getEmail());
        customer.setDOB(DateTimeUtils.parseDateStringIntoLocalDate(rdCustomer.getBirthday()));
        customer.setAnniversary(DateTimeUtils.parseDateStringIntoLocalDate(rdCustomer.getAnniversary()));
        customer.setPrimaryPhoneNumber(rdCustomer.getPhoneNumber());
        customer.setSecondaryPhoneNumber(rdCustomer.getMobileNumber());
        customer.setCompany(rdCustomer.getCompany());
        customer.setComments(rdCustomer.getComments());
        this.addCustomerInterests(customer, rdCustomer.getInterests());
        this.setCustomerCategory(customer, rdCustomer);
        customer.save();
        return customer;
    }

    private void setCustomerCategory(Customer customer, RDCustomer rdCustomer) {
        if (this.isVipCustomer(rdCustomer)) {
            customer.setCategory(CustomerCategoryQueries.getVipCategory());
        } else {
            customer.setCategory(CustomerCategory.getDefaultCategory());
        }
    }

    private boolean isVipCustomer(RDCustomer rdCustomer) {
        return rdCustomer != null && rdCustomer.isIsVip() != null && rdCustomer.isIsVip() != false;
    }

    private void addCustomerInterests(Customer customer, List<Long> interests) {
        for (Long interestId : interests) {
            CustomerInterest custInterest = CustomerInterestQueries.getCustomerInterest(interestId);
            if (custInterest == null) continue;
            customer.addInterest(custInterest);
        }
    }

    protected Customer checkForExistingCustomer(RDCustomer rdcustomer) {
        ObjectQuery oQuery = new ObjectQuery();
        oQuery.select(Customer.class).equals(Customer.Properties.FIRST_NAME, rdcustomer.getFirstName()).equals(Customer.Properties.LAST_NAME, rdcustomer.getSurname()).equals(Customer.Properties.SYSTEM_STATE, "ACTIVE").group().equals(Customer.Properties.E_MAIL, rdcustomer.getEmail()).or().equals(Customer.Properties.PRIMARY_PHONE_NUMBER, rdcustomer.getPhoneNumber()).or().equals(Customer.Properties.PRIMARY_PHONE_NUMBER, rdcustomer.getMobileNumber()).or().equals(Customer.Properties.SECONDARY_PHONE_NUMBER, rdcustomer.getPhoneNumber()).or().equals(Customer.Properties.SECONDARY_PHONE_NUMBER, rdcustomer.getMobileNumber()).endGroup().orderBy(Customer.Properties.E_MAIL).orderBy(Customer.Properties.PRIMARY_PHONE_NUMBER).orderBy(Customer.Properties.SECONDARY_PHONE_NUMBER);
        return PersistenceManager.getObject(Customer.class, oQuery.toString());
    }
}

