/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.restaurantdiary;

import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.queries.tables.LogicalTableQueries;
import ordermate.database.queries.tables.PhysicalTableQueries;
import ordermate.database.queries.tables.TableGroupQueries;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.PhysicalTable;
import ordermate.database.tables.TableGroup;
import ordermate.integration.jaxb.restaurantdiary.RDArea;
import ordermate.integration.jaxb.restaurantdiary.RDBooking;
import ordermate.integration.jaxb.restaurantdiary.RDTable;
import ordermate.integration.restaurantdiary.RDContext;

public enum RDTableMapper {
    INSTANCE;


    public boolean validateTableExists(RDTable table, RDArea area) {
        if (table != null && area != null) {
            return PhysicalTableQueries.getPhysicalTable(table.getNumber(), area.getName()) != null;
        }
        return false;
    }

    public LogicalTable getLogicalTable(RDTable table, RDArea area) {
        if (table != null && area != null) {
            PhysicalTable physicalTable = this.getPhysicalTable(table.getNumber(), area.getName());
            return physicalTable != null ? physicalTable.getLogicalTable() : null;
        }
        return null;
    }

    public boolean isJoinedTable(RDTable table, RDArea area) {
        if (table != null && area != null) {
            return PhysicalTableQueries.isJoinedTable(table.getNumber(), area.getName());
        }
        return false;
    }

    public boolean areJoinedTables(List<RDTable> rdTables, RDContext context) {
        if (rdTables != null && !rdTables.isEmpty()) {
            List<PhysicalTable> physicalTables = this.getPhysicalTableList(rdTables, context);
            return PhysicalTableQueries.areJoinedTables(physicalTables);
        }
        return false;
    }

    private PhysicalTable getPhysicalTable(String tableName, String tableGroupName) {
        return PhysicalTableQueries.getPhysicalTable(tableName, tableGroupName);
    }

    public boolean areTablesAvailable(List<RDTable> rdTables, RDContext context) {
        if (rdTables != null && !rdTables.isEmpty()) {
            List<PhysicalTable> physicalTables = this.getPhysicalTableList(rdTables, context);
            return PhysicalTableQueries.areTablesAvailable(physicalTables);
        }
        return false;
    }

    private List<PhysicalTable> getPhysicalTableList(List<RDTable> rdTables, RDContext context) {
        ArrayList<PhysicalTable> physicalTables = new ArrayList<PhysicalTable>();
        for (RDTable rdTable : rdTables) {
            PhysicalTable table = this.getPhysicalTable(rdTable.getNumber(), context.getArea(rdTable.getAreaId()).getName());
            if (table == null) continue;
            physicalTables.add(table);
        }
        return physicalTables;
    }

    public List<Long> getRDTableIdList(RDContext context, LogicalTable logicalTable) {
        if (context == null || logicalTable == null) {
            return null;
        }
        String tableNames = LogicalTableQueries.getTableNames(logicalTable);
        Long rdAreaId = context.getAreaID(logicalTable.getTableGroup().getName());
        return context.getTableIDs(tableNames, rdAreaId);
    }

    public TableGroup getTableGroup(RDBooking booking, RDContext context) {
        RDArea area = context.getArea(booking.getAreaId());
        if (area != null) {
            return this.getTableGroup(area);
        }
        OrderMate.LOG.warn("Unexpected RDArea id: Does not match an RDArea in RestaurantdiaryContext (RDArea.id = " + booking.getAreaId() + ")");
        return null;
    }

    public TableGroup getTableGroup(RDArea area) {
        if (area != null) {
            for (TableGroup group : TableGroupQueries.getTableGroups()) {
                if (!group.getName().trim().equalsIgnoreCase(area.getName().trim())) continue;
                return group;
            }
        }
        return null;
    }
}

