/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.restaurantdiary.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum RDMealStatus {
    NO_STATUS("NoStatus", 0),
    OPEN("Open", 1),
    DRINKS("Drinks", 2),
    STARTER("Starter", 3),
    MAIN("Main", 4),
    DESSERT("Dessert", 5),
    BILL("Bill", 6),
    CLEANING("Cleaning", 7),
    PAID("Paid", 8),
    CLEANED("Cleaned", 9),
    CLOSED("Closed", 10),
    CLEANED_READY("CleanedAndReady", 11);

    private final String label;
    private final int status;
    private static final Map<String, RDMealStatus> lookup;

    private RDMealStatus(String label, int status) {
        this.label = label;
        this.status = status;
    }

    public String getStatus() {
        return String.valueOf(this.status);
    }

    public String getLabel() {
        return this.label;
    }

    public static RDMealStatus getEnum(String label) {
        RDMealStatus mealStatus = lookup.get(label);
        if (mealStatus != null) {
            return mealStatus;
        }
        throw new IllegalArgumentException();
    }

    static {
        lookup = new HashMap<String, RDMealStatus>();
        for (RDMealStatus mealStatus : EnumSet.allOf(RDMealStatus.class)) {
            lookup.put(mealStatus.getLabel(), mealStatus);
            lookup.put(mealStatus.getStatus(), mealStatus);
        }
    }
}

