/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.restaurantdiary.gateway;

import au.com.ordermate.gateway.Gateway;
import au.com.ordermate.gateway.GatewayNotifier;
import au.com.ordermate.gateway.NotInGatewayAuthorizer;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import ordermate.OrderMate;
import ordermate.integration.restaurantdiary.RDContext;
import ordermate.integration.restaurantdiary.gateway.RDGatewayProcessor;
import ordermate.integration.restaurantdiary.tasks.RDTask;

public class RDTaskMaster
implements GatewayNotifier<RDTask> {
    private static final int RETRY_WAIT_TIME = 15000;
    private static final int PROCESS_QUEUE_LENGTH = 4096;
    private static final int PUT_TIMEOUT = 500;
    private static final int MAX_ATTEMPTS = 1;
    private final Gateway<RDTask> rdGateway;
    private final RDContext context;
    private Set<RDTask> retrySet;
    private Timer retryTimer;

    public RDTaskMaster(RDContext newContext) {
        this(newContext, 15000, 4096, 1);
    }

    public RDTaskMaster(RDContext newContext, int retryWaitTime, int processQueueLength, int maxRetryAttempts) {
        this.context = newContext;
        this.rdGateway = new Gateway<RDTask>(new RDGatewayProcessor(this.context), this, new NotInGatewayAuthorizer(), processQueueLength);
        this.retrySet = new HashSet<RDTask>();
        this.rdGateway.setPutTimeout(500);
        this.rdGateway.startService();
        this.retryTimer = new Timer();
        this.retryTimer.schedule((TimerTask)new RetryQueueWorker(maxRetryAttempts), retryWaitTime, (long)retryWaitTime);
    }

    public RDContext getContext() {
        return this.context;
    }

    Set<RDTask> getRetrySet() {
        return this.retrySet;
    }

    Gateway<RDTask> getRDGateway() {
        return this.rdGateway;
    }

    public void pauseTasks() {
        if (this.rdGateway.isRunning()) {
            this.rdGateway.stopService();
        }
    }

    public void restartTasks() {
        if (!this.rdGateway.isRunning()) {
            this.rdGateway.startService();
        }
    }

    public void addTask(RDTask task) {
        OrderMate.LOG.debug("Adding Task " + task.getLabel());
        this.sendForProcessing(task);
    }

    void sendForProcessing(RDTask task) {
        if (this.rdGateway.isAuthorised(task)) {
            if (!this.rdGateway.putIntoQueue(task)) {
                OrderMate.LOG.warn("RDTaskMaster didn't put the task into queue; Task: " + task.getLabel());
                this.notifyProcess(task, false);
            }
        } else {
            OrderMate.LOG.warn("The ResDiary task is in already gateway's blocking queue! " + task.getLabel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyProcess(RDTask processedValue, boolean processSuccessful) {
        if (processSuccessful) {
            Set<RDTask> set = this.retrySet;
            synchronized (set) {
                this.retrySet.remove(processedValue);
            }
        }
        Set<RDTask> set = this.retrySet;
        synchronized (set) {
            this.retrySet.add(processedValue);
        }
    }

    class RetryQueueWorker
    extends TimerTask {
        private int maxAttempts;

        public RetryQueueWorker(int maxAttemps) {
            this.maxAttempts = maxAttemps;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashSet needToProcess;
            Set set = RDTaskMaster.this.retrySet;
            synchronized (set) {
                if (RDTaskMaster.this.retrySet.size() <= 0) {
                    return;
                }
                needToProcess = new HashSet();
                needToProcess.addAll(RDTaskMaster.this.retrySet);
            }
            for (RDTask task : needToProcess) {
                if (task.getAttempts() < this.maxAttempts) {
                    RDTaskMaster.this.sendForProcessing(task);
                    continue;
                }
                OrderMate.LOG.debug("max attemps exceeded - rdTask dropped from the retrySet: " + task);
                RDTaskMaster.this.notifyProcess(task, true);
            }
        }
    }
}

