/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.restaurantdiary.tasks;

import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.integration.RDConfiguration;
import ordermate.database.sales.Account;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.sales.reservation.ReservationsHelper;
import ordermate.integration.jaxb.restaurantdiary.RDBooking;
import ordermate.integration.jaxb.restaurantdiary.RDDiaryBooking;
import ordermate.integration.jaxb.restaurantdiary.RDRestaurant;
import ordermate.integration.restaurantdiary.RDContext;
import ordermate.integration.restaurantdiary.RDConverter;
import ordermate.integration.restaurantdiary.RDReservationMaker;
import ordermate.integration.restaurantdiary.enums.RDMealStatus;
import ordermate.integration.restaurantdiary.gateway.RDTaskMaster;
import ordermate.integration.restaurantdiary.tasks.RDGenericTask;
import ordermate.integration.restaurantdiary.tasks.RDTaskController;
import ordermate.integration.restaurantdiary.tasks.RDTaskInput;
import ordermate.integration.restaurantdiary.tasks.RDTaskInputImpl;
import ordermate.integration.restaurantdiary.tasks.RDTransferTaskInput;
import ordermate.integration.restaurantdiary.webservice.RDWebHelper;

public enum RDTaskType {
    SEND_ARRIVAL_STATUS{

        @Override
        public boolean processTask(RDContext context, RDTaskInput input, RDTaskMaster taskMaster) {
            return webHelper.addArrivalStatus(input);
        }
    }
    ,
    SEND_MEAL_STATUS{

        @Override
        public boolean processTask(RDContext context, RDTaskInput input, RDTaskMaster taskMaster) {
            return webHelper.addMealStatus(input) != null;
        }
    }
    ,
    SEND_RECEIPT{

        @Override
        public boolean processTask(RDContext context, RDTaskInput input, RDTaskMaster taskMaster) {
            return webHelper.addReceipt(input);
        }
    }
    ,
    SEND_CUSTOMER_SPEND{

        @Override
        public boolean processTask(RDContext context, RDTaskInput input, RDTaskMaster taskMaster) {
            RDBooking booking = context.getBooking(input.getBookingId());
            if (booking != null) {
                Price customerSpend = (Price)input.getData();
                booking.setCustomerSpend(customerSpend.doubleValue());
                return webHelper.putBooking(new RDTaskInputImpl(booking.getBookingId(), booking));
            }
            OrderMate.LOG.debug("Attempted to pull RDBooking:" + input.getBookingId() + " from the context but it was not found!");
            return false;
        }
    }
    ,
    GET_RESTAURANT{

        @Override
        public boolean processTask(RDContext context, RDTaskInput input, RDTaskMaster taskMaster) {
            RDRestaurant restaurant = webHelper.getRestaurant();
            if (restaurant != null) {
                context.updateRestaurant(restaurant);
                return true;
            }
            OrderMate.LOG.debug("Unable to get restaurant data!");
            return false;
        }
    }
    ,
    GET_BOOKING{

        @Override
        public boolean processTask(RDContext context, RDTaskInput input, RDTaskMaster taskMaster) {
            RDBooking newBooking = webHelper.getBooking(input.getBookingId());
            if (newBooking != null) {
                this.removeEmojis(newBooking);
                RDReservationMaker.getInstance().makeReservation(newBooking);
                context.addBookingData(newBooking);
            } else {
                OrderMate.LOG.warn("Resdairy: getting the booking info  " + input.getBookingId() + " result =null");
            }
            return true;
        }

        private void removeEmojis(RDBooking booking) {
            booking.setComments(StringUtils.removeEmojis(booking.getComments()));
            if (booking.getCustomer() != null) {
                booking.getCustomer().setComments(StringUtils.removeEmojis(booking.getCustomer().getComments()));
            }
        }
    }
    ,
    CREATE_BOOKING{

        @Override
        public boolean processTask(RDContext context, RDTaskInput input, RDTaskMaster taskMaster) {
            if (!(input.getData() instanceof TableAccount) && !(input.getData() instanceof BarTabAccount)) {
                throw new IllegalArgumentException("CREATE_BOOKING - Not valid task input; input data should be TableAccount!");
            }
            RDBooking booking = RDConverter.INSTANCE.getRDBookingFromAccount(context, (Account)input.getData());
            return RDTaskType.createBooking(context, input, booking);
        }
    }
    ,
    UPDATE_BOOKING{

        @Override
        public boolean processTask(RDContext context, RDTaskInput input, RDTaskMaster taskMaster) {
            return webHelper.putBooking(input);
        }
    }
    ,
    GET_DIARY_BOOKINGS{

        @Override
        public boolean processTask(RDContext context, RDTaskInput input, RDTaskMaster taskMaster) {
            List<RDDiaryBooking> diaryBookings = webHelper.getDiaryData(input);
            HashSet<Long> bookingsPulled = new HashSet<Long>();
            if (diaryBookings != null) {
                RDConverter.INSTANCE.sortDiaryBookingsById(diaryBookings, true);
                for (RDDiaryBooking diaryBooking : diaryBookings) {
                    if (!RDTaskController.getInstance().shouldGetBooking(diaryBooking)) continue;
                    taskMaster.addTask(new RDGenericTask(GET_BOOKING, new RDTaskInputImpl(diaryBooking.getBookingId(), null), null));
                    bookingsPulled.add(diaryBooking.getBookingId());
                }
                Date date = new Date();
                for (Reservation reservation : ReservationsHelper.getExternalReservations(RDConfiguration.getInstance().getDateForSyncMinus(date), RDConfiguration.getInstance().getDateForSyncPlus(date))) {
                    if (reservation.getExternalId() == null || bookingsPulled.contains(Long.valueOf(reservation.getExternalId()))) continue;
                    taskMaster.addTask(new RDGenericTask(GET_BOOKING, new RDTaskInputImpl(reservation.getExternalId() == null ? null : Long.valueOf(reservation.getExternalId()), null), null));
                }
                bookingsPulled.clear();
                bookingsPulled = null;
                context.setLastSyncDate(new Date());
                return true;
            }
            return false;
        }
    }
    ,
    GET_ALL_DIARY_BOOKINGS{

        @Override
        public boolean processTask(RDContext context, RDTaskInput input, RDTaskMaster taskMaster) {
            List<RDDiaryBooking> bookings = webHelper.getDiaryData(input);
            if (bookings != null) {
                for (RDDiaryBooking booking : bookings) {
                    taskMaster.addTask(new RDGenericTask(GET_BOOKING, new RDTaskInputImpl(booking.getBookingId(), null), null));
                }
                context.setLastSyncDate(new Date());
                return true;
            }
            return false;
        }
    }
    ,
    CLOSE_BOOKING{

        @Override
        public boolean processTask(RDContext context, RDTaskInput input, RDTaskMaster taskMaster) {
            OrderMate.LOG.info("Calling to close Booking " + input.getBookingId());
            boolean processed = webHelper.putBooking(input);
            if (processed) {
                RDBooking rdBooking = webHelper.addMealStatus(new RDTaskInputImpl(input.getBookingId(), RDMealStatus.CLOSED.getStatus()));
                if (rdBooking != null) {
                    context.addBookingData(rdBooking);
                    return true;
                }
                return false;
            }
            return false;
        }
    }
    ,
    TRANSFER_BOOKING{

        @Override
        public boolean processTask(RDContext context, RDTaskInput input, RDTaskMaster taskMaster) {
            if (!(input instanceof RDTransferTaskInput)) {
                throw new IllegalArgumentException("RDTaskType - Not valid Task Input, It should be RDTransferTaskInput!");
            }
            RDTransferTaskInput transferTaskInput = (RDTransferTaskInput)input;
            if (!(transferTaskInput.getData() instanceof TableAccount) || !(transferTaskInput.getSourceData() instanceof Account)) {
                throw new IllegalArgumentException("RDTaskType - Not valid Task Input Data Types, It should be Account!");
            }
            Account source = (Account)((RDTransferTaskInput)input).getSourceData();
            TableAccount target = (TableAccount)input.getData();
            RDBooking targetBooking = null;
            targetBooking = source instanceof TableAccount ? RDConverter.INSTANCE.getRDBookingForTransfer(context, source, target) : RDConverter.INSTANCE.getRDBookingFromAccount(context, target);
            return RDTaskType.createBooking(context, new RDTaskInputImpl(null, target), targetBooking);
        }
    };

    private static RDWebHelper webHelper;

    public abstract boolean processTask(RDContext var1, RDTaskInput var2, RDTaskMaster var3);

    public void setHelper(RDWebHelper helper) {
        webHelper = helper;
    }

    private static boolean createBooking(RDContext context, RDTaskInput accountInput, RDBooking booking) {
        RDBooking newBooking = webHelper.postBooking(new RDTaskInputImpl(null, booking));
        if (newBooking != null) {
            RDReservationMaker.getInstance().makeReservation(newBooking, (Account)accountInput.getData());
            context.addBookingData(newBooking);
            return true;
        }
        return false;
    }

    static {
        webHelper = RDWebHelper.getInstance();
    }
}

