/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.restaurantdiary.webservice;

import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.net.ssl.SSLContext;
import net.oauth.OAuthConsumer;
import net.oauth.client.OAuthClient;
import net.oauth.client.httpclient4.HttpClient4;
import net.oauth.client.httpclient4.HttpClientPool;
import net.oauth.http.HttpClient;
import ordermate.OrderMate;
import ordermate.integration.restaurantdiary.webservice.RDOAuthClient;
import ordermate.integration.webservice.OAuthHelper;
import ordermate.integration.webservice.OAuthMapBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.impl.client.HttpClients;

public class RDOAuthHelper
extends OAuthHelper {
    public static final String SECOND_SECRET_MAP = "secondSecret";
    public static final String SECOND_SECRET = "second_secret";
    public static final String SCOPE = "scope";
    private static final HttpClientPool RD_HTTP_CLIENT_POOL = new RDHttpClientPool();

    public RDOAuthHelper(OAuthMapBuilder builder) {
        super(builder);
        if (!this.getRawMap().containsKey(SECOND_SECRET_MAP) || !this.getRawMap().containsKey(SCOPE)) {
            OrderMate.LOG.debug("RestaurantDiaryOAuthHelper's OAuthMapBuilder did not contain all paramerters!");
        }
    }

    @Override
    protected void addAdditionalParametersToConsumer(OAuthConsumer consumer, Map<String, String> props) {
        String secondSecret = props.get(SECOND_SECRET_MAP);
        String scope = props.get(SCOPE);
        consumer.setProperty(SCOPE, (Object)scope);
        consumer.setProperty(SECOND_SECRET, (Object)secondSecret);
    }

    @Override
    protected void addAdditionalParametersToRequestParams(Map<String, String> requestMap, Map<String, String> props) {
        requestMap.put(SCOPE, props.get(SCOPE));
        requestMap.put(SECOND_SECRET, props.get(SECOND_SECRET_MAP));
    }

    @Override
    protected HttpClient getHttpClient() {
        return new HttpClient4(RD_HTTP_CLIENT_POOL);
    }

    @Override
    protected OAuthClient getOAuthClient(HttpClient httpClient) {
        return new RDOAuthClient(httpClient);
    }

    private static class RDHttpClientPool
    implements HttpClientPool {
        private final String[] SUPPORTED_PROTOCOLS = new String[]{"TLSv1.1", "TLSv1.2"};

        private RDHttpClientPool() {
        }

        public org.apache.http.client.HttpClient getHttpClient(URL server) {
            return this.getRDHttpClient();
        }

        private org.apache.http.client.HttpClient getRDHttpClient() {
            SSLContext sslContext = null;
            try {
                sslContext = SSLContexts.custom().useTLS().build();
            }
            catch (NoSuchAlgorithmException e) {
                OrderMate.LOG.error("Unable to create ResDiary SSL context in http client due to the non-existent algorithm", (Throwable)e);
            }
            catch (KeyManagementException e) {
                OrderMate.LOG.error("Unable to create ResDiary SSL context in http client", (Throwable)e);
            }
            SSLConnectionSocketFactory f = new SSLConnectionSocketFactory(sslContext, this.SUPPORTED_PROTOCOLS, null, SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)f).build();
        }
    }
}

