/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.restaurantdiary.webservice;

import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.web.HttpMethod;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.oauth.client.OAuthResponseMessage;
import ordermate.OrderMate;
import ordermate.database.integration.RDConfiguration;
import ordermate.integration.eftpos.tyro.webservice.RestErrorCode;
import ordermate.integration.jaxb.restaurantdiary.RDBooking;
import ordermate.integration.jaxb.restaurantdiary.RDCustomer;
import ordermate.integration.jaxb.restaurantdiary.RDDiaryBooking;
import ordermate.integration.jaxb.restaurantdiary.RDRestaurant;
import ordermate.integration.restaurantdiary.RDMarshaller;
import ordermate.integration.restaurantdiary.tasks.RDTaskInput;
import ordermate.integration.restaurantdiary.webservice.RDOAuthHelper;
import ordermate.integration.webservice.OAuthMapBuilder;

public class RDWebHelper {
    private final String scopeURL;
    private final String webserviceURL;
    private final String consumerKey;
    private final String consumerSecret;
    private final String secondSecret;
    private final String oAuthEndpoint;
    private final Integer restaurantId;
    private RDOAuthHelper oauthHelper;
    private OAuthMapBuilder builder;
    private final RDMarshaller marshaller = new RDMarshaller();
    private final String bookingUrl;
    private static volatile RDWebHelper instance = null;

    private RDWebHelper() {
        this(RDConfiguration.getInstance().getWebserviceUrl(), RDConfiguration.getInstance().getScopeUrl(), RDConfiguration.getInstance().getKey(), RDConfiguration.getInstance().getSecret(), RDConfiguration.getInstance().getSecondSecret(), RDConfiguration.getInstance().getOauthEndpoint(), RDConfiguration.getInstance().getRestaurantId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RDWebHelper getInstance() {
        if (instance != null) return instance;
        Class<RDWebHelper> clazz = RDWebHelper.class;
        synchronized (RDWebHelper.class) {
            if (instance != null) return instance;
            instance = new RDWebHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public RDWebHelper(String webURL, String scope, String key, String secret, String secret2, String oauthURL, Integer restID) {
        this.webserviceURL = webURL;
        this.scopeURL = scope;
        this.consumerKey = key;
        this.consumerSecret = secret;
        this.secondSecret = secret2;
        this.oAuthEndpoint = oauthURL;
        this.restaurantId = restID;
        this.bookingUrl = this.webserviceURL + "/Restaurant/" + this.restaurantId + "/Booking/";
        this.builder = new OAuthMapBuilder();
        this.builder.addKey(this.consumerKey).addSecret(this.consumerSecret).addRequestURL(this.oAuthEndpoint).addAccessURL(this.oAuthEndpoint).addParameter("scope", this.scopeURL).addParameter("secondSecret", this.secondSecret);
        this.oauthHelper = new RDOAuthHelper(this.builder);
    }

    protected void setOAuthHelper(RDOAuthHelper oauthHelper) {
        this.oauthHelper = oauthHelper;
    }

    public List<RDDiaryBooking> getDiaryData(RDTaskInput taskInput) {
        if (taskInput == null || !(taskInput.getData() instanceof Date)) {
            throw new IllegalArgumentException("Task input data should be Date object");
        }
        String urlAddress = this.getDiaryURL((Date)taskInput.getData());
        if (urlAddress == null) {
            return null;
        }
        OAuthResponseMessage resource = this.sendRequest(HttpMethod.GET, urlAddress, null, null);
        if (resource == null) {
            return null;
        }
        return this.getListDataFromResource(urlAddress, resource, RDDiaryBooking.class);
    }

    private String getDiaryURL(Date date) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("date", DateTimeUtils.getSQLDateFormat().format(date));
        StringBuilder strBuilder = new StringBuilder(this.webserviceURL).append("/Restaurant/").append(this.restaurantId).append("/DiaryData").append(this.addParameters(params));
        return strBuilder != null ? strBuilder.toString() : null;
    }

    public RDBooking getBooking(Long bookingNumber) {
        String urlAddress = this.getBookingURL(bookingNumber, HttpMethod.GET);
        OAuthResponseMessage resource = this.sendRequest(HttpMethod.GET, urlAddress, null, null);
        if (resource == null) {
            return null;
        }
        return this.getDataFromResource(urlAddress, resource, RDBooking.class);
    }

    private <T> T getDataFromResource(String urlAddress, OAuthResponseMessage resource, Class<T> clazz) {
        try {
            if (this.isSuccessfulResponse(urlAddress, resource.getHttpResponse().getStatusCode())) {
                return this.marshaller.unmarshal(resource.readBodyAsString(), clazz);
            }
            return null;
        }
        catch (IOException e) {
            OrderMate.LOG.error("Unable to obtain data from ResDiary for class: " + clazz, (Throwable)e);
            return null;
        }
    }

    private <T> List<T> getListDataFromResource(String urlAddress, OAuthResponseMessage resource, Class<T> clazz) {
        try {
            if (this.isSuccessfulResponse(urlAddress, resource.getHttpResponse().getStatusCode())) {
                return this.marshaller.unmarshalList(resource.readBodyAsString(), clazz);
            }
            return null;
        }
        catch (IOException e) {
            OrderMate.LOG.error("Unable to obtain list data from ResDiary for class: " + clazz, (Throwable)e);
            return null;
        }
    }

    private String getBookingURL(Long bookingID, HttpMethod type) {
        switch (type) {
            case GET: {
                return this.bookingUrl + bookingID;
            }
            case PUT: {
                return this.bookingUrl + bookingID + "?overrideCovers=true";
            }
            case POST: {
                return this.bookingUrl.substring(0, this.bookingUrl.length() - 1) + "?overrideCovers=true";
            }
        }
        return null;
    }

    private String addParameters(Map<String, String> params) {
        StringBuilder sb = new StringBuilder("?");
        for (String key : params.keySet()) {
            try {
                sb.append((Object)key).append("=").append(URLEncoder.encode(params.get(key), "UTF-8")).append("&");
            }
            catch (UnsupportedEncodingException e) {
                OrderMate.LOG.error("Unable to add parameter: " + params.get(key), (Throwable)e);
                return null;
            }
        }
        sb.deleteCharAt(sb.lastIndexOf("&"));
        return sb.toString();
    }

    public RDRestaurant getRestaurant() {
        String urlAddress = this.getRestaurantURL();
        OAuthResponseMessage resource = this.sendRequest(HttpMethod.GET, urlAddress, null, null);
        if (resource == null) {
            return null;
        }
        return this.getDataFromResource(urlAddress, resource, RDRestaurant.class);
    }

    private String getRestaurantURL() {
        StringBuilder strBuilder = new StringBuilder(this.webserviceURL).append("/Restaurant/").append(this.restaurantId);
        return strBuilder.toString();
    }

    public RDCustomer getCustomer(Long customerID) {
        String urlAddress = this.getCustomerURL(customerID);
        OAuthResponseMessage resource = this.sendRequest(HttpMethod.GET, urlAddress, null, null);
        if (resource == null) {
            return null;
        }
        return this.getDataFromResource(urlAddress, resource, RDCustomer.class);
    }

    private String getCustomerURL(Long customerID) {
        StringBuilder strBuilder = new StringBuilder(this.webserviceURL).append("/Customer/").append(customerID);
        return strBuilder.toString();
    }

    public boolean addReceipt(RDTaskInput input) {
        if (input == null || input.getBookingId() == null) {
            throw new IllegalArgumentException("ResDiary - SendReceipt task input is not valid!");
        }
        String urlAddress = this.getReceiptURL(input.getBookingId());
        OAuthResponseMessage resource = this.sendRequest(HttpMethod.POST, urlAddress, input.getData(), "application/xml");
        if (resource == null) {
            return false;
        }
        try {
            resource.readBodyAsString();
            return this.isSuccessfulResponse(urlAddress, resource.getHttpResponse().getStatusCode());
        }
        catch (IOException e) {
            OrderMate.LOG.error("Error while checking result in Add Receipt for url: " + urlAddress, (Throwable)e);
            return false;
        }
    }

    private String getReceiptURL(Long bookingId) {
        StringBuilder strBuilder = new StringBuilder(this.webserviceURL).append("/Restaurant/").append(this.restaurantId).append("/Booking/").append(bookingId).append("/Receipt");
        return strBuilder.toString();
    }

    public RDBooking addMealStatus(RDTaskInput input) {
        if (input == null || input.getBookingId() == null) {
            throw new IllegalArgumentException("ResDiary - SendMealStatus Task input is not valid!");
        }
        String url = this.getMealStatusURL(input.getBookingId());
        OAuthResponseMessage resource = this.sendRequest(HttpMethod.PUT, url, input.getData(), null);
        if (resource == null) {
            return null;
        }
        return this.getDataFromResource(url, resource, RDBooking.class);
    }

    private String getMealStatusURL(Long bookingId) {
        StringBuilder strBuilder = new StringBuilder(this.bookingUrl).append(bookingId).append("/MealStatus");
        return strBuilder.toString();
    }

    public boolean putBooking(RDTaskInput input) {
        if (input == null || !(input.getData() instanceof RDBooking)) {
            throw new IllegalArgumentException("ResDiary - PUT Booking Task input data should be RDBooking object!");
        }
        OrderMate.LOG.info("ResDiary updating booking" + input.getBookingId());
        String jsonData = this.marshaller.marshal(input.getData());
        String url = this.getBookingURL(input.getBookingId(), HttpMethod.PUT);
        OAuthResponseMessage resource = this.sendRequest(HttpMethod.PUT, url, jsonData, null);
        if (resource == null) {
            return false;
        }
        return this.getDataFromResource(url, resource, RDBooking.class) != null;
    }

    public RDBooking postBooking(RDTaskInput input) {
        if (input == null || !(input.getData() instanceof RDBooking)) {
            throw new IllegalArgumentException("ResDiary - POST Booking Task input data should be RDBooking object!");
        }
        RDMarshaller postMarshaller = new RDMarshaller();
        postMarshaller.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        String jsonData = postMarshaller.marshal(input.getData());
        String url = this.getBookingURL(null, HttpMethod.POST);
        OAuthResponseMessage resource = this.sendRequest(HttpMethod.POST, url, jsonData, "application/json");
        if (resource == null) {
            return null;
        }
        return this.getDataFromResource(url, resource, RDBooking.class);
    }

    public boolean addArrivalStatus(RDTaskInput input) {
        if (input == null || input.getBookingId() == null) {
            throw new IllegalArgumentException("ResDiary - SendArrivalStatus Task input is not valid!");
        }
        String url = this.getArrivalStatusURL(input.getBookingId());
        OAuthResponseMessage resource = this.sendRequest(HttpMethod.PUT, url, input.getData(), null);
        if (resource == null) {
            return false;
        }
        return this.getDataFromResource(url, resource, RDBooking.class) != null;
    }

    private String getArrivalStatusURL(Long bookingId) {
        StringBuilder strBuilder = new StringBuilder(this.bookingUrl).append(bookingId).append("/ArrivalStatus");
        return strBuilder.toString();
    }

    private OAuthResponseMessage sendRequest(HttpMethod type, String url, Object data, String mediaType) {
        OAuthResponseMessage resource = null;
        try {
            this.checkOAuthToken();
            OrderMate.LOG.info("Performing " + (Object)((Object)type) + " request " + url);
            switch (type) {
                case GET: {
                    resource = (OAuthResponseMessage)this.oauthHelper.getResource(url);
                    break;
                }
                case PUT: {
                    resource = (OAuthResponseMessage)this.oauthHelper.putResource(url, data);
                    break;
                }
                case POST: {
                    resource = (OAuthResponseMessage)this.oauthHelper.postResource(url, data, mediaType);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("OAuthMessageType is not valid! " + (Object)((Object)type));
                }
            }
        }
        catch (Exception e) {
            OrderMate.LOG.error("ResDiary - ERROR occured when calling the Webservice :" + url, (Throwable)e);
        }
        OrderMate.LOG.debug("Returning " + (Object)((Object)type) + " result " + resource);
        return resource;
    }

    private void checkOAuthToken() throws Exception {
        if (!this.oauthHelper.hasAccessToken()) {
            this.oauthHelper.request();
            this.oauthHelper.access();
        }
    }

    private boolean isSuccessfulResponse(String urlAddress, int code) {
        boolean result = false;
        if (RestErrorCode.R404.getCode() == code) {
            OrderMate.LOG.error(urlAddress + " not found!");
        } else if (RestErrorCode.R403.getCode() == code) {
            OrderMate.LOG.error("Request Denied By WebService! Have you set up a key/secret?");
        } else if (RestErrorCode.R400.getCode() == code) {
            OrderMate.LOG.error("WebService could not handle request. Input Data does not match!");
        } else if (RestErrorCode.R200.getCode() == code) {
            result = true;
        } else {
            OrderMate.LOG.error("Unexpected Restaurantdiary Error Code! code=" + code);
        }
        return result;
    }
}

