/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.salesexport;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.integration.exportsales.ExportSalesIntegration;
import ordermate.database.integration.exportsales.SalesExportItem;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.misc.TradingDayQueries;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.integration.jaxb.deputy.SalesData;
import ordermate.integration.webservice.RestHelper;
import ordermate.jaxb.exporter.XMLHelper;

public abstract class AbstractSalesExporter {
    protected static final Integer TIMEOUT = 5000;
    protected String preamble = "https://";
    protected final ExportSalesIntegration integration;
    protected RestHelper rest = new RestHelper();
    protected boolean isNeedLocation = true;

    public AbstractSalesExporter(ExportSalesIntegration yourIntegration) {
        this.integration = yourIntegration;
    }

    public boolean performExport(boolean updateOnSuccess, Date from, Date to) {
        Date fromDate = from;
        Date toDate = to;
        if (fromDate == null) {
            fromDate = this.integration.getLastSalesExport();
        }
        if (fromDate == null) {
            fromDate = TradingDay.getCurrentTradingDay().getDate();
        }
        if (toDate == null) {
            Calendar cal = Calendar.getInstance();
            cal.set(14, 0);
            toDate = cal.getTime();
        }
        if (!this.checkExportItemsExist() && this.isNeedLocation) {
            OrderMate.LOG.info("No Active Filters In  Export List");
            return false;
        }
        List<SalesItemQuantity> salesQtys = this.getModifiedSalesItemQuantities(fromDate, toDate);
        List<SalesData> data = this.getSalesData(salesQtys);
        boolean exported = this.exportData(data);
        if (exported && updateOnSuccess) {
            this.integration.setLastSalesExport(toDate);
            this.integration.save();
        }
        return exported;
    }

    public abstract boolean canExport();

    protected List<SalesItemQuantity> getModifiedSalesItemQuantities(Date fromDate, Date toDate) {
        TradingDay previous;
        TradingDay day = TradingDayQueries.getTradingDayOnOrBefore(fromDate);
        if (day != null && (previous = day.getPreviousTradingDay()) != null) {
            day = previous;
        }
        ObjectQuery query = Query.select(SalesItemQuantity.class).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM, SalesItem.Properties.ID).greaterThanOrEqual(SalesItemQuantity.Properties.TRADING_DAY, day).whereFunction("creation_time BETWEEN ? AND ? ").whereFunction("modification_time BETWEEN ? AND ? ").whereFunction("sales_item.type = 'SalesItem' ").orderBy(SalesItemQuantity.Properties.ID);
        return PersistenceManager.getObjectList(SalesItemQuantity.class, query.toString(), new Object[]{fromDate, toDate, fromDate, toDate});
    }

    public SalesData convertToSalesData(SalesItemQuantity qty) {
        SalesData data = new SalesData();
        data.setId(qty.getID().toString());
        data.setCreated(XMLHelper.getDateType(qty.getCreationTime()));
        data.setModified(XMLHelper.getDateType(qty.getCreationTime()));
        data.setTimestamp(XMLHelper.getDateType(qty.getCreationTime()));
        data.setCreator(BigInteger.ZERO);
        data.setEmployee(BigInteger.ZERO);
        data.setOperationalUnit(BigInteger.valueOf(this.integration.getOperationalUnit()));
        data.setLocation(BigInteger.valueOf(this.integration.getLocation()));
        if (this.integration.isIncludeTax()) {
            data.setSalesAmount(qty.getSalesLineItem().getPricePerItem().multiply(qty.getQuantity()).floatValue());
        } else {
            SalesLineItem item = qty.getSalesLineItem();
            data.setSalesAmount(item.getPricePerItem().subtract(item.getUnitTax()).multiply(qty.getQuantity()).floatValue());
        }
        data.setSalesPayload(null);
        data.setSalesQty(qty.getQuantity().getValue().floatValue());
        data.setSalesRef(qty.getID().toString());
        return data;
    }

    public abstract boolean exportData(List<SalesData> var1);

    public ExportSalesIntegration getIntegration() {
        return this.integration;
    }

    void setPreamble(String string) {
        this.preamble = string;
    }

    public List<SalesData> getSalesData(List<SalesItemQuantity> salesQtys) {
        ArrayList<SalesData> data = new ArrayList<SalesData>();
        List<SalesExportItem> exportItems = PersistenceManager.getObjectList(SalesExportItem.class, Query.select(SalesExportItem.class).active(SalesExportItem.class).toString());
        for (SalesExportItem depSale : exportItems) {
            for (SalesItemQuantity item : salesQtys) {
                SalesData datum;
                if (!depSale.terminalIsInList(item.getTerminal(), true) || !depSale.categoryIsInList(item.getSalesLineItem().getLowestSequenceInventoryCategory(), true) || !depSale.salesLocationIsInList(item.getSalesLocation(), true) || (datum = this.convertToSalesData(item)) == null) continue;
                datum.setOperationalUnit(BigInteger.valueOf(depSale.getExternalLocationID()));
                data.add(datum);
            }
        }
        Map<Long, SalesData> timestampSalesData = this.convertToMap(data);
        return new ArrayList<SalesData>(timestampSalesData.values());
    }

    public boolean checkExportItemsExist() {
        List<SalesExportItem> exportItems = PersistenceManager.getObjectList(SalesExportItem.class, Query.select(SalesExportItem.class).active(SalesExportItem.class).toString());
        if (exportItems.isEmpty()) {
            try {
                SalesExportItem newObject = new SalesExportItem();
                newObject.setCategories("");
                newObject.setTerminals("");
                newObject.setExternalLocationID(Long.valueOf(this.integration.getOperationalUnit()));
                newObject.save();
                exportItems = PersistenceManager.getObjectList(SalesExportItem.class, Query.select(SalesExportItem.class).active(SalesExportItem.class).toString());
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Error creating export filter", (Throwable)ex);
                return false;
            }
        }
        return !exportItems.isEmpty();
    }

    protected Map<Long, SalesData> convertToMap(List<SalesData> data) {
        LinkedHashMap<Long, SalesData> salesValues = new LinkedHashMap<Long, SalesData>();
        for (SalesData line : data) {
            Long key = line.getTimestamp().toGregorianCalendar().getTimeInMillis() / 1000L;
            if (!salesValues.containsKey(key)) {
                salesValues.put(key, line);
                continue;
            }
            SalesData current = (SalesData)salesValues.get(key);
            current.setSalesAmount(current.getSalesAmount() + line.getSalesAmount());
        }
        return salesValues;
    }
}

