/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.salesexport;

import au.com.ordermate.util.StringUtils;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.integration.exportsales.ExportSalesIntegration;
import ordermate.integration.jaxb.deputy.DeputySales;
import ordermate.integration.jaxb.deputy.DeputySalesData;
import ordermate.integration.jaxb.deputy.SalesData;
import ordermate.integration.salesexport.AbstractSalesExporter;
import ordermate.integration.webservice.PassthroughX509TrustManager;

public class DeputyExporter
extends AbstractSalesExporter {
    private static final Integer TIMEOUT = 5000;
    private String deputyContext = ".deputy.com/api/v1/";
    private String salesData = "resource/SalesData";
    private String v2SalesURL = ".deputy.com/api/v2/metrics";
    private String SALES = "Sales";

    public DeputyExporter(ExportSalesIntegration yourIntegration) {
        super(yourIntegration);
    }

    @Override
    public boolean canExport() {
        if (!this.integration.isEnabled()) {
            OrderMate.LOG.info("Cannot export if Deputy is not enabled");
            return false;
        }
        if (StringUtils.isEmpty(this.integration.getSubdomain())) {
            OrderMate.LOG.info("Deputy subdomain cannot be null or empty");
            return false;
        }
        if (StringUtils.isEmpty(this.integration.getToken())) {
            OrderMate.LOG.info("No token for Deputy, cannot export.");
            return false;
        }
        return true;
    }

    public void getInfo() {
        String uri = "https://" + this.integration.getSubdomain() + this.deputyContext + "resource/SalesData/INFO";
        WebResource resource = this.rest.getResource(uri, TIMEOUT, TIMEOUT);
        try {
            WebResource.Builder builder = (WebResource.Builder)((WebResource.Builder)((WebResource.Builder)resource.header("Authorization", (Object)("OAuth " + this.integration.getToken())).header("dp-meta-option", (Object)"none")).type("application/json")).accept(new String[]{"application/json"});
            ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
            StringBuilder SB = new StringBuilder(response.getStatus());
            SB.append("\r\nLength:" + response.getLength());
            SB.append("\r\nPayload:" + (String)response.getEntity(String.class));
            OrderMate.LOG.info((CharSequence)SB);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot export sales data to Deputy", (Throwable)ex);
        }
    }

    @Override
    public boolean exportData(List<SalesData> dataList) {
        if (dataList.isEmpty()) {
            return true;
        }
        boolean fine = true;
        String uri = this.preamble + this.integration.getSubdomain() + this.v2SalesURL;
        WebResource resource = this.rest.getSSLWebResource(uri, new PassthroughX509TrustManager(), TIMEOUT, TIMEOUT, "TLSv1.2");
        try {
            ArrayList<DeputySalesData> deputySalesDatas = new ArrayList<DeputySalesData>();
            for (SalesData nextSalesData : dataList) {
                deputySalesDatas.add(this.convertSalesData(nextSalesData));
            }
            DeputySales deputySales = new DeputySales();
            deputySales.setData(deputySalesDatas);
            WebResource.Builder builder = (WebResource.Builder)((WebResource.Builder)((WebResource.Builder)resource.header("Authorization", (Object)("Bearer " + this.integration.getToken())).header("content-type", (Object)"application/json")).type("application/json")).accept(new String[]{"application/json"});
            ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)deputySales);
            boolean bl = fine = response.getStatus() / 100 == 2;
            if (!fine) {
                OrderMate.LOG.warn("Export of Sales Data to Deputy failed: " + response.getStatus() + " " + (String)response.getEntity(String.class));
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot export sales data to Deputy", (Throwable)ex);
            fine = false;
        }
        return fine;
    }

    private DeputySalesData convertSalesData(SalesData salesData1) {
        if (salesData1 == null) {
            return null;
        }
        DeputySalesData newSalesData = new DeputySalesData();
        newSalesData.setArea(salesData1.getOperationalUnit());
        newSalesData.setEmployee(salesData1.getEmployee());
        newSalesData.setLocation(salesData1.getLocation());
        newSalesData.setReference(salesData1.getSalesRef());
        newSalesData.setTimestamp(salesData1.getTimestamp().toGregorianCalendar().getTimeInMillis() / 1000L);
        newSalesData.setType(this.SALES);
        newSalesData.setValue(salesData1.getSalesAmount());
        return newSalesData;
    }
}

