/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.salesexport;

import au.com.diamondback.xmlintegration.sales.DiamondSale;
import au.com.ordermate.util.Pair;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import ordermate.OrderMate;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.integration.cloudback.CloudServerType;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.sales.Account;
import ordermate.database.sales.reservation.Reservation;
import ordermate.integration.cloudback.CloudBackClient;
import ordermate.integration.salesexport.DiamondSaleTranslator;

public class DiamondBackSalesClient
extends CloudBackClient {
    private static final String SALES = "sales/v1/general/";
    private static final String UPDATE = "/update";
    private final DiamondSaleTranslator translator = new DiamondSaleTranslator();

    public DiamondBackSalesClient() {
        this(CloudBackConfig.getCloudBackConfig(CloudServerType.DiamondBack));
    }

    protected DiamondBackSalesClient(CloudBackConfig config) {
        super(config);
    }

    @Override
    protected String getSSLProtocol() {
        return "TLSv1.2";
    }

    public boolean saleUpdated(Account updated) {
        DiamondSale dSale = this.translator.translateAccount(updated);
        return this.postSale(dSale);
    }

    public boolean reservationTransferred(Account account, Reservation reservation) {
        DiamondSale dSale = this.translator.translateAccount(account);
        dSale.setBookingId(reservation.getExternalId());
        return this.postSale(dSale);
    }

    private boolean postSale(DiamondSale dSale) {
        WebResource.Builder builder = super.setupResource(SystemCurrentInfo.getInstance().getRedbackId() + UPDATE, new Pair[0]);
        ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)builder.accept(new String[]{"application/xml"})).type("application/xml")).post(ClientResponse.class, (Object)dSale);
        OrderMate.LOG.info("Updating DiamondBack with sale: " + dSale.getSalesId() + " as " + dSale.getStatus());
        String entity = (String)response.getEntity(String.class);
        if (response.getStatus() / 100 == 2) {
            OrderMate.LOG.info("Upload to Diamondback successful:" + entity);
            return true;
        }
        OrderMate.LOG.error("Cannot upload sales information to Diamondback at :" + entity);
        return false;
    }

    @Override
    protected String getBaseURL() {
        String url = super.getBaseURL();
        return url + SALES;
    }
}

