/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.salesexport;

import au.com.diamondback.xmlintegration.sales.DiamondAddress;
import au.com.diamondback.xmlintegration.sales.DiamondFinanceTransaction;
import au.com.diamondback.xmlintegration.sales.DiamondModType;
import au.com.diamondback.xmlintegration.sales.DiamondPriceAdjustment;
import au.com.diamondback.xmlintegration.sales.DiamondSale;
import au.com.diamondback.xmlintegration.sales.DiamondSalesCombo;
import au.com.diamondback.xmlintegration.sales.DiamondSalesComponent;
import au.com.diamondback.xmlintegration.sales.DiamondSalesComponentTax;
import au.com.diamondback.xmlintegration.sales.DiamondSalesCustomer;
import au.com.diamondback.xmlintegration.sales.DiamondSalesDebtor;
import au.com.diamondback.xmlintegration.sales.DiamondSalesItem;
import au.com.diamondback.xmlintegration.sales.DiamondSalesLine;
import au.com.diamondback.xmlintegration.sales.DiamondSalesModifier;
import au.com.diamondback.xmlintegration.sales.DiamondSalesQuantity;
import au.com.diamondback.xmlintegration.sales.DiamondSalesTable;
import au.com.diamondback.xmlintegration.sales.DiamondSalesTerminal;
import au.com.diamondback.xmlintegration.sales.DiamondVoucherTransaction;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.sales.PercentagePriceAdjustment;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.inventory.InventoryAdd;
import ordermate.database.inventory.InventoryAddGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.InventoryRemove;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.OnlineIntegrationIDStrategy;
import ordermate.database.sales.AbstractSalesRemove;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.SalesAdd;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesComponentTax;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesMod;
import ordermate.database.sales.SalesOption;
import ordermate.database.sales.SalesPriceAdjustmentUsage;
import ordermate.database.sales.SalesRemove;
import ordermate.database.sales.SalesRemoveStocked;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.sales.reservation.ReservationsHelper;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockItem;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.PhysicalTable;
import ordermate.jaxb.exporter.XMLHelper;

public class DiamondSaleTranslator {
    private DecimalFormat format = new DecimalFormat("0.00###");
    private boolean primary = true;
    private boolean masterIdStratagy = OnlineIntegrationIDStrategy.MASTER_ID == SystemProperty.getInstance().getOnlineIntegrationIdStrategy();

    public DiamondSale translateAccount(Account account) {
        List<Reservation> reservations;
        Iterator<PersistentObject> table;
        List<SalesLineItem> lineItems;
        DiamondSale dSale = new DiamondSale();
        dSale.setModCount(Integer.valueOf(account.getModCount().intValue()));
        dSale.setStoreId(String.valueOf(SystemCurrentInfo.getInstance().getRedbackId()));
        dSale.setOpenedDatetime(XMLHelper.getDateType(account.getCreationDateTime()));
        dSale.setOpenedUserId(String.valueOf(account.getOpeningUser().getID()));
        dSale.setOpenedUser(account.getOpeningUser().getName());
        dSale.setNote(account.getComment());
        dSale.setReceiptPrinted(Boolean.valueOf(Account.ReceiptPrintState.RECEIPT_PRINTED.equals(account.getReceiptState())));
        if (account.getClosedDateTime() != null) {
            dSale.setClosedDatetime(XMLHelper.getDateType(account.getClosedDateTime()));
        }
        if (account.getClosingUser() != null) {
            dSale.setClosedUserId(String.valueOf(account.getClosingUser().getID()));
            dSale.setClosedUserId(account.getClosingUser().getName());
        }
        if (account.getTimeDue() != null) {
            Date dateDue = account.getDateDue();
            if (dateDue == null) {
                dateDue = new Date();
            }
            dSale.setDueDatetime(XMLHelper.getDateType(DateTimeUtils.combineDateAndTime(dateDue, account.getTimeDue())));
        }
        if (account.getEta() != null) {
            dSale.setEtaDatetime(XMLHelper.getDateType(account.getEta()));
        }
        dSale.setExternalSource(account.getSource());
        if (account.getExtOrderID() != null) {
            dSale.setExternalId(account.getExtOrderID());
        }
        if (account instanceof TableAccount && account.getSource() != null) {
            dSale.setCheckinUri(account.getExtHRef());
        }
        if (account.getCustomer() != null) {
            Customer cust = account.getCustomer();
            DiamondSalesCustomer dCust = new DiamondSalesCustomer();
            dSale.setCustomer(dCust);
            dCust.setFirstName(cust.getFirstName());
            dCust.setLastName(cust.getLastName());
            dCust.setTitle(cust.getTitle());
            dCust.setPhone(cust.getPhoneNumber());
            dCust.setEmail(cust.getEmail());
            dCust.setCardNo(cust.getCardID());
            dCust.setExtId(cust.getExtWebId() == null ? null : String.valueOf(cust.getExtWebId()));
            dCust.setId(String.valueOf(cust.getID()));
            if (!StringUtils.isEmpty(cust.getStreetName())) {
                DiamondAddress diamondAddress = new DiamondAddress();
                diamondAddress.setAptNum(cust.getRoomAptNumber());
                diamondAddress.setHouseNum(cust.getHouseNumber());
                diamondAddress.setStreetName(cust.getStreetName());
                diamondAddress.setStreetType(cust.getStreetType());
                diamondAddress.setSuburb(cust.getSuburb());
                diamondAddress.setState(cust.getState());
                diamondAddress.setPostCode(cust.getPostcode());
                dCust.setAddress(diamondAddress);
            }
        }
        if ((lineItems = account.getAllItems()) != null && !lineItems.isEmpty()) {
            SalesLocation loc;
            SalesLineItem first = lineItems.get(0);
            SalesItemQuantity salesItemQuantity = first.getSalesItemQuantities().get(0);
            dSale.setSalesLocationId(String.valueOf(salesItemQuantity.getLocation().getID()));
            Terminal terminal = first.getOriginalTerminal();
            if (terminal != null) {
                DiamondSalesTerminal dbTerminal = new DiamondSalesTerminal();
                dbTerminal.setTerminalId(terminal.getID().toString());
                dbTerminal.setTerminalLabel(terminal.getLabel());
                dSale.setTerminal(dbTerminal);
            }
            if ((loc = salesItemQuantity.getSalesLocation()) != null) {
                dSale.setSalesLocationId(loc.getID().toString());
                dSale.setSalesLocationLabel(loc.getLabel());
            }
            for (SalesLineItem item : lineItems) {
                dSale.getSalesLines().add(this.doLineItem(dSale, item));
            }
        }
        dSale.setPaid(account.getPaid().toBigDecimal());
        dSale.setSalesId(String.valueOf(account.getID()));
        dSale.setStatus(account.getAccountState().toString());
        if (account.getNumPatrons() > 0) {
            dSale.setPax(BigInteger.valueOf(account.getNumPatrons()));
        }
        if (account instanceof TableAccount && (table = ((TableAccount)account).getTable()) != null) {
            for (PhysicalTable phTable : ((LogicalTable)((Object)table)).getPhysicalTables()) {
                DiamondSalesTable dTable = new DiamondSalesTable();
                dTable.setSectionId(String.valueOf(((LogicalTable)((Object)table)).getTableGroup().getID()));
                dTable.setSectionName(String.valueOf(((LogicalTable)((Object)table)).getTableGroup().getName()));
                dTable.setTableId(String.valueOf(phTable.getID()));
                dTable.setTableName(phTable.getName());
                dSale.getTables().add(dTable);
            }
            dSale.setSeats(BigInteger.valueOf(((TableAccount)account).getSeats()));
        }
        for (SalesPriceAdjustment salesPriceAdjustment : account.getPriceAdjustments()) {
            if (PriceAdjustmentLevel.ITEM_LEVEL.equals(salesPriceAdjustment.getLevel())) continue;
            DiamondPriceAdjustment dAdj = new DiamondPriceAdjustment();
            dAdj.setAdjId(salesPriceAdjustment.getID().toString());
            dAdj.setDirection(salesPriceAdjustment.getDirection().toString());
            dAdj.setLabel(salesPriceAdjustment.getLabel());
            dAdj.setType(salesPriceAdjustment.getType().toString());
            dAdj.setValue(new BigDecimal(this.format.format(salesPriceAdjustment.getValue().getOriginalRawValue())));
            dAdj.setLevel(salesPriceAdjustment.getLevel().getLabel());
            dAdj.setUnit(salesPriceAdjustment.getUnit().toString());
            if (salesPriceAdjustment instanceof PercentagePriceAdjustment) {
                dAdj.setAmount(new BigDecimal(this.format.format(((PercentagePriceAdjustment)salesPriceAdjustment).getPercentageAmount())));
            } else {
                dAdj.setAmount(dAdj.getValue());
            }
            dSale.getAdjustments().add(dAdj);
        }
        dSale.setTax(account.getTax().toBigDecimal());
        dSale.setTotal(account.getTotal().toBigDecimal());
        dSale.setType(account.getType());
        for (FinanceTransaction financeTransaction : account.getAllFinanceTransactions()) {
            dSale.getTransactions().add(this.doTransaction(financeTransaction));
        }
        for (GiftVoucherTransaction giftVoucherTransaction : account.getVoucherTxns()) {
            dSale.getVoucherTransactions().add(this.doVoucherTransaction(giftVoucherTransaction));
        }
        if (account.isDebtorSale()) {
            dSale.setDebtorId(String.valueOf(account.getDebtor().getID()));
            dSale.setDebtorLabel(account.getDebtor().getLabel());
            DebtorSale sale = account.getUniqueDebtorSale();
            AbstractDebtor abstractDebtor = sale.getDebtor();
            DiamondSalesDebtor dSaleDebtor = new DiamondSalesDebtor();
            dSaleDebtor.setDebtorId(abstractDebtor.getID() == null ? "" : abstractDebtor.getID().toString());
            dSaleDebtor.setDebtorName(abstractDebtor.getLabel());
            dSaleDebtor.setDebtorGroup(abstractDebtor.getGroup() != null ? abstractDebtor.getGroup().getLabel() : null);
            dSaleDebtor.setSaleId(sale.getID() == null ? "" : sale.getID().toString());
            dSaleDebtor.setPaidAmount(sale.getAmount().toBigDecimal());
            dSaleDebtor.setSaleDatetime(XMLHelper.getDateType(sale.getSaleDate()));
            dSaleDebtor.setTerminalId(sale.getTerminal().getID().toString());
            dSale.setDebtorSale(dSaleDebtor);
        }
        if (account instanceof TableAccount && !(reservations = ReservationsHelper.getReservationsForTableAccount((TableAccount)account)).isEmpty()) {
            Reservation reservation = reservations.get(0);
            dSale.setBookingId(reservation.getExternalId());
            if (this.primary) {
                this.primary = false;
                this.applyOtherReservations(dSale, reservation);
                this.primary = true;
            }
        }
        return dSale;
    }

    private DiamondSalesLine doLineItem(DiamondSale dSale, SalesLineItem line) {
        DiamondSalesLine dLine = new DiamondSalesLine();
        if (line instanceof SalesCombo) {
            dLine.setSalesCombo(this.doCombo((SalesCombo)line));
        } else {
            dLine.setSalesItem(this.doItem((SalesItem)line));
        }
        dLine.setNote(line.getNotes());
        return dLine;
    }

    private DiamondSalesCombo doCombo(SalesCombo combo) {
        DiamondSalesCombo dCombo = new DiamondSalesCombo();
        dCombo.setLabel(combo.getLabel());
        dCombo.setSalesComboId(combo.getID().toString());
        String id = combo.getCombo().getID().toString();
        if (combo.getCombo().getMasterId() != null && this.masterIdStratagy) {
            id = combo.getCombo().getMasterId().toString();
        }
        dCombo.setInvComboId(id);
        dCombo.setType(combo.getCombo().getType().toString());
        dCombo.setExtId(combo.getExtId());
        for (SalesItemQuantity qty : combo.getSalesItemQuantities()) {
            dCombo.getQuantities().add(this.doQuantity(qty));
        }
        for (SalesItem item : combo.getSalesItems()) {
            dCombo.getItems().add(this.doItem(item));
        }
        if (combo.getComboDiscount() != null) {
            dCombo.setDiscount(combo.getComboDiscount().toBigDecimal());
        }
        return dCombo;
    }

    private DiamondSalesItem doItem(SalesItem item) {
        DiamondSalesItem dItem = new DiamondSalesItem();
        dItem.setSalesItemId(item.getID().toString());
        dItem.setExtId(item.getExtId());
        for (SalesItemQuantity qty : item.getSalesItemQuantities()) {
            dItem.getQuantities().add(this.doQuantity(qty));
        }
        for (SalesComponent comp : item.getComponentList()) {
            dItem.getComponents().add(this.doComponent(comp));
        }
        return dItem;
    }

    private DiamondSalesComponent doComponent(SalesComponent comp) {
        DiamondSalesComponent dComp = new DiamondSalesComponent();
        dComp.setSalesCompId(comp.getID().toString());
        Long unitId = comp.getUnit().getID();
        if (comp.getUnit().getMasterId() != null && OnlineIntegrationIDStrategy.MASTER_ID == SystemProperty.getInstance().getOnlineIntegrationIdStrategy()) {
            unitId = comp.getUnit().getMasterId();
        }
        dComp.setUnitId(unitId.toString());
        dComp.setUnitName(comp.getUnit().getLabel());
        if (dComp.getUnitName() != null && dComp.getUnitName().startsWith("!Unknown")) {
            int start;
            String notes = comp.getSalesItem().getNotes();
            int end = notes.indexOf(",", start = notes.indexOf("!", 6) + 1);
            if (end < 0) {
                end = notes.length() - 1;
            }
            String substring = notes.substring(start, end).trim();
            dComp.setUnitName(substring);
        }
        dComp.setSalesPriceTotal(comp.getTotalPrice().toBigDecimal());
        dComp.setSalesTaxTotal(comp.getTax().multiply(comp.getSalesItem().getQuantity()).toBigDecimal());
        dComp.setMenuPriceTotal(comp.getMenuPrice().multiply(comp.getSalesItem().getQuantity()).toBigDecimal());
        for (SalesComponentTax tax : comp.getTaxes()) {
            DiamondSalesComponentTax dTax = new DiamondSalesComponentTax();
            dTax.setPercAmount(BigDecimal.valueOf(tax.getTaxCode().getRate()));
            dTax.setSalesCompTaxId(tax.getID().toString());
            dTax.setTaxId(tax.getTaxCode().getID().toString());
            dTax.setTaxName(tax.getTaxCode().getLabel());
            dTax.setValue(tax.getValue().toBigDecimal());
            dComp.getTaxes().add(dTax);
        }
        for (SalesOption option : comp.getCurrentOptions()) {
            dComp.getModifiers().add(this.doMod(option));
        }
        for (SalesAdd add : comp.getCurrentPluses()) {
            dComp.getModifiers().add(this.doMod(add));
        }
        for (AbstractSalesRemove remove : comp.getCurrentMinuses()) {
            dComp.getModifiers().add(this.doMod(remove));
        }
        for (SalesPriceAdjustmentUsage usage : comp.getPriceAdjustmentUsages()) {
            dComp.getAdjustments().add(this.doAdjustmentUsage(usage));
        }
        return dComp;
    }

    private DiamondPriceAdjustment doAdjustmentUsage(SalesPriceAdjustmentUsage usage) {
        DiamondPriceAdjustment dAdj = new DiamondPriceAdjustment();
        SalesPriceAdjustment adj = usage.getSalesPriceAdjustment();
        dAdj.setAdjId(adj.getID().toString());
        dAdj.setDirection(adj.getDirection().toString());
        dAdj.setLabel(adj.getLabel() != null ? adj.getLabel() : adj.getValue().negate().toString());
        dAdj.setType(adj.getType().toString());
        dAdj.setValue(new BigDecimal(this.format.format(usage.getValue().getOriginalRawValue())));
        dAdj.setUnit(adj.getUnit().toString());
        if (adj instanceof PercentagePriceAdjustment) {
            dAdj.setAmount(new BigDecimal(this.format.format(((PercentagePriceAdjustment)adj).getPercentageAmount())));
        } else {
            dAdj.setAmount(dAdj.getValue());
        }
        dAdj.setLevel(usage.getSalesPriceAdjustment().getAccount() == null ? "item" : "account");
        return dAdj;
    }

    private DiamondSalesModifier doMod(SalesMod mod) {
        DiamondSalesModifier dMod = new DiamondSalesModifier();
        dMod.setModName(mod.getLabel());
        dMod.setSalesModId(mod.getID().toString());
        dMod.setPrice(mod.getPrice() == null ? BigDecimal.ZERO : mod.getPrice().toBigDecimal());
        dMod.setQuantity(BigDecimal.valueOf(mod.getModCount()));
        if (mod instanceof SalesOption) {
            dMod.setType(DiamondModType.OPTION);
            InventoryOptionGroup inventoryOptionGroup = ((SalesOption)mod).getOption().getOptionGroup();
            String groupId = inventoryOptionGroup.getID().toString();
            if (inventoryOptionGroup.getMasterId() != null && this.masterIdStratagy) {
                groupId = inventoryOptionGroup.getMasterId().toString();
            }
            dMod.setModGroup(groupId);
            dMod.setModGroupName(((SalesOption)mod).getOption().getOptionGroup().getLabel());
            InventoryOption invOp = ((SalesOption)mod).getOption();
            String id = invOp.getID().toString();
            if (invOp.getMasterId() != null && this.masterIdStratagy) {
                id = invOp.getMasterId().toString();
            }
            dMod.setModId(id);
        } else if (mod instanceof SalesAdd) {
            dMod.setType(DiamondModType.ADD);
            InventoryAddGroup inventoryAddGroup = ((SalesAdd)mod).getInventoryAdd().getAddGroup();
            String groupId = inventoryAddGroup.getID().toString();
            if (inventoryAddGroup.getMasterId() != null && this.masterIdStratagy) {
                groupId = inventoryAddGroup.getMasterId().toString();
            }
            dMod.setModGroup(groupId);
            dMod.setModGroupName(((SalesAdd)mod).getInventoryAdd().getAddGroup().getLabel());
            InventoryAdd invAdd = ((SalesAdd)mod).getInventoryAdd();
            String id = invAdd.getID().toString();
            if (invAdd.getMasterId() != null && this.masterIdStratagy) {
                id = invAdd.getMasterId().toString();
            }
            dMod.setModId(id);
        } else if (mod instanceof SalesRemove) {
            dMod.setType(DiamondModType.REMOVE);
            InventoryItem inventoryItem = ((SalesRemove)mod).getInventoryRemove().getItem();
            String groupId = inventoryItem.getID().toString();
            if (inventoryItem.getMasterId() != null && this.masterIdStratagy) {
                groupId = inventoryItem.getMasterId().toString();
            }
            dMod.setModGroup(groupId);
            dMod.setModGroupName(((SalesRemove)mod).getInventoryRemove().getItem().getLabel());
            InventoryRemove invRemove = ((SalesRemove)mod).getInventoryRemove();
            String id = invRemove.getID().toString();
            if (invRemove.getMasterId() != null && this.masterIdStratagy) {
                id = invRemove.getMasterId().toString();
            }
            dMod.setModId(id);
        } else if (mod instanceof SalesRemoveStocked) {
            dMod.setType(DiamondModType.INGREDIENT_REMOVE);
            StockGroup stockGroup = ((SalesRemoveStocked)mod).getStockItem().getStockGroup();
            String groupId = stockGroup.getID().toString();
            if (stockGroup.getMasterId() != null && this.masterIdStratagy) {
                groupId = stockGroup.getMasterId().toString();
            }
            dMod.setModGroup(groupId);
            dMod.setModGroupName(((SalesRemoveStocked)mod).getStockItem().getStockGroup().getLabel());
            dMod.setModId(((SalesRemoveStocked)mod).getStockItem().getID().toString());
            StockItem stockItem = ((SalesRemoveStocked)mod).getStockItem();
            String id = stockItem.getID().toString();
            if (stockItem.getMasterId() != null && this.masterIdStratagy) {
                id = stockItem.getMasterId().toString();
            }
            dMod.setModId(id);
        }
        return dMod;
    }

    private DiamondSalesQuantity doQuantity(SalesItemQuantity qty) {
        DiamondSalesQuantity dQty = new DiamondSalesQuantity();
        dQty.setQuantity(qty.getQuantity().getValue());
        dQty.setSalesQtyId(String.valueOf(qty.getID()));
        dQty.setCreated(XMLHelper.getDateType(qty.getCreationTime()));
        dQty.setState(qty.getItemState());
        dQty.setStaffId(qty.getUser().getID().toString());
        dQty.setTerminalId(qty.getTerminal().getID().toString());
        dQty.setTerminalName(qty.getTerminal().getLabel());
        return dQty;
    }

    private DiamondFinanceTransaction doTransaction(FinanceTransaction txn) {
        DiamondFinanceTransaction dTxn = new DiamondFinanceTransaction();
        dTxn.setTerminalId(txn.getTerminal().getID().toString());
        dTxn.setTxnId(txn.getID() == null ? null : txn.getID().toString());
        dTxn.setPaidAmount(txn.getPaid().toBigDecimal());
        dTxn.setCashoutAmount(txn.getCashOut() == null ? null : txn.getCashOut().toBigDecimal());
        dTxn.setTipAmount(txn.getTip() == null ? null : txn.getTip().toBigDecimal());
        dTxn.setTxnDatetime(XMLHelper.getDateType(txn.getCreationTime()));
        dTxn.setActive(Boolean.valueOf(txn.isActive()));
        dTxn.setRoundingAmount(txn.getRoundingAmt().toBigDecimal());
        dTxn.setUnitId(String.valueOf(txn.getSubType().getID()));
        dTxn.setUnitName(txn.getSubType().getLabel());
        dTxn.setSource(txn.getSource());
        dTxn.setReferenceId(txn.getTransactionReference());
        if (txn.getSurcharge() != null) {
            dTxn.setSurchargeAmount(txn.getSurcharge().toBigDecimal());
        }
        if (txn instanceof EftposTransaction) {
            if (((EftposTransaction)txn).getVirtualEftpos() != null) {
                dTxn.setEftposTerminalId(((EftposTransaction)txn).getVirtualEftpos().getTerminalId());
                dTxn.setEftposType(((EftposTransaction)txn).getVirtualEftpos().getEftposType().getLabel());
            } else {
                dTxn.setEftposTerminalId("-1");
                dTxn.setEftposType("Unknown");
            }
        }
        return dTxn;
    }

    private DiamondVoucherTransaction doVoucherTransaction(GiftVoucherTransaction txn) {
        DiamondVoucherTransaction dTxn = new DiamondVoucherTransaction();
        dTxn.setTxnId(txn.getID().toString());
        dTxn.setReferenceId(txn.getAuthId());
        dTxn.setPaidAmount(txn.getAmount().toBigDecimal());
        dTxn.setReversal(Boolean.valueOf(txn.getVoucherTransactionType().endsWith("L")));
        dTxn.setTopup(txn.getVoucherTransactionType().startsWith("T"));
        dTxn.setTerminalId(txn.getTerminalId().toString());
        dTxn.setVoucherId(txn.getUuid());
        dTxn.setTxnDatetime(XMLHelper.getDateType(DateTimeUtils.mergeDateAndTime(txn.getCreationDate(), txn.getCreationTime())));
        dTxn.setActive(Boolean.valueOf(SystemState.ACTIVE_STATE.equals(txn.getSystemState())));
        return dTxn;
    }

    private void applyOtherReservations(DiamondSale dSale, Reservation reservation) {
        List<Account> accounts = reservation.getLinkedAccounts();
        if (accounts == null || accounts.isEmpty()) {
            return;
        }
        for (Account account : accounts) {
            if (account == null || account == reservation.getTableAccount()) continue;
            try {
                DiamondSale linkedSale = this.translateAccount(account);
                if (linkedSale == null) continue;
                dSale.getLinkedSales().add(linkedSale);
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Cannot translate linked account, will not be sent to Diamondback", (Throwable)ex);
            }
        }
    }
}

