/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.salesexport;

import au.com.ordermate.util.StringUtils;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.integration.exportsales.ExportSalesIntegration;
import ordermate.database.integration.exportsales.SalesExporterType;
import ordermate.integration.jaxb.deputy.SalesData;
import ordermate.integration.salesexport.AbstractSalesExporter;
import ordermate.integration.webservice.PassthroughX509TrustManager;

public class TandaExporter
extends AbstractSalesExporter {
    public static String SUBDOMAIN = "my.tanda.co/";
    private static String tandaContext = "api/v2/";
    private static String sales = "storestats/for_datastream/";

    public TandaExporter(ExportSalesIntegration yourIntegration) {
        super(yourIntegration);
    }

    @Override
    public boolean canExport() {
        if (!SalesExporterType.Tanda.equals((Object)this.integration.getExporterType())) {
            OrderMate.LOG.error("The Tanda export type must be used.");
            return false;
        }
        if (this.integration.getOperationalUnit() <= 0) {
            OrderMate.LOG.error("We must have Tanda operational unit or datastream id: " + this.integration.getOperationalUnit());
            return false;
        }
        if (StringUtils.isEmpty(this.integration.getToken())) {
            OrderMate.LOG.error("Not Token for Tanda - please authorise");
            return false;
        }
        if (!this.integration.isEnabled()) {
            OrderMate.LOG.warn("Will not export to Tanda, not enabled");
            return false;
        }
        return true;
    }

    @Override
    public boolean exportData(List<SalesData> data) {
        if (data.isEmpty()) {
            return true;
        }
        HashMap mapByOperationalUnit = new HashMap();
        for (SalesData salesData : data) {
            BigInteger operationalUnit = salesData.getOperationalUnit();
            if (!mapByOperationalUnit.containsKey(operationalUnit)) {
                mapByOperationalUnit.put(operationalUnit, new ArrayList());
            }
            ((List)mapByOperationalUnit.get(operationalUnit)).add(salesData);
        }
        for (Map.Entry entry : mapByOperationalUnit.entrySet()) {
            if (this.sendSalesDataToEachDataStreams((BigInteger)entry.getKey(), (List)entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean sendSalesDataToEachDataStreams(BigInteger datastreamid, List<SalesData> data) {
        String converted = this.convertToJson(data);
        boolean fine = true;
        String uri = this.preamble + (StringUtils.isEmpty(this.integration.getSubdomain()) ? SUBDOMAIN : this.integration.getSubdomain()) + tandaContext + sales + datastreamid;
        OrderMate.LOG.info("Sending Tanda info to " + uri);
        WebResource resource = this.rest.getSSLWebResource(uri, new PassthroughX509TrustManager(), TIMEOUT, TIMEOUT, "TLSv1.2");
        try {
            WebResource.Builder builder = (WebResource.Builder)((WebResource.Builder)resource.header("Authorization", (Object)("Bearer " + this.integration.getToken())).type("application/json")).accept(new String[]{"application/json"});
            ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)converted);
            boolean bl = fine = response.getStatus() / 100 == 2;
            if (!fine) {
                OrderMate.LOG.warn("Export of Sales Data to Tanda failed: " + response.getStatus() + " " + (String)response.getEntity(String.class));
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot export sales data to Tanda", (Throwable)ex);
            fine = false;
        }
        return fine;
    }

    protected String convertToJson(List<SalesData> values) {
        StringBuilder SB = new StringBuilder("{\r\n\"stats\": [");
        if (!values.isEmpty()) {
            for (SalesData salesData : values) {
                SB.append("\r\n{\r\n\t").append("\"time\": ").append(salesData.getTimestamp().toGregorianCalendar().getTimeInMillis() / 1000L).append(",\r\n\t\"stat\": ").append(salesData.getSalesAmount()).append(",\r\n\t\"type\": \"sales\"\r\n},");
            }
            SB.replace(SB.length() - 1, SB.length(), "");
        }
        SB.append(" ]\r\n}");
        return SB.toString();
    }
}

