/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.scales;

import au.com.ordermate.networkio.ports.CommPort;
import au.com.ordermate.networkio.ports.SerialPort;
import ordermate.OrderMate;
import ordermate.database.hardware.physical.scales.Scales;
import ordermate.integration.scales.ScalesAdapter;

public abstract class CommPortScalesAdapter
implements ScalesAdapter {
    private static final int COUNTDOWN = 10;
    private CommPort port;
    private int countDown = 10;
    private boolean retailMode;

    public CommPortScalesAdapter(Scales yourScales) {
        if (yourScales == null) {
            throw new IllegalArgumentException("Cannot have a CommPortScalesAdapter without scales.");
        }
        this.retailMode = yourScales.isRetailMode();
        if ("Serial".equals(yourScales.getPortType())) {
            this.makeSerialPort(yourScales);
        } else if (!"None".equals(yourScales.getPortType())) {
            throw new IllegalArgumentException("Cannot make a Comm Port Scales Adapter with port type :" + yourScales.getPortType());
        }
    }

    private void makeSerialPort(Scales scales) {
        SerialPort serialPort = new SerialPort(scales.getPort(), scales.getPortSpeed(), true, scales.getFlowControl());
        serialPort.setParity(scales.getParity());
        serialPort.setDataBits(scales.getDataBits());
        serialPort.setStopBits(scales.getStopBits());
        this.port = serialPort;
    }

    protected void sendData(String toSend) {
        try {
            this.port.sendData(toSend);
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Cannot send data down port to scales:", (Throwable)ex);
        }
    }

    protected byte[] receiveData() {
        try {
            while (!this.port.hasData() && this.countDown > 0) {
                --this.countDown;
                Thread.sleep(50L);
            }
            this.countDown = 10;
            return this.port.receiveBytes();
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Couldn't read scales data from port.", (Throwable)ex);
            return null;
        }
    }

    @Override
    public void connectToScales() {
        this.disconnectFromScales();
        try {
            this.port.openConnection();
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Cannot open the port:" + this.port, (Throwable)ex);
        }
    }

    @Override
    public void disconnectFromScales() {
        if (this.port != null && this.port.isOpen()) {
            try {
                this.port.closeConnection();
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Cannot close off the port:" + this.port, (Throwable)ex);
            }
        }
    }

    public boolean isPortOpen() {
        return this.port.isOpen();
    }

    @Override
    public int getRecommendedPollPeriod() {
        return 500;
    }

    @Override
    public boolean isRetailMode() {
        return this.retailMode;
    }
}

