/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.scales;

import au.com.ordermate.configuration.Config;
import ordermate.OrderMate;
import ordermate.database.hardware.physical.scales.Scales;
import ordermate.database.hardware.physical.scales.ScalesStatus;
import ordermate.integration.scales.CommPortScalesAdapter;
import ordermate.integration.scales.ScalesResponse;

class ECR2ScalesAdapter
extends CommPortScalesAdapter {
    private static final byte ZERO = 80;
    private static final byte MINUS = 4;
    private static final byte OVERLOAD = 2;
    private static final byte MOTION = 1;
    private static final int WEIGHT_READING_LENGTH = 8;
    private static final int STATUS_READING_LENGTH = 5;
    private final String queryByte;
    private final int startByte;
    private final int endByte;
    private final int statusByte;
    private final int factor;

    public ECR2ScalesAdapter(Scales yourScales) {
        super(yourScales);
        int configFactor;
        this.queryByte = String.valueOf(Character.valueOf((char)yourScales.getQueryByte()));
        this.startByte = yourScales.getStartByte();
        this.endByte = yourScales.getEndByte();
        this.statusByte = yourScales.getStatusByte();
        this.factor = Config.isConfigSetup() ? ((configFactor = Config.getIntValue("scales_factor")) == 0 ? 1000 : configFactor) : 1000;
    }

    @Override
    public ScalesResponse getMeasurement() {
        if (this.isPortOpen()) {
            this.sendData(this.queryByte);
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            byte[] data = this.receiveData();
            return this.decodeData(data);
        }
        return new ScalesResponse(ScalesStatus.Unreachable, null);
    }

    ScalesResponse decodeData(byte[] data) {
        byte[] trimData;
        if (data == null || data.length == 0) {
            return ScalesResponse.UNREACHABLE;
        }
        if (this.statusByte >= 0 && data.length == 1) {
            return new ScalesResponse(ScalesStatus.Unstable, null);
        }
        ScalesResponse status = null;
        status = this.isValid(data) ? (this.isStatus(trimData = this.trimData(data)) ? this.decodeStatus(trimData) : this.decodeWeight(trimData)) : new ScalesResponse(ScalesStatus.GeneralError, null);
        return status;
    }

    private byte[] trimData(byte[] data) {
        byte[] toReturn = data;
        if (this.hasStart()) {
            if (this.hasEnd()) {
                toReturn = new byte[data.length - 2];
                System.arraycopy(data, 1, toReturn, 0, toReturn.length);
            } else {
                toReturn = new byte[data.length - 2];
                System.arraycopy(data, 1, toReturn, 0, toReturn.length);
            }
        } else if (this.hasEnd()) {
            toReturn = new byte[data.length - 2];
            System.arraycopy(data, 0, toReturn, 0, toReturn.length);
        }
        return toReturn;
    }

    boolean isValid(byte[] data) {
        if (data.length > 1) {
            if (!this.hasStart() || this.startByte == data[0]) {
                if (!this.hasEnd() || this.endByte == data[data.length - 2]) {
                    return true;
                }
                OrderMate.LOG.warn("Incoming scales string is not well formed, no end byte");
            } else {
                OrderMate.LOG.warn("Incoming Scales string no well formed, no start byte");
            }
        } else {
            OrderMate.LOG.warn("Incoming Scales string is way too short.");
        }
        return false;
    }

    private boolean isStatus(byte[] data) {
        return this.hasStatus() && this.statusByte == data[0];
    }

    private boolean hasStart() {
        return this.startByte >= 0;
    }

    private boolean hasEnd() {
        return this.endByte >= 0;
    }

    private boolean hasStatus() {
        return this.statusByte >= 0;
    }

    private ScalesResponse decodeStatus(byte[] data) {
        byte statusCode = data[1];
        ScalesStatus status = ScalesStatus.OK;
        if ((statusCode & 2) == 2) {
            status = ScalesStatus.Overload;
        } else if ((statusCode & 4) == 4) {
            status = ScalesStatus.Minus;
        } else if ((statusCode & 1) == 1) {
            status = ScalesStatus.Unstable;
        } else if ((statusCode & 0x50) == 80) {
            status = ScalesStatus.Zero;
        }
        return new ScalesResponse(status, null);
    }

    private ScalesResponse decodeWeight(byte[] data) {
        StringBuilder SB = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            SB.append(Character.valueOf((char)data[i]));
        }
        try {
            return new ScalesResponse(ScalesStatus.OK, Double.valueOf(SB.toString()) / (double)this.factor);
        }
        catch (NumberFormatException ex) {
            if (Config.isDebuging()) {
                OrderMate.LOG.warn("Junk in scales weight reading:" + SB.toString(), (Throwable)ex);
            }
            return new ScalesResponse(ScalesStatus.GeneralError, null);
        }
    }

    int getStatusByte() {
        return this.statusByte;
    }
}

