/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.scales.pie;

import ordermate.OrderMate;
import ordermate.database.InventoryItemUnitBarcodeLink;

class WedderburnExport {
    private static final int REQUIRED_PLU_LENGTH = 5;
    private final InventoryItemUnitBarcodeLink barcodeLink;
    private String PLU;
    private String barcode;

    WedderburnExport(InventoryItemUnitBarcodeLink yourLink) {
        this.barcodeLink = yourLink;
    }

    public String getPLU() {
        if (this.PLU == null) {
            this.makePLUAndBarcode();
        }
        return this.PLU;
    }

    public String getBarcode() {
        if (this.barcode == null) {
            this.makePLUAndBarcode();
        }
        return this.barcode;
    }

    public String getLocationCode() {
        return "1";
    }

    public String getGroup() {
        return "1";
    }

    private void makePLUAndBarcode() {
        String code = this.barcodeLink.getBarcode().getBarcode();
        if (!this.isValid(code)) {
            this.barcode = "";
            this.PLU = "";
            return;
        }
        this.PLU = code;
        StringBuilder SB = new StringBuilder("02");
        int pad = 5 - code.length();
        for (int i = 0; i < pad; ++i) {
            SB.append("0");
        }
        SB.append(code).append("000000");
        this.barcode = SB.toString();
    }

    private boolean isValid(String value) {
        boolean fine = value != null && value.length() > 0 && value.length() <= 5;
        boolean bl = fine = fine && !value.startsWith("0");
        if (fine) {
            try {
                int numeric = Integer.parseInt(value);
                fine = numeric > 0 && numeric < 9999;
            }
            catch (NumberFormatException ex) {
                OrderMate.LOG.warn("Incorrect plu " + value, (Throwable)ex);
            }
        }
        return fine;
    }

    public String getStatus() {
        return "1";
    }

    public String getBarcodeFormat() {
        return "4";
    }

    public String getPriceInCents() {
        return Integer.toString(this.barcodeLink.getItemUnit().getPrices().get(0).getPrice().getNumCents());
    }

    public String getName() {
        return this.barcodeLink.getItemUnit().getLabel();
    }
}

