/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.scales.pie;

import au.com.bytecode.opencsv.CSVWriter;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.InventoryItemUnitBarcodeLink;
import ordermate.database.inventory.InventoryBarcode;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.integration.scales.pie.WedderburnExport;

public class WedderburnExporter {
    private Map<String, WedderburnExport> exports;

    public WedderburnExporter() {
        this.getUnitsToExport();
    }

    private void getUnitsToExport() {
        ObjectQuery query = Query.select(InventoryItemUnitBarcodeLink.class).linkUsing(InventoryItemUnitBarcodeLink.Properties.ITEM_UNIT, InventoryItemUnit.Properties.ID).linkUsing(InventoryItemUnitBarcodeLink.Properties.BARCODE, InventoryBarcode.Properties.ID).active(InventoryItemUnit.class).not().isNull(InventoryBarcode.Properties.BARCODE).whereFunction("length(inventory_item_unit_barcodes.barcode) <= 5").orderBy(InventoryItemUnitBarcodeLink.Properties.ID);
        List<InventoryItemUnitBarcodeLink> links = PersistenceManager.getObjectList(InventoryItemUnitBarcodeLink.class, query.toString());
        this.exports = new LinkedHashMap<String, WedderburnExport>();
        for (InventoryItemUnitBarcodeLink nextLink : links) {
            WedderburnExport export = new WedderburnExport(nextLink);
            if (export.getPLU() == null || export.getPLU().length() <= 0 || this.exports.containsKey(export.getPLU())) continue;
            this.exports.put(export.getPLU(), export);
        }
    }

    public String performExport() {
        StringWriter sWriter = new StringWriter();
        char separator = ',';
        char quote = '\"';
        String lineEnd = "\r\n";
        CSVWriter writer = new CSVWriter((Writer)sWriter, separator, quote, lineEnd);
        String[] row = new String[8];
        boolean STATUS = false;
        boolean PLU = true;
        int LOCATION = 2;
        int GROUP = 3;
        int FORMAT = 4;
        int BARCODE = 5;
        int PRICE = 6;
        int NAME = 7;
        try {
            for (WedderburnExport export : this.exports.values()) {
                row[0] = export.getStatus();
                row[1] = export.getPLU();
                row[2] = export.getLocationCode();
                row[3] = export.getGroup();
                row[4] = export.getBarcodeFormat();
                row[5] = export.getBarcode();
                row[6] = export.getPriceInCents();
                row[7] = export.getName();
                writer.writeNext(row);
            }
            sWriter.flush();
            return sWriter.getBuffer().toString();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot write out wedderburn file");
            return null;
        }
    }
}

