/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.storegroup;

import au.com.ordermate.persistence.Executable;
import au.com.ordermate.util.DateTimeUtils;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ordermate.OrderMate;
import ordermate.integration.automatedsalesandvariance.SalesAndVarianceReport;

public class GenerateAndExportExecutable
extends Executable {
    private Date monthStart;
    private Date monthEnd;
    private List emailList;

    public GenerateAndExportExecutable(Date toTransmit, List emails) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(toTransmit);
        this.emailList = emails;
        Date[] range = DateTimeUtils.getMonthlyDateRange(cal.get(1), cal.get(2));
        this.monthStart = range[0];
        this.monthEnd = range[1];
    }

    public Object execute() {
        OrderMate.LOG.info("Executed task for exporting and sending Monthly Report for month:" + this.monthStart);
        try {
            SalesAndVarianceReport report = new SalesAndVarianceReport(this.monthStart, this.monthEnd, this.emailList);
            File[] files = report.export();
            report.transmit(files);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Unable to manually produce the reports for " + this.monthStart, (Throwable)ex);
        }
        return null;
    }
}

