/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.storegroup;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.Response;
import ordermate.OrderMate;
import ordermate.database.misc.StoreGroup;
import ordermate.database.reports.StoreGroupMonthlySales;
import ordermate.scheduler.Task;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;

public class StoreGroupMonthlyReportLoader
implements Task {
    private static final int MAX_RESPONSE_SIZE = 16096;
    public static final String NAME = "Group Monthly Performance Report Loader";
    private static final int NB_RETRY = 3;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run() {
        if (StoreGroup.getInstance().isSet()) {
            this.load();
        }
    }

    private void load() {
        List notSent = StoreGroupMonthlySales.findNotSent();
        if (!notSent.isEmpty()) {
            for (StoreGroupMonthlySales sales : notSent) {
                if (!this.post(sales)) continue;
                sales.setSent(new Date());
                sales.save();
            }
        }
    }

    protected boolean post(StoreGroupMonthlySales sales) {
        return this.post(sales, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean post(StoreGroupMonthlySales sales, boolean rethrowException) {
        boolean success = false;
        HttpClient client = new HttpClient();
        PostMethod method = new PostMethod(StoreGroup.getInstance().getAppServer());
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        NameValuePair[] pairs = new NameValuePair[]{new NameValuePair("code", StoreGroup.getInstance().getStoreNumber()), new NameValuePair("name", StoreGroup.getInstance().getStoreName()), new NameValuePair("month", Integer.toString(sales.getMonth())), new NameValuePair("year", Integer.toString(sales.getYear())), new NameValuePair("cash_sales", Integer.toString(sales.getCashSales())), new NameValuePair("cash_gross_profit_percent", Integer.toString(sales.getCashGrossProfitPercent())), new NameValuePair("cost_of_goods", Integer.toString(sales.getCostOfGoods())), new NameValuePair("debtors", Integer.toString(sales.getDebtors())), new NameValuePair("cash_customer_numbers", Integer.toString(sales.getCashCustomersNumber())), new NameValuePair("wastage", Integer.toString(sales.getWastage())), new NameValuePair("stock_on_hand", Integer.toString(sales.getStockOnHand())), new NameValuePair("last_stock_take", sales.getLastStockTake() == null ? "" : df.format(sales.getLastStockTake()))};
        method.addParameters(pairs);
        for (int i = 0; i < 3 && !success; ++i) {
            try {
                OrderMate.LOG.info("Post " + method + " to " + StoreGroup.getInstance().getAppServer());
                int statusCode = client.executeMethod((HttpMethod)method);
                if (statusCode != Response.Status.OK.getStatusCode()) {
                    OrderMate.LOG.warn("Method failed: " + method.getStatusLine() + " with " + method.getResponseBodyAsString(16096));
                    continue;
                }
                String responseBody = method.getResponseBodyAsString(16096);
                OrderMate.LOG.info(responseBody);
                if (!responseBody.startsWith("Received")) {
                    OrderMate.LOG.warn("Invalid response, should start by 'Received'.");
                    continue;
                }
                success = true;
                continue;
            }
            catch (HttpException e) {
                OrderMate.LOG.error("Fatal protocol violation: " + e.getMessage());
                for (int l = 0; l < pairs.length; ++l) {
                    if (pairs[l].getValue() != null && !pairs[l].getValue().isEmpty()) continue;
                    OrderMate.LOG.info("The value of " + pairs[l].getName() + " was " + pairs[l].getValue());
                }
                if (!rethrowException) continue;
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                OrderMate.LOG.warn("Fatal transport error: " + e.getMessage());
                if (!rethrowException) continue;
                throw new RuntimeException(e);
            }
            finally {
                method.releaseConnection();
            }
        }
        return success;
    }

    @Override
    public void setData(Object data) {
    }
}

