/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.storegroup;

import au.com.ordermate.util.DateTimeUtils;
import java.util.Calendar;
import java.util.Date;
import ordermate.OrderMate;
import ordermate.database.misc.StoreGroup;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.StoreGroupMonthlySalesManager;
import ordermate.scheduler.Task;

public class StoreGroupMonthlySaleTask
implements Task {
    public static final String NAME = "Group Monthly Performance Report";
    private TradingDay day;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run() {
        boolean hasChanged;
        if (!StoreGroup.getInstance().isSet()) {
            OrderMate.LOG.info("Store Group not set, no Group Monthly Performance Report to create.");
            return;
        }
        Date currentDay = this.day != null ? this.day.getCloseDate() : new Date();
        TradingDay lastClose = TradingDay.getLastClose();
        if (lastClose == null) {
            return;
        }
        Calendar calLast = Calendar.getInstance();
        calLast.setTime(lastClose.getDate());
        int mmLast = calLast.get(2);
        int yyLast = calLast.get(1);
        Calendar calCurrent = Calendar.getInstance();
        calCurrent.setTime(currentDay);
        int mmCurrent = calCurrent.get(2);
        int yyCurrent = calCurrent.get(1);
        boolean bl = hasChanged = mmCurrent != mmLast || yyCurrent != yyLast;
        if (!hasChanged && !StoreGroup.getInstance().getMonthReportStatus().equals("OK")) {
            hasChanged = true;
            Calendar endOfPreviousMonth = DateTimeUtils.getEndOfPreviousMonth(currentDay);
            mmLast = endOfPreviousMonth.get(2);
            yyLast = endOfPreviousMonth.get(1);
        }
        if (hasChanged) {
            OrderMate.LOG.info("The Group Monthly Performance Report is running for " + (mmLast + 1) + "-" + yyLast + " as we are now " + (mmCurrent + 1) + "-" + yyCurrent);
            StoreGroup.getInstance().setMonthReportStatus("STARTED");
            StoreGroup.getInstance().save();
            StoreGroupMonthlySalesManager manager = new StoreGroupMonthlySalesManager(mmLast + 1, yyLast);
            manager.getMonthlySales().save();
            manager.publishResult();
            StoreGroup.getInstance().setMonthReportStatus("OK");
            StoreGroup.getInstance().save();
            OrderMate.LOG.info("The result has been published by Group Monthly Performance Report for " + (mmLast + 1) + "-" + yyLast);
        }
    }

    @Override
    public void setData(Object data) {
        if (data instanceof TradingDay) {
            this.day = (TradingDay)data;
        }
    }
}

