/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.storegroup.eftpos;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import ordermate.database.misc.StoreGroup;
import ordermate.integration.eftpos.report.EftposDetailedReport;
import ordermate.integration.eftpos.report.WriteableReport;
import ordermate.integration.storegroup.eftpos.StoreGroupEmailingReportTask;

public abstract class AbstractEftposDetailedReportTask
extends StoreGroupEmailingReportTask {
    private DateFormat format = new SimpleDateFormat("dd-MM-yy");
    private Date tradingDay;
    private Date fromDay;
    private Date toDay;

    @Override
    protected String createFileName() {
        StringBuilder SB = new StringBuilder("EFTPOS Report Detailed ").append(StoreGroup.getInstance().getStoreNumber()).append(" ").append(StoreGroup.getInstance().getStoreName()).append(" for ").append(this.format.format(this.fromDay));
        if (!this.fromDay.equals(this.toDay)) {
            SB.append(" to ").append(this.format.format(this.toDay));
        }
        return SB.toString();
    }

    @Override
    protected WriteableReport getReport() {
        return new EftposDetailedReport(this.fromDay, this.toDay);
    }

    @Override
    protected boolean mayExport() {
        return this.tradingDay != null && this.fromDay != null && this.toDay != null;
    }

    @Override
    public void setData(Object data) {
        this.tradingDay = (Date)data;
        this.fromDay = this.getFromDay(this.tradingDay);
        this.toDay = this.getToDay(this.tradingDay);
    }

    protected abstract Date getFromDay(Date var1);

    protected abstract Date getToDay(Date var1);
}

