/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.storegroup.eftpos;

import au.com.ordermate.OrderMateLog;
import java.text.SimpleDateFormat;
import java.util.Date;
import ordermate.database.misc.StoreGroup;
import ordermate.database.misc.TradingDay;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.integration.eftpos.report.EftposSummaryReport;
import ordermate.integration.eftpos.report.WriteableReport;
import ordermate.integration.storegroup.eftpos.StoreGroupEmailingReportTask;

public class EftposSummaryReportTask
extends StoreGroupEmailingReportTask {
    public static final String NAME = "Group Daily Eftpos Report";
    private TradingDay tradingDay;
    private SimpleDateFormat filenameDateFormat = new SimpleDateFormat("dd-MM-yyyy");

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setData(Object data) {
        if (data instanceof Date) {
            this.tradingDay = TradingDay.ReportDates.getFirstTradingDayForDate((Date)data);
        }
    }

    @Override
    protected boolean mayExport() {
        if (this.tradingDay == null) {
            OrderMateLog.LOG.info("Not exporting EftposSummary report, no TradingDay is defined");
            return false;
        }
        if (!PersistentLicenseManager.getInstance().getBoolean(LicenseType.EftposIntegrationEnabled)) {
            OrderMateLog.LOG.info("Not exporting Eftpos Report, Eftpos is not integrated on this machine.");
            return false;
        }
        return true;
    }

    @Override
    protected WriteableReport getReport() {
        if (this.tradingDay != null) {
            return new EftposSummaryReport(this.tradingDay.getOpenDateTime());
        }
        return null;
    }

    @Override
    protected String createFileName() {
        StringBuilder SB = new StringBuilder("Daily Eftpos Report ");
        SB.append(StoreGroup.getInstance().getStoreNumber()).append(" ").append(StoreGroup.getInstance().getStoreName()).append(" for ").append(this.filenameDateFormat.format(this.tradingDay.getDate()));
        return SB.toString();
    }
}

