/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.storegroup.eftpos;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.message.Email;
import au.com.ordermate.message.MessageServer;
import au.com.ordermate.util.StringUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.mail.SendFailedException;
import javax.mail.internet.InternetAddress;
import ordermate.database.misc.StoreGroup;
import ordermate.database.misc.SystemProperty;
import ordermate.integration.cloudback.OMOutgoingServiceResponse;
import ordermate.integration.cloudback.nudge.NudgeManager;
import ordermate.integration.eftpos.report.WriteableReport;
import ordermate.scheduler.Task;

public abstract class StoreGroupEmailingReportTask
implements Task,
Serializable {
    private List<String> emailAddresses;
    private boolean emailSent = false;

    protected abstract WriteableReport getReport();

    @Override
    public void run() {
        if (!this.mayExport()) {
            return;
        }
        if (!StoreGroup.getInstance().isSet()) {
            OrderMateLog.LOG.info("Not exporting " + this.getName() + ", no store group.");
            return;
        }
        if (this.emailAddresses == null) {
            this.emailAddresses = this.getListOfEmails(StoreGroup.getInstance().getEmailAddress());
        }
        if (this.emailAddresses.isEmpty()) {
            throw new IllegalStateException("Cannot send an email to nobody.");
        }
        WriteableReport report = this.getReport();
        File outputFile = new File(StoreGroup.getExistingOutputDir() + File.separator + this.createFileName() + ".csv");
        outputFile.getParentFile().mkdirs();
        FileWriter writer = null;
        try {
            writer = new FileWriter(outputFile);
            report.writeReport(writer);
        }
        catch (IOException ex) {
            OrderMateLog.LOG.error("Error occurred while writing CSV file for " + this.getName(), (Throwable)ex);
        }
        try {
            this.transmit(outputFile);
        }
        catch (SendFailedException ex) {
            OrderMateLog.LOG.warn("Could not send " + this.getName() + " via email.", (Throwable)ex);
        }
        outputFile.delete();
    }

    protected abstract boolean mayExport();

    protected abstract String createFileName();

    public void setEmailAddresses(List<String> value) {
        this.emailAddresses = value;
    }

    private List<String> getListOfEmails(String emails) {
        ArrayList<String> validSplits = new ArrayList<String>();
        String[] splits = emails.split("\\s");
        for (int i = 0; i < splits.length; ++i) {
            if (splits[i].trim().isEmpty()) continue;
            validSplits.add(splits[i]);
        }
        return validSplits;
    }

    private void transmit(File dataToTransmit) throws SendFailedException {
        if (!NudgeManager.isNudgeConfigured()) {
            MessageServer.getServer().connect();
            if (!MessageServer.getServer().isSmtpConnected()) {
                throw new SendFailedException("Could not connect to the SMTP server, e-mail will not be sent");
            }
        }
        StringBuilder SB = new StringBuilder("Emailing Report to ");
        for (String emailAddress : this.emailAddresses) {
            SB.append(emailAddress).append(", ");
        }
        OrderMateLog.LOG.info(SB.toString());
        this.sendEmail(this.createFileName(), dataToTransmit);
    }

    private void sendEmail(String subject, File toSend) throws SendFailedException {
        Email eftposEmail = new Email();
        eftposEmail.addReplyTo("support@ordermate.com.au", "OrderMate");
        eftposEmail.setSubject(subject);
        String emailSender = SystemProperty.getInstance().getEmailSender();
        if (!StringUtils.isEmpty(emailSender)) {
            eftposEmail.addSender(emailSender, emailSender);
        } else {
            eftposEmail.addSender("support@ordermate.com.au", "OrderMate");
        }
        for (String address : this.emailAddresses) {
            try {
                InternetAddress emailAdd = new InternetAddress(address);
                eftposEmail.addToRecipient(emailAdd);
            }
            catch (Exception e) {
                OrderMateLog.LOG.warn("Invalid address when sending Eftpos Report.", (Throwable)e);
            }
        }
        eftposEmail.setText(subject);
        eftposEmail.addAttachment(toSend);
        if (NudgeManager.isNudgeConfigured()) {
            OMOutgoingServiceResponse omNudgeResponse = NudgeManager.getInstance().sendEmail(eftposEmail);
            this.emailSent = omNudgeResponse.isSuccessful();
        } else if (!MessageServer.getServer().send(eftposEmail.createMessage(MessageServer.getServer().getSession()))) {
            throw new SendFailedException("Failed to send the " + subject + " message.");
        }
    }

    public boolean isEmailSent() {
        return this.emailSent;
    }
}

