/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.types;

import au.com.ordermate.util.StringUtils;
import au.com.ordermate.xmlintegration.omni.OmniBackRequirement;
import au.com.ordermate.xmlintegration.omni.OmniBackRequirements;
import au.com.ordermate.xmlintegration.omni.OmniBackRequirementsType;
import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.integration.cloudback.CloudServerType;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.integration.cloudback.CloudIntegrationUtil;
import ordermate.integration.diamondback.DiamondBackIntegrator;
import ordermate.integration.humpy.HumpBackIntegration;
import ordermate.integration.types.PosIntegrationSummary;
import ordermate.integration.types.PosIntegrationType;

public class PosIntegrationSummaryFactory {
    public List<PosIntegrationSummary> getPosIntegrations() {
        ArrayList<PosIntegrationSummary> summaries = new ArrayList<PosIntegrationSummary>();
        this.add(summaries, this.getHumpBackConfig());
        this.add(summaries, this.getReservationsConfig());
        this.add(summaries, this.getVouchersConfig());
        return summaries;
    }

    private PosIntegrationSummary[] getReservationsConfig() {
        long redbackId = SystemCurrentInfo.getInstance().getRedbackId();
        ArrayList<PosIntegrationSummary> summaryList = new ArrayList<PosIntegrationSummary>();
        if (redbackId > 0L) {
            try {
                CloudBackConfig snakeConfig = DiamondBackIntegrator.getDiamondBackConfig();
                OmniBackRequirements reqTypes = CloudIntegrationUtil.getRequirementTypes(snakeConfig, redbackId);
                if (reqTypes != null) {
                    for (OmniBackRequirementsType nextType : reqTypes.getReqTypes()) {
                        OmniBackRequirements reqs = CloudIntegrationUtil.getRequirementsForType(snakeConfig, redbackId, nextType);
                        PosIntegrationSummary summary = new PosIntegrationSummary(PosIntegrationType.Reservations, nextType.getLabel(), nextType.getDescription());
                        boolean active = true;
                        StringBuilder SB = new StringBuilder();
                        for (OmniBackRequirement req : reqs.getRequirements()) {
                            SB.append(req.getLabel()).append(" ").append(req.getValue()).append("\r\n ");
                            if (!StringUtils.isEmpty(req.getValue())) continue;
                            active = false;
                        }
                        summary.setInfo(SB.toString());
                        summary.setActive(active);
                        summary.setData(nextType);
                        summaryList.add(summary);
                    }
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.info("Received reqTypes from DiamondBack:", (Throwable)ex);
            }
        }
        PosIntegrationSummary[] summaries = summaryList.toArray(new PosIntegrationSummary[summaryList.size()]);
        return summaries;
    }

    private PosIntegrationSummary[] getVouchersConfig() {
        long redbackId = SystemCurrentInfo.getInstance().getRedbackId();
        ArrayList<PosIntegrationSummary> summaryList = new ArrayList<PosIntegrationSummary>();
        if (redbackId > 0L) {
            try {
                CloudBackConfig hiveConfig = CloudBackConfig.getCloudBackConfig(CloudServerType.Hive);
                OmniBackRequirements reqTypes = CloudIntegrationUtil.getRequirementTypes(hiveConfig, redbackId);
                if (reqTypes != null) {
                    for (OmniBackRequirementsType nextType : reqTypes.getReqTypes()) {
                        OmniBackRequirements reqs = CloudIntegrationUtil.getRequirementsForType(hiveConfig, redbackId, nextType);
                        PosIntegrationSummary summary = new PosIntegrationSummary(PosIntegrationType.Vouchers, nextType.getLabel(), nextType.getDescription());
                        boolean active = true;
                        StringBuilder SB = new StringBuilder();
                        for (OmniBackRequirement req : reqs.getRequirements()) {
                            SB.append(req.getLabel()).append(" ").append(req.getValue()).append("\r\n ");
                            if (!StringUtils.isEmpty(req.getValue())) continue;
                            active = false;
                        }
                        summary.setInfo(SB.toString());
                        summary.setActive(active);
                        summary.setData(nextType);
                        summaryList.add(summary);
                    }
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Didn't receive reqTypes from Hive:", (Throwable)ex);
            }
        }
        PosIntegrationSummary[] summaries = summaryList.toArray(new PosIntegrationSummary[summaryList.size()]);
        return summaries;
    }

    private PosIntegrationSummary[] getHumpBackConfig() {
        long redbackId = SystemCurrentInfo.getInstance().getRedbackId();
        ArrayList<PosIntegrationSummary> summaryList = new ArrayList<PosIntegrationSummary>();
        if (redbackId > 0L) {
            try {
                CloudBackConfig humpyConfig = HumpBackIntegration.getHumpBackConfig();
                OmniBackRequirements reqTypes = CloudIntegrationUtil.getRequirementTypes(humpyConfig, redbackId);
                if (reqTypes != null) {
                    for (OmniBackRequirementsType nextType : reqTypes.getReqTypes()) {
                        OmniBackRequirements reqs = CloudIntegrationUtil.getRequirementsForType(humpyConfig, redbackId, nextType);
                        PosIntegrationSummary summary = new PosIntegrationSummary(PosIntegrationType.OnlineOrders, nextType.getLabel(), nextType.getDescription());
                        boolean active = true;
                        StringBuilder SB = new StringBuilder();
                        for (OmniBackRequirement req : reqs.getRequirements()) {
                            SB.append(req.getLabel()).append(" ").append(req.getValue()).append("\r\n ");
                            if (!StringUtils.isEmpty(req.getValue())) continue;
                            active = false;
                        }
                        summary.setInfo(SB.toString());
                        summary.setActive(active);
                        summary.setData(nextType);
                        summaryList.add(summary);
                    }
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.info("Received reqTypes from HumpBack:", (Throwable)ex);
            }
        }
        PosIntegrationSummary[] summaries = summaryList.toArray(new PosIntegrationSummary[summaryList.size()]);
        return summaries;
    }

    private void add(List<PosIntegrationSummary> addTo, PosIntegrationSummary ... summaries) {
        if (summaries != null) {
            for (PosIntegrationSummary next : summaries) {
                if (next == null) continue;
                addTo.add(next);
            }
        }
    }
}

