/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.videopro;

import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import ordermate.OrderMate;
import ordermate.database.Payable;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.Camera;
import ordermate.database.hardware.physical.CameraSocketServer;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.users.User;

public class CCTVIntegration {
    private static final String START_TAG = "ORDERMATE POS CAMERA";
    private static final String END_TAG = "END TRANSACTION";
    private static final Map<Camera, CameraSocketServer> cameraSockets = new HashMap<Camera, CameraSocketServer>();

    public static void showPayoff(Payable payable, Set<FinanceTransaction> newTransactions, User currentUser, Terminal theTerminal) {
        Camera camera = theTerminal.getCCTVCamera();
        try {
            String toDisplay = CCTVIntegration.getPayoffOutput(camera, payable, newTransactions, currentUser, theTerminal);
            camera.display(toDisplay);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot create camera output for payoff", (Throwable)ex);
        }
    }

    public static void showNoSale(String area, User user, Terminal theTerminal) {
        Camera camera = theTerminal.getCCTVCamera();
        for (CashDrawer cd : theTerminal.getPayableCashDrawers(user)) {
            camera.display(CCTVIntegration.getNoSaleOutputString(camera, theTerminal, area, cd, user));
        }
    }

    private static StringBuilder createDefaultBuilder(Camera camera, User user, Terminal terminal) {
        StringBuilder SB = new StringBuilder(START_TAG);
        SB.append(" ~ ").append(camera.getLabel()).append("\r\n");
        SB.append("\r\nUser: ").append(user != null ? user.getName() : "No User").append("\r\nTerminal: ").append(terminal != null ? terminal.getLabel() : "No Terminal").append("\r\nTime: ").append(DateTimeUtils.getTimeStamp());
        return SB;
    }

    private static void applyEndTag(StringBuilder SB) {
        SB.append("\r\n").append(END_TAG).append("\r\n");
    }

    static String getPayoffOutput(Camera camera, Payable payable, Set<FinanceTransaction> newTransactions, User currentUser, Terminal theTerminal) {
        StringBuilder SB = CCTVIntegration.createDefaultBuilder(camera, currentUser, theTerminal);
        SB.append("\r\nAccount: ").append(payable.getLabel()).append("\r\n\r\nAccount Total: ").append(payable.getTotal()).append(" \r\n");
        if (payable instanceof Account) {
            Account account = (Account)payable;
            for (SalesLineItem item : account.getItems()) {
                SB.append(item.getQuantity());
                SB.append(" ");
                SB.append(item.getLabel());
                SB.append(" ");
                SB.append(item.getPrice());
                SB.append("\r\n");
            }
            if (account.isDiscounted()) {
                SB.append("Discount : ").append(account.getPriceAdjHelper().stringifyDiscounts()).append("\r\n");
            }
            if (account.getPriceAdjHelper().isSurcharged()) {
                SB.append("Surcharge: ").append(account.getPriceAdjHelper().stringifySurcharges()).append("\r\n");
            }
        }
        for (FinanceTransaction txn : newTransactions) {
            SB.append("Payment: ").append(txn.getSubType().getLabel()).append(" ").append(txn.getPaid()).append("\r\n");
            if (!txn.getTendered().equals(txn.getPaid())) {
                SB.append("   Tendered: ").append(payable.getTendered()).append(" \r\n").append("   Change: ").append(payable.getTendered().subtract(txn.getPaid()).toString()).append("\r\n");
            }
            if (Price.ZERO_DOLLAR.equals(txn.getCashOut())) continue;
            SB.append("   Cash out: ").append(txn.getCashOut()).append(" \r\n");
        }
        CCTVIntegration.applyEndTag(SB);
        return SB.toString();
    }

    static String getNoSaleOutputString(Camera camera, Terminal theTerminal, String area, CashDrawer toOpen, User user) {
        StringBuilder SB = CCTVIntegration.createDefaultBuilder(camera, user, theTerminal);
        SB.append("\r\nCashdrawer ").append(toOpen.getLabel()).append(" opened. No sale called from ").append(area).append("\r\n");
        CCTVIntegration.applyEndTag(SB);
        return SB.toString();
    }

    public static void registerClientCamera(Camera camera) throws IOException {
        if (!cameraSockets.containsKey(camera)) {
            CameraSocketServer server = new CameraSocketServer(camera.getTcpPort());
            Thread thread = new Thread(server);
            thread.start();
            cameraSockets.put(camera, server);
        }
    }

    public static void push(Camera camera, String output) throws Exception {
        if (camera.isClient()) {
            CCTVIntegration.pushToClient(camera, output);
        } else {
            CCTVIntegration.pushToServer(camera, output);
        }
    }

    public static void pushToServer(Camera camera, String output) throws Exception {
        for (String nextSplit : CCTVIntegration.split(camera, output)) {
            InetAddress machineAddy = InetAddress.getByName(camera.getIpAddress());
            Socket dataSocket = new Socket(machineAddy, camera.getTcpPort());
            CCTVIntegration.pushToSocket(dataSocket, output);
            try {
                dataSocket.close();
            }
            catch (IOException ex) {
                OrderMate.LOG.warn("Couldn't close off the camera socket:", (Throwable)ex);
            }
        }
    }

    private static void pushToClient(Camera camera, String output) throws Exception {
        CameraSocketServer server = cameraSockets.get(camera);
        for (String nextSplit : CCTVIntegration.split(camera, output)) {
            if (camera.isConnectPerLine()) {
                server.reconnect();
            }
            if (server != null && server.canPublish()) {
                CCTVIntegration.pushToSocket(server.getClientSocket(), output);
                continue;
            }
            OrderMate.LOG.warn("Couldn't push data to camera, cannot publish.");
        }
    }

    private static String[] split(Camera camera, String output) {
        String[] splits = !camera.isConnectPerLine() ? new String[]{output} : output.split("\n");
        return splits;
    }

    private static void pushToSocket(Socket socket, String message) throws Exception {
        OrderMate.LOG.info("Pushing message to camera:" + message);
        BufferedOutputStream out = new BufferedOutputStream(socket.getOutputStream());
        PrintWriter printer = new PrintWriter(out);
        printer.print(message);
        printer.flush();
    }
}

