/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.voucher;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.simplermi.SimpleRMI;
import au.com.ordermate.util.HtmlUtils;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.giftvoucher.VoucherAdministrator;
import ordermate.database.finance.giftvoucher.VoucherResponse;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.giftvoucher.GiftVoucherConfiguration;
import ordermate.database.sales.SalesLineItem;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class VoucherAdministratorRMI
implements VoucherAdministrator {
    public final Signal<Boolean, ?, ?, ?, ?> redeemDone = Signals.createSignal(Boolean.class, "success");
    private static VoucherAdministratorRMI instance;
    private VoucherAdministrator resolvedAdmin;
    private final GuiHandler gui;

    public static VoucherAdministratorRMI getInstance() {
        return instance;
    }

    public static void init(GuiHandler gui) {
        if (instance == null) {
            instance = new VoucherAdministratorRMI(gui);
            instance.resolve();
        }
    }

    private VoucherAdministratorRMI(GuiHandler guiHandler) {
        this.gui = guiHandler;
    }

    synchronized void setResolvedAdministration(VoucherAdministrator admin) {
        this.resolvedAdmin = admin;
    }

    synchronized VoucherAdministrator getRemoteAdministrator() {
        this.resolve();
        return this.resolvedAdmin;
    }

    private synchronized boolean resolve() {
        if (this.resolvedAdmin != null) {
            try {
                this.resolvedAdmin.ping();
            }
            catch (Exception ex) {
                OrderMate.LOG.info("Resolved Admin seems to have dropped off, reacquiring");
                this.resolvedAdmin = null;
            }
        }
        if (this.resolvedAdmin == null) {
            try {
                this.resolvedAdmin = (VoucherAdministrator)SimpleRMI.getObject(Terminal.getServerMateTerminal().getAddress(), "VoucherAdminRemote", 11100);
                OrderMate.LOG.info("Resolved RMI Instance of Voucher Administrator");
            }
            catch (RemoteException e) {
                OrderMate.LOG.error("Can't retrieve VoucherAdmin from ServerMate", (Throwable)e);
            }
            catch (NotBoundException e) {
                OrderMate.LOG.error("Can't retrieve VoucherAdmin from ServerMate, smells like it's not bound?", (Throwable)e);
            }
        }
        return this.resolvedAdmin != null;
    }

    private void showError(final String attempt, Exception ex) {
        final String error = "Cannot " + attempt + ": " + ex.getMessage();
        OrderMate.LOG.error(error, (Throwable)ex);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VoucherAdministratorRMI.this.gui.displayErrorDialog(attempt, HtmlUtils.html(error), null);
            }
        });
    }

    @Override
    public GiftVoucher getVoucher(String UUID2) {
        if (this.resolve()) {
            try {
                GiftVoucher voucher = this.resolvedAdmin.getVoucher(UUID2);
                if (voucher == null) {
                    OrderMate.LOG.warn("Getting Voucher! Voucher id " + UUID2 + " is not found!");
                }
                return voucher;
            }
            catch (IllegalStateException ise) {
                OrderMate.LOG.warn("Cannot Get Voucher!", (Throwable)ise);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot Get Voucher. Please see logs.", (Throwable)ex);
            }
        }
        return null;
    }

    @Override
    public GiftVoucher resyncVoucher(String UUID2) {
        if (this.resolve()) {
            try {
                return this.resolvedAdmin.resyncVoucher(UUID2);
            }
            catch (Exception ex) {
                this.showError("Resync Voucher", ex);
                this.resolvedAdmin = null;
            }
        }
        return null;
    }

    @Override
    public VoucherResponse createVoucher(String UUID2, boolean forceCreate) throws RemoteException {
        if (this.resolve()) {
            try {
                return this.resolvedAdmin.createVoucher(UUID2, forceCreate);
            }
            catch (Exception ex) {
                this.resolvedAdmin = null;
            }
        }
        return null;
    }

    @Override
    public VoucherResponse topupVoucher(GiftVoucherTransaction txn, EventContext context) {
        if (this.resolve()) {
            try {
                return this.resolvedAdmin.topupVoucher(txn, context);
            }
            catch (Exception ex) {
                this.showError("Load Voucher", ex);
                this.resolvedAdmin = null;
            }
        }
        return null;
    }

    @Override
    public VoucherResponse redeemVoucher(GiftVoucherTransaction txn, FinanceTransactionContext context, boolean ignoreExpiry) {
        if (this.resolve()) {
            try {
                return this.resolvedAdmin.redeemVoucher(txn, context, ignoreExpiry);
            }
            catch (Exception ex) {
                this.showError("Consume Voucher", ex);
                this.resolvedAdmin = null;
            }
        }
        return null;
    }

    @Override
    public VoucherResponse redeemVoucher(GiftVoucherTransaction txn, FinanceTransactionContext context, boolean ignoreExpiry, List<SalesLineItem> selectedItems) {
        if (this.resolve()) {
            try {
                return this.resolvedAdmin.redeemVoucher(txn, context, ignoreExpiry, selectedItems);
            }
            catch (Exception ex) {
                this.showError("Consume Voucher", ex);
                this.resolvedAdmin = null;
            }
        }
        return null;
    }

    @Override
    public VoucherResponse cancelTransaction(GiftVoucherTransaction txn, EventContext context) {
        if (this.resolve()) {
            try {
                return this.resolvedAdmin.cancelTransaction(txn, context);
            }
            catch (Exception ex) {
                this.showError("Cancel Transaction", ex);
                this.resolvedAdmin = null;
            }
        }
        return null;
    }

    @Override
    public VoucherResponse reverseTransaction(GiftVoucherTransaction txn, EventContext context) {
        if (this.resolve()) {
            try {
                return this.resolvedAdmin.reverseTransaction(txn, context);
            }
            catch (Exception ex) {
                this.showError("Reverse Transaction", ex);
                this.resolvedAdmin = null;
            }
        }
        return null;
    }

    public boolean isResolved() {
        return this.resolve();
    }

    @Override
    public Integer getVoucherDefaultExpiryPeriod(String UUID2) {
        if (this.resolve()) {
            try {
                return this.resolvedAdmin.getVoucherDefaultExpiryPeriod(UUID2);
            }
            catch (Exception ex) {
                this.showError("Return Default Expiry Period", ex);
                this.resolvedAdmin = null;
            }
        }
        return null;
    }

    @Override
    public VoucherResponse generateVoucher(GiftVoucherConfiguration config) throws RemoteException {
        if (this.resolve()) {
            try {
                return this.resolvedAdmin.generateVoucher(config);
            }
            catch (Exception ex) {
                this.showError("Generate Voucher", ex);
                this.resolvedAdmin = null;
            }
        }
        return null;
    }

    @Override
    public void confirmTransactions(List<GiftVoucherTransaction> voucherTxns) throws RemoteException {
        if (this.resolve()) {
            try {
                this.resolvedAdmin.confirmTransactions(voucherTxns);
            }
            catch (Exception ex) {
                this.showError("Confirm Voucher Tranactions", ex);
                this.resolvedAdmin = null;
            }
        }
    }

    @Override
    public boolean ping() throws RemoteException {
        if (this.resolvedAdmin != null) {
            return this.resolvedAdmin.ping();
        }
        return false;
    }
}

