/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.voucher;

import au.com.ordermate.csv.AbstractCSVExporter;
import java.util.List;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.integration.giftvoucher.GiftVoucherConfiguration;
import ordermate.database.queries.finance.voucher.VoucherQueries;

public class VoucherExporter
extends AbstractCSVExporter<GiftVoucher> {
    private final GiftVoucherConfiguration scheme;
    private final String[] header = new String[]{"ID", "Balance"};

    public VoucherExporter(GiftVoucherConfiguration scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException("The voucher scheme of exporter cannot be null!");
        }
        this.scheme = scheme;
    }

    @Override
    public List<GiftVoucher> getExportableEntities() {
        return VoucherQueries.getActiveVouchers(this.scheme);
    }

    @Override
    public String[] getExportableData(GiftVoucher voucher) {
        return new String[]{voucher.getUniqueId(), voucher.getCachedValue().toString(false)};
    }

    @Override
    public String[] getHeader() {
        return this.header;
    }
}

