/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.webservice;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthServiceProvider;
import net.oauth.ParameterStyle;
import net.oauth.client.OAuthClient;
import net.oauth.client.httpclient4.HttpClient4;
import net.oauth.http.HttpClient;
import ordermate.OrderMate;
import ordermate.integration.webservice.OAuthMapBuilder;

public abstract class OAuthHelper {
    private Map<String, String> props;
    public static final String ACCESS_TOKEN = "accessToken";
    public static final String REQUEST_TOKEN = "requestToken";
    public static final String TOKEN_SECRET = "tokenSecret";
    public static final String REQUEST_URL = "requestUrl";
    public static final String OAUTH_TOKEN = "oauth_token";
    public static final String OAUTH_TOKEN_SECRET = "oauth_token_secret";
    private int connectionTimeout = 10000;
    private int readTimeout = 20000;

    public OAuthHelper(OAuthMapBuilder builder) {
        this.props = builder.buildMap();
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    protected OAuthAccessor createOAuthAccessor() {
        String consumerKey = this.props.get("consumerKey");
        String callbackUrl = null;
        String consumerSecret = this.props.get("consumerSecret");
        String reqUrl = this.props.get(REQUEST_URL);
        String authzUrl = this.props.get("authorizationUrl");
        String accessUrl = this.props.get("accessUrl");
        OAuthServiceProvider provider = new OAuthServiceProvider(reqUrl, authzUrl, accessUrl);
        OAuthConsumer consumer = new OAuthConsumer(callbackUrl, consumerKey, consumerSecret, provider);
        this.addAdditionalParametersToConsumer(consumer, this.props);
        return new OAuthAccessor(consumer);
    }

    protected abstract void addAdditionalParametersToConsumer(OAuthConsumer var1, Map<String, String> var2);

    private OAuthMessage sendRequest(String method, Map map, String url) throws IOException, URISyntaxException, OAuthException {
        return this.sendRequest(method, map, url, null, "application/json");
    }

    private OAuthMessage sendRequest(String method, Map map, String url, String dataToAddToStream) throws IOException, URISyntaxException, OAuthException {
        return this.sendRequest(method, map, url, dataToAddToStream, "application/json");
    }

    private OAuthMessage sendRequest(String method, Map map, String url, String dataToAddToStream, String mediatype) throws IOException, URISyntaxException, OAuthException {
        OAuthMessage message;
        ArrayList<OAuth.Parameter> params = new ArrayList<OAuth.Parameter>();
        for (Map.Entry p : map.entrySet()) {
            params.add(new OAuth.Parameter((String)p.getKey(), (String)p.getValue()));
        }
        OAuthAccessor accessor = this.createOAuthAccessor();
        accessor.tokenSecret = this.props.get(TOKEN_SECRET);
        if (dataToAddToStream == null) {
            message = new OAuthMessage(method, url, params);
            message.getHeaders().add(new OAuth.Parameter("Content-Type", mediatype));
        } else {
            message = new MessageWithBody(method, url, params, mediatype, dataToAddToStream.getBytes("UTF-8"));
        }
        message.addRequiredParameters(accessor);
        OAuthClient client = new OAuthClient(this.getHttpClient());
        client.getHttpParameters().put("connectTimeout", this.connectionTimeout);
        client.getHttpParameters().put("readTimeout", this.readTimeout);
        return client.invoke(message, ParameterStyle.BODY);
    }

    private InputStream dataAsStream(String dataToAddToStream) {
        if (dataToAddToStream == null) {
            return null;
        }
        byte[] data = null;
        try {
            data = dataToAddToStream.getBytes();
        }
        catch (Exception e) {
            OrderMate.LOG.error("OAuthHelper.dataAsStream() :" + e);
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        return stream;
    }

    public void request() throws IOException, OAuthException, URISyntaxException {
        OAuthAccessor accessor = this.createOAuthAccessor();
        OAuthClient client = this.getOAuthClient(this.getHttpClient());
        client.getHttpParameters().put("connectTimeout", this.connectionTimeout);
        client.getHttpParameters().put("readTimeout", this.readTimeout);
        HashMap<String, String> requestMap = new HashMap<String, String>();
        this.addAdditionalParametersToRequestParams(requestMap, this.props);
        client.getRequestToken(accessor, "GET", requestMap.entrySet());
        this.props.put(REQUEST_TOKEN, accessor.requestToken);
        this.props.put(TOKEN_SECRET, accessor.tokenSecret);
    }

    protected abstract void addAdditionalParametersToRequestParams(Map<String, String> var1, Map<String, String> var2);

    public void access() throws IOException, OAuthException, URISyntaxException {
        HashMap<String, String> paramProps = new HashMap<String, String>();
        if (!this.props.containsKey(REQUEST_TOKEN)) {
            OrderMate.LOG.error(this.getClass().getName() + " does not have an OAuth Request Token to give to the webservice!");
            return;
        }
        paramProps.put(OAUTH_TOKEN, this.props.get(REQUEST_TOKEN));
        OAuthMessage response = this.sendRequest("GET", paramProps, this.props.get("accessUrl"));
        this.props.put(ACCESS_TOKEN, response.getParameter(OAUTH_TOKEN));
        this.props.put(TOKEN_SECRET, response.getParameter(OAUTH_TOKEN_SECRET));
    }

    public void authorize() throws IOException, OAuthException, URISyntaxException {
        HashMap<String, String> paramProps = new HashMap<String, String>();
        paramProps.put(OAUTH_TOKEN, this.props.get(REQUEST_TOKEN));
        OAuthAccessor accessor = this.createOAuthAccessor();
        OAuthMessage response = this.sendRequest("GET", paramProps, accessor.consumer.serviceProvider.userAuthorizationURL);
    }

    public OAuthMessage prepareRequest(String httpMethod, String resource, String jsonData, String mediatype) throws IOException, OAuthException, URISyntaxException {
        HashMap<String, String> paramProps = new HashMap<String, String>();
        if (!this.hasAccessToken()) {
            OrderMate.LOG.debug(this.getClass().getName() + " does not have an OAuth Access Token to give to the webservice!");
            return null;
        }
        paramProps.put(OAUTH_TOKEN, this.props.get(ACCESS_TOKEN));
        return this.sendRequest(httpMethod, paramProps, resource, jsonData, mediatype);
    }

    public OAuthMessage getResource(String resourceURL) throws IOException, OAuthException, URISyntaxException {
        return this.prepareRequest("GET", resourceURL, null, "application/json");
    }

    public OAuthMessage postResource(String resourceURL, Object jsonData, String mediaType) throws IOException, OAuthException, URISyntaxException {
        return this.prepareRequest("POST", resourceURL, jsonData.toString(), mediaType);
    }

    public OAuthMessage putResource(String resourceURL, Object data) throws IOException, OAuthException, URISyntaxException {
        return this.prepareRequest("PUT", resourceURL, data.toString(), "application/json");
    }

    public boolean hasAccessToken() {
        return this.props.containsKey(ACCESS_TOKEN);
    }

    protected Map<String, String> getRawMap() {
        return this.props;
    }

    protected OAuthClient getOAuthClient(HttpClient httpClient) {
        return new OAuthClient(httpClient);
    }

    protected HttpClient getHttpClient() {
        return new HttpClient4();
    }

    private static class MessageWithBody
    extends OAuthMessage {
        private final byte[] body;

        public MessageWithBody(String method, String URL2, Collection<? extends Map.Entry> parameters, String contentType, byte[] body) {
            super(method, URL2, parameters);
            this.body = body;
            List headers = this.getHeaders();
            if (body != null) {
                headers.add(new OAuth.Parameter("Content-Length", String.valueOf(body.length)));
            }
            if (contentType != null) {
                headers.add(new OAuth.Parameter("Content-Type", contentType));
            }
        }

        public InputStream getBodyAsStream() {
            return this.body == null ? null : new ByteArrayInputStream(this.body);
        }
    }
}

