/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.webservice;

import java.util.HashMap;
import java.util.Map;
import ordermate.OrderMate;

public class OAuthMapBuilder {
    public static final String ACCESS_URL = "accessUrl";
    public static final String REQUEST_URL = "requestUrl";
    public static final String AUTHORIZATION_URL = "authorizationUrl";
    public static final String CONSUMER_KEY = "consumerKey";
    public static final String CONSUMER_SECRET = "consumerSecret";
    public static final String PRIVATE_KEY = "privateKey";
    private Map<String, String> localMap = new HashMap<String, String>();
    private static final String[] DEFAULT_VALID_KEYS = new String[]{"accessUrl", "requestUrl", "consumerKey", "consumerSecret"};
    private String[] validMapKeys;

    public OAuthMapBuilder() {
        this(DEFAULT_VALID_KEYS);
    }

    public OAuthMapBuilder(String[] validMapKeys) {
        this.validMapKeys = validMapKeys;
    }

    public Map buildMap() {
        if (!this.validMap()) {
            return null;
        }
        return this.localMap;
    }

    private boolean validMap() {
        if (this.validMapKeys != null) {
            for (String key : this.validMapKeys) {
                if (this.localMap.containsKey(key)) continue;
                OrderMate.LOG.error("Invalid OAuth map, doesn't contain:" + key);
                return false;
            }
        }
        return true;
    }

    public OAuthMapBuilder addParameter(String paramKey, String value) {
        this.localMap.put(paramKey, value);
        return this;
    }

    public OAuthMapBuilder addKey(String value) {
        this.localMap.put(CONSUMER_KEY, value);
        return this;
    }

    public OAuthMapBuilder addSecret(String value) {
        this.localMap.put(CONSUMER_SECRET, value);
        return this;
    }

    public OAuthMapBuilder addRequestURL(String value) {
        this.localMap.put(REQUEST_URL, value);
        return this;
    }

    public OAuthMapBuilder addAuthorizationURL(String value) {
        this.localMap.put(AUTHORIZATION_URL, value);
        return this;
    }

    public OAuthMapBuilder addAccessURL(String value) {
        this.localMap.put(ACCESS_URL, value);
        return this;
    }

    public OAuthMapBuilder addPrivateKey(String value) {
        this.localMap.put(PRIVATE_KEY, value);
        return this;
    }
}

