/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.webservice;

import au.com.ordermate.util.Pair;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import ordermate.OrderMate;
import ordermate.webresource.SerializableMessageBodyReader;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.eclipse.persistence.jaxb.rs.MOXyJsonProvider;

public class RestHelper {
    public static final int DEF_CONNECTION_TIMEOUT = 15000;
    public static final int DEF_READ_TIMEOUT = 30000;
    public static final String TLSv12 = "TLSv1.2";
    private List<Class> clientConfigClasses;

    public RestHelper() {
    }

    public RestHelper(Class ... clientConfigClasses) {
        this.clientConfigClasses = new ArrayList<Class>(clientConfigClasses.length);
        for (Class c : clientConfigClasses) {
            this.clientConfigClasses.add(c);
        }
    }

    public Client getClient() {
        return this.getClient(60000, 600000);
    }

    public Client getClient(Integer connectTimeoutInterval, Integer readTimeoutInterval) {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getProperties().put("com.sun.jersey.client.property.connectTimeout", connectTimeoutInterval);
        clientConfig.getProperties().put("com.sun.jersey.client.property.readTimeout", readTimeoutInterval);
        if (this.clientConfigClasses != null) {
            for (Class c : this.clientConfigClasses) {
                clientConfig.getClasses().add(c);
            }
        } else {
            clientConfig.getClasses().add(SerializableMessageBodyReader.class);
            clientConfig.getClasses().add(MOXyJsonProvider.class);
        }
        return Client.create((ClientConfig)clientConfig);
    }

    public WebResource getResource(String url, Integer connectTimeoutInterval, Integer readTimeoutInterval) {
        Client client = this.getClient(connectTimeoutInterval, readTimeoutInterval);
        client.setConnectTimeout(connectTimeoutInterval);
        client.setReadTimeout(readTimeoutInterval);
        return client.resource(url);
    }

    public WebResource getResource(String url) {
        return this.getResource(url, 15000, 30000);
    }

    public WebResource addBasicAuth(WebResource resource, String username, String password) {
        if (username != null && password != null) {
            resource.addFilter((ClientFilter)new HTTPBasicAuthFilter(username, password));
        }
        return resource;
    }

    public WebResource addBearerAuth(WebResource resource, String accessToken) {
        resource.addFilter((ClientFilter)new HttpHeaderFilter("Authorization", "Bearer " + accessToken));
        return resource;
    }

    public WebResource addHeader(WebResource resource, String key, String value) {
        resource.addFilter((ClientFilter)new HttpHeaderFilter(key, value));
        return resource;
    }

    public String getXml(WebResource resource) {
        return (String)resource.accept(new String[]{"application/xml"}).get(String.class);
    }

    public String getText(WebResource resource) {
        return (String)resource.accept(new String[]{"text/plain"}).get(String.class);
    }

    public <T> T getObject(WebResource resource, Class<T> clazz) {
        return (T)resource.accept(new String[]{"application/octet-stream"}).get(clazz);
    }

    public WebResource addParameter(WebResource resource, String key, String value) {
        if (value != null) {
            return resource.queryParam(key, value);
        }
        return resource;
    }

    public WebResource getSslResource(String url, X509TrustManager trustManager, Integer connectTimeout, Integer readTimeout) {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        try {
            AllowAllHostnameVerifier hostnameVerifier = new AllowAllHostnameVerifier();
            SSLContext context = this.getSSLContext(trustManager);
            HTTPSProperties properties = new HTTPSProperties((HostnameVerifier)hostnameVerifier, context);
            clientConfig.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", properties);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot create SSL Resource", (Throwable)ex);
        }
        Client client = Client.create((ClientConfig)clientConfig);
        client.setConnectTimeout(connectTimeout);
        client.setReadTimeout(readTimeout);
        return client.resource(url);
    }

    public WebResource getSSLWebResource(String url, X509TrustManager trustManager, Integer connectTimeout, Integer readTimeout, String httpsProtocol) {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        try {
            HostnameVerifier hostnameVerifier = null;
            SSLContext context = this.getSSLContext(trustManager, httpsProtocol);
            HTTPSProperties properties = new HTTPSProperties(hostnameVerifier, context);
            clientConfig.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", properties);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot create SSL Resource", (Throwable)ex);
        }
        clientConfig.getClasses().add(SerializableMessageBodyReader.class);
        clientConfig.getClasses().add(MOXyJsonProvider.class);
        Client client = Client.create((ClientConfig)clientConfig);
        client.setConnectTimeout(connectTimeout);
        client.setReadTimeout(readTimeout);
        return client.resource(url);
    }

    public SSLContext getSSLContext(X509TrustManager trustManager) {
        return this.getSSLContext(trustManager, "SSL");
    }

    private SSLContext getSSLContext(X509TrustManager trustManager, String httpsProtocol) {
        try {
            TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore ksTrust = KeyStore.getInstance("JKS");
            factory.init(ksTrust);
            TrustManager[] trustManagers = new TrustManager[]{trustManager};
            SSLContext context = SSLContext.getInstance(httpsProtocol);
            context.init(null, trustManagers, null);
            return context;
        }
        catch (Exception e) {
            OrderMate.LOG.error("Cannot create SSL Context", (Throwable)e);
            return null;
        }
    }

    public static final class HttpHeaderFilter
    extends ClientFilter {
        private final Pair<String, String>[] pairs;

        public HttpHeaderFilter(String key, String value) {
            this(new Pair<String, String>(key, value));
        }

        public HttpHeaderFilter(Pair<String, String> ... pairs) {
            this.pairs = pairs;
        }

        public ClientResponse handle(ClientRequest arg0) throws ClientHandlerException {
            for (Pair<String, String> pair : this.pairs) {
                arg0.getHeaders().putSingle(pair.key, pair.value);
            }
            return this.getNext().handle(arg0);
        }
    }
}

