/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.webservice;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import ordermate.OrderMate;

public class WrappingX509TrustManager
implements X509TrustManager {
    private static final String OM_KEYSTORE_FILE = "c:\\temp\\ordermate.ks";
    protected X509TrustManager sunJSSEX509TrustManager;
    protected KeyStore keyStore;

    public WrappingX509TrustManager() throws Exception {
        TrustManager[] tms;
        this.loadKeystore();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
        tmf.init(this.keyStore);
        for (TrustManager tm : tms = tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            this.sunJSSEX509TrustManager = (X509TrustManager)tm;
            return;
        }
        throw new Exception("Couldn't initialize");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadKeystore() throws Exception {
        this.keyStore = KeyStore.getInstance("JKS", "SUN");
        boolean loaded = true;
        FileInputStream fin = null;
        try {
            this.keyStore.load(new FileInputStream(new File(OM_KEYSTORE_FILE)), "omkeystore_integration".toCharArray());
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot load keystore file, missing or corrupted.", (Throwable)ex);
            loaded = false;
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException ex) {
                    OrderMate.LOG.error("Cannot close off keyfile", (Throwable)ex);
                }
            }
        }
        if (!loaded) {
            try {
                this.keyStore.load(null, "omkeystore_integration".toCharArray());
                this.saveKeystore();
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot create blank keystore:", (Throwable)ex);
            }
        }
    }

    protected void saveKeystore() throws Exception {
        OutputStream fout = null;
        try {
            fout = new FileOutputStream(new File(OM_KEYSTORE_FILE));
            this.keyStore.store(fout, "omkeystore_integration".toCharArray());
            OrderMate.LOG.info("Keystore created:c:\\temp\\ordermate.ks");
        }
        catch (IOException ex) {
            OrderMate.LOG.warn("Cannot save keystore", (Throwable)ex);
        }
        finally {
            if (fout != null) {
                try {
                    fout.flush();
                    ((FileOutputStream)fout).close();
                }
                catch (IOException ex) {
                    OrderMate.LOG.error("Couldn't save keystore to file, may be invalid:", (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        block3: {
            try {
                if (this.delegateClient(chain, authType)) {
                    this.sunJSSEX509TrustManager.checkClientTrusted(chain, authType);
                }
            }
            catch (CertificateException ex) {
                if (this.handleClientMistrust(ex, chain, authType)) break block3;
                throw ex;
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            if (this.delegateServer(chain, authType)) {
                for (X509Certificate cert : chain) {
                    cert.checkValidity();
                }
                this.sunJSSEX509TrustManager.checkServerTrusted(chain, authType);
            }
        }
        catch (CertificateException ex) {
            OrderMate.LOG.info("Got rejected certificate:", (Throwable)ex);
            if (!this.handleServerMistrust(ex, chain, authType)) {
                throw ex;
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.info("Got rejected certificate:", (Throwable)ex);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.sunJSSEX509TrustManager.getAcceptedIssuers();
    }

    protected X509TrustManager getWrappedTrustManager() {
        return this.sunJSSEX509TrustManager;
    }

    protected KeyStore getWrappedKeyStore() {
        return this.keyStore;
    }

    protected boolean delegateServer(X509Certificate[] chain, String authType) {
        return true;
    }

    protected boolean delegateClient(X509Certificate[] chain, String authType) {
        return true;
    }

    protected boolean handleServerMistrust(CertificateException ex, X509Certificate[] chain, String authType) {
        return false;
    }

    protected boolean handleClientMistrust(CertificateException ex, X509Certificate[] chain, String authType) {
        return false;
    }
}

